/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import [Ljava.lang.Object;;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ArgumentInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

public class InitiatorInfo
extends ArgumentInfo {
    private final Object _init;

    public InitiatorInfo(Class cls, Map args) {
        super(args);
        InitiatorInfo.checkClass(cls);
        this._init = cls;
    }

    public InitiatorInfo(String clsnm, Map args) throws ClassNotFoundException {
        super(args);
        this._init = InitiatorInfo.toClass(clsnm);
    }

    public InitiatorInfo(Initiator init, Map args) {
        super(args);
        if (init == null) {
            throw new IllegalArgumentException("null");
        }
        this._init = init;
    }

    private static Object toClass(String clsnm) throws ClassNotFoundException {
        if (clsnm == null || clsnm.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (clsnm.indexOf("${") < 0) {
            try {
                Class cls = Classes.forNameByThread((String)clsnm);
                InitiatorInfo.checkClass(cls);
                return cls;
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm, ex);
            }
        }
        return new ExValue(clsnm, String.class);
    }

    private static void checkClass(Class cls) {
        if (!Initiator.class.isAssignableFrom(cls)) {
            throw new UiException(Initiator.class + " must be implemented: " + cls);
        }
    }

    public Initiator newInitiator(PageDefinition pgdef, Page page) throws Exception {
        return this.newInitiator(pgdef.getEvaluator(), page);
    }

    public Initiator newInitiator(Evaluator eval, Page page) throws Exception {
        Class cls;
        if (this._init instanceof Initiator) {
            return this.doInit((Initiator)this._init, eval, page);
        }
        if (this._init instanceof ExValue) {
            String clsnm = (String)((ExValue)this._init).getValue(eval, page);
            if (clsnm == null || clsnm.length() == 0) {
                return null;
            }
            try {
                cls = Classes.forNameByThread((String)clsnm);
                InitiatorInfo.checkClass(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Class not found: " + clsnm + " (" + this._init + ")", ex);
            }
        } else {
            cls = (Class)this._init;
        }
        return this.doInit((Initiator)cls.newInstance(), eval, page);
    }

    private Initiator doInit(Initiator init, Evaluator eval, Page page) throws Exception {
        Map args = this.resolveArguments(eval, page);
        try {
            init.doInit(page, args);
        }
        catch (AbstractMethodError ex) {
            Method m = init.getClass().getMethod("doInit", Page.class, Object;.class);
            Fields.setAccessible((AccessibleObject)m, (boolean)true);
            m.invoke((Object)init, page, InitiatorInfo.toArray(args));
        }
        return init;
    }
}

