/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.render;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.xml.XMLs;

public class Out {
    private String _value;
    private int _maxlength;
    private boolean _escapeXML = true;
    private boolean _nbsp;
    private boolean _pre;

    public Out(String value) {
        this._value = value;
    }

    public boolean getEscapeXML() {
        return this._escapeXML;
    }

    public Out setEscapeXML(boolean escapeXML) {
        this._escapeXML = escapeXML;
        return this;
    }

    public boolean getNbsp() {
        return this._escapeXML;
    }

    public Out setNbsp(boolean nbsp) {
        this._nbsp = nbsp;
        return this;
    }

    public String getValue() {
        return this._value;
    }

    public Out setValue(String value) {
        this._value = value;
        return this;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public Out setMaxlength(int maxlength) {
        this._maxlength = maxlength;
        return this;
    }

    public void setPre(boolean pre) {
        this._pre = pre;
    }

    public boolean isPre() {
        return this._pre;
    }

    public void render(Writer out) throws IOException {
        int len;
        int n = len = this._value != null ? this._value.length() : 0;
        if (len == 0 || this._nbsp && this._value.trim().length() == 0) {
            if (this._nbsp) {
                out.write("&nbsp;");
            }
            return;
        }
        String value = this._value;
        if (this._maxlength > 0 && len > this._maxlength) {
            int j;
            for (j = this._maxlength; j > 0 && Character.isWhitespace(value.charAt(j - 1)); --j) {
            }
            value = value.substring(0, j) + "...";
        }
        if (this._escapeXML) {
            StringBuffer sb = null;
            len = value.length();
            for (int j = 0; j < len; ++j) {
                char cc = value.charAt(j);
                String replace = this._pre && cc == ' ' ? "&nbsp;" : XMLs.escapeXML((char)cc);
                if (replace != null) {
                    if (sb == null) {
                        sb = new StringBuffer(value.length() + 10);
                        sb.append(value.substring(0, j));
                    }
                    sb.append(replace);
                    continue;
                }
                if (sb == null) continue;
                sb.append(cc);
            }
            if (sb != null) {
                value = sb.toString();
            }
        }
        out.write(value);
    }
}

