/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.InitiatorExt;

public class Composition
implements Initiator,
InitiatorExt {
    private static final String RESOLVE_COMPOSITION = "zk.ui.util.RESOLVE_COMPOSITION";
    public static final String PARENT = "zk.ui.util.PARENT";

    public void doAfterCompose(Page page) throws Exception {
    }

    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    public void doInit(Page page, Map args) throws Exception {
        Execution exec = Executions.getCurrent();
        if (exec.getAttribute(RESOLVE_COMPOSITION) == null) {
            exec.setAttribute(RESOLVE_COMPOSITION, this);
        }
        Component parent = (Component)exec.getAttribute(PARENT);
        Iterator it = args.values().iterator();
        while (it.hasNext()) {
            exec.createComponents((String)it.next(), parent, null);
        }
    }

    public void doAfterCompose(Page page, Component[] comps) throws Exception {
        Execution exec = Executions.getCurrent();
        if (exec.getAttribute(RESOLVE_COMPOSITION) != this) {
            return;
        }
        exec.removeAttribute(RESOLVE_COMPOSITION);
        HashMap insertMap = new HashMap();
        Component parent = (Component)exec.getAttribute(PARENT);
        Collection roots = parent == null ? page.getRoots() : parent.getChildren();
        this.resolveInsertComponents(roots, insertMap);
        if (!roots.isEmpty()) {
            Component nextRoot;
            Component comp = (Component)roots.iterator().next();
            do {
                nextRoot = comp.getNextSibling();
                Annotation annt = ((ComponentCtrl)((Object)comp)).getAnnotation("define");
                if (annt == null) continue;
                String joinId = annt.getAttribute("value");
                Component insertComp = (Component)insertMap.get(joinId);
                if (insertComp != null) {
                    comp.setParent(insertComp);
                    continue;
                }
                comp.detach();
            } while ((comp = nextRoot) != null);
        }
    }

    private void resolveInsertComponents(Collection comps, Map map) {
        Iterator it = comps.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            Annotation annt = ((ComponentCtrl)((Object)comp)).getAnnotation("insert");
            if (annt != null) {
                String insertName = annt.getAttribute("value");
                if (map.containsKey(insertName)) {
                    throw new UiException("Duplicate insert name: " + insertName + " at Component " + comp);
                }
                map.put(insertName, comp);
            }
            this.resolveInsertComponents(comp.getChildren(), map);
        }
    }
}

