/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.io.Serializable;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.NamespaceActivationListener;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.GenericEventListener;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;

public abstract class GenericComposer
extends GenericEventListener
implements Composer,
ComposerExt,
NamespaceActivationListener,
Serializable {
    private static final long serialVersionUID = 20091006115555L;
    private String _applied;

    public void doAfterCompose(Component comp) throws Exception {
        this._applied = comp.getUuid();
        this.bindComponent(comp);
    }

    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) {
        return compInfo;
    }

    public void doBeforeComposeChildren(Component comp) throws Exception {
        Components.wireController(comp, this);
    }

    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    public void doFinally() throws Exception {
    }

    public void willPassivate(Namespace ns) {
    }

    public void didActivate(Namespace ns) {
    }

    protected Component getAppliedComponent(Namespace ns) {
        Component owner = ns.getOwner();
        Desktop dt = null;
        if (owner != null) {
            dt = owner.getDesktop();
        } else {
            Page page = ns.getOwnerPage();
            if (page != null) {
                dt = page.getDesktop();
            }
        }
        if (dt != null) {
            return dt.getComponentByUuidIfAny(this._applied);
        }
        return null;
    }
}

