/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkex.zul.Fisheyebar;
import org.zkoss.zul.impl.XulElement;

public class Fisheye
extends XulElement
implements org.zkoss.zkex.zul.api.Fisheye {
    private String _image;
    private String _label = "";

    public Fisheye() {
    }

    public Fisheye(String label, String image) {
        this();
        this.setLabel(label);
        this.setImage(image);
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        if (label == null) {
            label = "";
        }
        if (!Objects.equals((Object)this._label, (Object)label)) {
            this._label = label;
            this.invalidate();
        }
    }

    public String getImage() {
        return this._image;
    }

    public void setImage(String image) {
        if (image != null && image.length() == 0) {
            image = null;
        }
        if (!Objects.equals((Object)this._image, (Object)image)) {
            this._image = image;
            this.invalidate();
        }
    }

    protected String getRealStyle() {
        String style = super.getRealStyle();
        Fisheyebar bar = (Fisheyebar)this.getParent();
        if (bar == null) {
            return style;
        }
        StringBuffer sb = new StringBuffer(32).append(style);
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)(bar.getItemWidth() + "px"));
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)(bar.getItemWidth() + "px"));
        return sb.toString();
    }

    public String getZclass() {
        return this._zclass == null ? "z-fisheye" : this._zclass;
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("readonly");
    }

    public void setHeight(String height) {
        throw new UnsupportedOperationException("readonly");
    }

    public String getOuterAttrs() {
        String outer = super.getOuterAttrs();
        if (!Strings.isBlank((String)this._label)) {
            outer = outer + " z.label=\"true\"";
        }
        return outer;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Fisheyebar)) {
            throw new UiException("Unsupported parent for fisheye: " + parent);
        }
        super.setParent(parent);
    }

    public boolean isChildable() {
        return false;
    }
}

