/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul.impl;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.CategoryLabelEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.WaferMapPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.WaferMapRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.WaferMapDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.DefaultWindDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataItem;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;
import org.zkoss.lang.Objects;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Area;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.Chart;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.GanttModel;
import org.zkoss.zul.HiLoModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.WaferMapModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.XYZModel;
import org.zkoss.zul.impl.ChartEngine;

public class JFreeChartEngine
implements ChartEngine,
Serializable {
    private static final String DEFAULT_HI_LO_SERIES = "High Low Data";
    private static final SimpleDateFormat _dateFormat = new SimpleDateFormat();
    private transient boolean _threeD;
    private transient String _type;
    private transient ChartImpl _chartImpl;
    private static Map _periodMap = new HashMap(10);

    private ChartImpl getChartImpl(Chart chart) {
        if (Objects.equals((Object)chart.getType(), (Object)this._type) && this._threeD == chart.isThreeD()) {
            return this._chartImpl;
        }
        if ("pie".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Pie3d() : new Pie();
        } else if ("ring".equals(chart.getType())) {
            this._chartImpl = new Ring();
        } else if ("bar".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Bar3d() : new Bar();
        } else if ("line".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Line3d() : new Line();
        } else if ("area".equals(chart.getType())) {
            this._chartImpl = new AreaImpl();
        } else if ("stacked_bar".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new StackedBar3d() : new StackedBar();
        } else if ("stacked_area".equals(chart.getType())) {
            this._chartImpl = new StackedArea();
        } else if ("waterfall".equals(chart.getType())) {
            this._chartImpl = new Waterfall();
        } else if ("polar".equals(chart.getType())) {
            this._chartImpl = new Polar();
        } else if ("scatter".equals(chart.getType())) {
            this._chartImpl = new Scatter();
        } else if ("time_series".equals(chart.getType())) {
            this._chartImpl = new TimeSeries();
            TimeZone tz = chart.getTimeZone();
            if (tz != null) {
                _dateFormat.setTimeZone(tz);
            }
            if (chart.getDateFormat() != null) {
                _dateFormat.applyPattern(chart.getDateFormat());
            }
        } else if ("step_area".equals(chart.getType())) {
            this._chartImpl = new StepArea();
        } else if ("step".equals(chart.getType())) {
            this._chartImpl = new Step();
        } else if ("histogram".equals(chart.getType())) {
            this._chartImpl = new Histogram();
        } else if ("candlestick".equals(chart.getType())) {
            this._chartImpl = new Candlestick();
            TimeZone tz = chart.getTimeZone();
            if (tz != null) {
                _dateFormat.setTimeZone(tz);
            }
            if (chart.getDateFormat() != null) {
                _dateFormat.applyPattern(chart.getDateFormat());
            }
        } else if ("highlow".equals(chart.getType())) {
            this._chartImpl = new Highlow();
            TimeZone tz = chart.getTimeZone();
            if (tz != null) {
                _dateFormat.setTimeZone(tz);
            }
            if (chart.getDateFormat() != null) {
                _dateFormat.applyPattern(chart.getDateFormat());
            }
        } else if ("bubble".equals(chart.getType())) {
            this._chartImpl = new Bubble();
        } else if ("wafermap".equals(chart.getType())) {
            this._chartImpl = new Wafermap();
        } else if ("gantt".equals(chart.getType())) {
            this._chartImpl = new Gantt();
            TimeZone tz = chart.getTimeZone();
            if (tz != null) {
                _dateFormat.setTimeZone(tz);
            }
            if (chart.getDateFormat() == null) {
                _dateFormat.applyPattern("MMM d ''yy");
            } else {
                _dateFormat.applyPattern(chart.getDateFormat());
            }
        } else if ("wind".equals(chart.getType())) {
            this._chartImpl = new Wind();
            TimeZone tz = chart.getTimeZone();
            if (tz != null) {
                _dateFormat.setTimeZone(tz);
            }
            if (chart.getDateFormat() != null) {
                _dateFormat.applyPattern(chart.getDateFormat());
            }
        } else {
            throw new UiException("Unsupported chart type yet: " + chart.getType());
        }
        this._threeD = chart.isThreeD();
        this._type = chart.getType();
        return this._chartImpl;
    }

    protected boolean prepareJFreeChart(JFreeChart jfchart, Chart chart) {
        return false;
    }

    public byte[] drawChart(Object data) {
        Chart chart = (Chart)data;
        ChartImpl impl = this.getChartImpl(chart);
        JFreeChart jfchart = impl.createChart(chart);
        if (!this.prepareJFreeChart(jfchart, chart)) {
            int[] paneRGB;
            Plot plot = jfchart.getPlot();
            float alpha = (float)chart.getFgAlpha() / 255.0f;
            plot.setForegroundAlpha(alpha);
            alpha = (float)chart.getBgAlpha() / 255.0f;
            plot.setBackgroundAlpha(alpha);
            int[] bgRGB = chart.getBgRGB();
            if (bgRGB != null) {
                plot.setBackgroundPaint((Paint)new Color(bgRGB[0], bgRGB[1], bgRGB[2], chart.getBgAlpha()));
            }
            if ((paneRGB = chart.getPaneRGB()) != null) {
                jfchart.setBackgroundPaint((Paint)new Color(paneRGB[0], paneRGB[1], paneRGB[2], chart.getPaneAlpha()));
            }
        }
        ChartRenderingInfo jfinfo = new ChartRenderingInfo();
        BufferedImage bi = jfchart.createBufferedImage(chart.getIntWidth(), chart.getIntHeight(), 3, jfinfo);
        chart.getChildren().clear();
        int j = 0;
        String preUrl = null;
        Iterator it = jfinfo.getEntityCollection().iterator();
        while (it.hasNext()) {
            ChartEntity ce = (ChartEntity)it.next();
            String url = ce.getURLText();
            if (url != null) {
                if (preUrl == null) {
                    preUrl = url;
                } else if (url.equals(preUrl)) break;
            }
            Area area = new Area();
            area.setParent((Component)chart);
            area.setCoords(ce.getShapeCoords());
            area.setShape(ce.getShapeType());
            area.setId("area_" + chart.getId() + '_' + j++);
            if (chart.isShowTooltiptext() && ce.getToolTipText() != null) {
                area.setTooltiptext(ce.getToolTipText());
            }
            area.setAttribute("url", (Object)ce.getURLText());
            impl.render(chart, area, ce);
            if (chart.getAreaListener() == null) continue;
            try {
                chart.getAreaListener().onRender(area, (Object)ce);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        chart.removeAttribute("LEGEND_SEQ");
        chart.removeAttribute("TICK_SEQ");
        try {
            return EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    private PieDataset PieModelToPieDataset(PieModel model) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        Iterator it = model.getCategories().iterator();
        while (it.hasNext()) {
            Comparable category = (Comparable)it.next();
            Number value = model.getValue(category);
            dataset.setValue(category, value);
        }
        return dataset;
    }

    private PieDataset CategoryModelToPieDataset(CategoryModel model) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        Comparable defaultSeries = null;
        int max = 0;
        Iterator it = model.getKeys().iterator();
        while (it.hasNext()) {
            List key = (List)it.next();
            Comparable series = (Comparable)key.get(0);
            if (defaultSeries == null) {
                defaultSeries = series;
                max = model.getCategories().size();
            }
            if (!Objects.equals((Object)defaultSeries, (Object)series)) continue;
            Comparable category = (Comparable)key.get(1);
            Number value = model.getValue(series, category);
            dataset.setValue(category, value);
            if (--max != 0) continue;
            break;
        }
        return dataset;
    }

    private CategoryDataset CategoryModelToCategoryDataset(CategoryModel model) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator it = model.getKeys().iterator();
        while (it.hasNext()) {
            List key = (List)it.next();
            Comparable series = (Comparable)key.get(0);
            Comparable category = (Comparable)key.get(1);
            Number value = model.getValue(series, category);
            dataset.setValue(value, series, category);
        }
        return dataset;
    }

    private XYDataset XYModelToXYDataset(XYModel model) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable series = (Comparable)it.next();
            XYSeries xyser = new XYSeries(series, model.isAutoSort());
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                xyser.add(model.getX(series, j), model.getY(series, j), false);
            }
            dataset.addSeries(xyser);
        }
        return dataset;
    }

    private TableXYDataset XYModelToTableXYDataset(XYModel model) {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable series = (Comparable)it.next();
            XYSeries xyser = new XYSeries(series, false, false);
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                xyser.add(model.getX(series, j), model.getY(series, j), false);
            }
            dataset.addSeries(xyser);
        }
        return dataset;
    }

    private XYDataset XYModelToTimeDataset(XYModel model, Chart chart) {
        Class pclass;
        String p;
        TimeZone tz = chart.getTimeZone();
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        if ((p = chart.getPeriod()) == null) {
            p = "millisecond";
        }
        if ((pclass = (Class)_periodMap.get(p)) == null) {
            throw new UiException("Unsupported period for Time Series chart: " + p);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(tz);
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable series = (Comparable)it.next();
            org.jfree.data.time.TimeSeries tser = new org.jfree.data.time.TimeSeries(series, pclass);
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                RegularTimePeriod period = RegularTimePeriod.createInstance((Class)pclass, (Date)new Date(model.getX(series, j).longValue()), (TimeZone)tz);
                tser.addOrUpdate(period, model.getY(series, j));
            }
            dataset.addSeries(tser);
        }
        return dataset;
    }

    private XYZDataset XYZModelToXYZDataset(XYZModel model) {
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable seriesKey = (Comparable)it.next();
            int size = model.getDataCount(seriesKey);
            double[][] data = new double[3][size];
            for (int j = 0; j < size; ++j) {
                data[0][j] = model.getX(seriesKey, j).doubleValue();
                data[1][j] = model.getY(seriesKey, j).doubleValue();
                data[2][j] = model.getZ(seriesKey, j).doubleValue();
            }
            dataset.addSeries(seriesKey, data);
        }
        return dataset;
    }

    private WaferMapDataset WaferMapModelToWaferMapDataset(WaferMapModel model) {
        WaferMapDataset dataset = new WaferMapDataset(model.getXsize(), model.getYsize(), (Number)new Double(model.getSpace()));
        Iterator it = model.getEntrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            WaferMapModel.IntPair ip = (WaferMapModel.IntPair)me.getKey();
            Number val = (Number)me.getValue();
            int x = ip.getX() + 1;
            int y = ip.getY();
            dataset.addValue(val.intValue(), x, y);
        }
        return dataset;
    }

    private GanttCategoryDataset GanttModelToGanttDataset(GanttModel model) {
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        Comparable[] allseries = model.getAllSeries();
        int sz = allseries.length;
        for (int j = 0; j < sz; ++j) {
            Comparable series = allseries[j];
            TaskSeries taskseries = new TaskSeries((String)((Object)series));
            GanttModel.GanttTask[] tasks = model.getTasks(series);
            int tsz = tasks.length;
            for (int k = 0; k < tsz; ++k) {
                GanttModel.GanttTask task = tasks[k];
                Task jtask = this.newTask(task);
                this.addSubtask(jtask, task);
                taskseries.add(jtask);
            }
            dataset.add(taskseries);
        }
        return dataset;
    }

    private Task newTask(GanttModel.GanttTask task) {
        Task jtask = new Task(task.getDescription(), task.getStart(), task.getEnd());
        jtask.setPercentComplete(task.getPercent());
        return jtask;
    }

    private void addSubtask(Task jtask, GanttModel.GanttTask task) {
        GanttModel.GanttTask[] tasks = task.getSubtasks();
        int sz = tasks.length;
        for (int j = 0; j < sz; ++j) {
            GanttModel.GanttTask subtask = tasks[j];
            Task jsubtask = this.newTask(subtask);
            jtask.addSubtask(jsubtask);
            this.addSubtask(jsubtask, subtask);
        }
    }

    private WindDataset XYZModelToWindDataset(XYZModel model) {
        Collection allseries = model.getSeries();
        int ssize = allseries.size();
        Object[][][] wobjs = new Object[ssize][][];
        int k = 0;
        Iterator it = allseries.iterator();
        while (it.hasNext()) {
            Comparable seriesKey = (Comparable)it.next();
            int size = model.getDataCount(seriesKey);
            Object[][] data = new Object[size][3];
            wobjs[k] = data;
            for (int j = 0; j < size; ++j) {
                data[j][0] = model.getX(seriesKey, j);
                data[j][1] = model.getY(seriesKey, j);
                data[j][2] = model.getZ(seriesKey, j);
            }
            ++k;
        }
        return new DefaultWindDataset((List)allseries, wobjs);
    }

    private OHLCDataset HiLoModelToOHLCDataset(HiLoModel model) {
        int size = model.getDataCount();
        OHLCDataItem[] items = new OHLCDataItem[size];
        for (int j = 0; j < size; ++j) {
            OHLCDataItem item;
            Date date = model.getDate(j);
            Number open = model.getOpen(j);
            Number high = model.getHigh(j);
            Number low = model.getLow(j);
            Number close = model.getClose(j);
            Number volume = model.getVolume(j);
            items[j] = item = new OHLCDataItem(date, this.doubleValue(open), this.doubleValue(high), this.doubleValue(low), this.doubleValue(close), this.doubleValue(volume));
        }
        Object series = model.getSeries();
        if (series == null) {
            series = DEFAULT_HI_LO_SERIES;
        }
        return new DefaultOHLCDataset((Comparable)series, items);
    }

    private double doubleValue(Number n) {
        return n == null ? 0.0 : n.doubleValue();
    }

    private void decodeLegendInfo(Area area, LegendItemEntity info, Chart chart) {
        if (info == null) {
            return;
        }
        ChartModel model = chart.getModel();
        int seq = (Integer)chart.getAttribute("LEGEND_SEQ");
        if (model instanceof PieModel) {
            Comparable category = ((PieModel)model).getCategory(seq);
            area.setAttribute("category", (Object)category);
            area.setAttribute("value", (Object)((PieModel)model).getValue(category));
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(category.toString());
            }
        } else if (model instanceof CategoryModel) {
            Comparable series = ((CategoryModel)model).getSeries(seq);
            area.setAttribute("series", (Object)series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        } else if (model instanceof XYModel) {
            Comparable series = ((XYModel)model).getSeries(seq);
            area.setAttribute("series", (Object)series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        } else if (model instanceof HiLoModel) {
            Object series = ((HiLoModel)model).getSeries();
            if (series == null) {
                series = DEFAULT_HI_LO_SERIES;
            }
            area.setAttribute("series", series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        } else if (model instanceof GanttModel) {
            Comparable series = info.getSeriesKey();
            area.setAttribute("series", (Object)series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        }
    }

    private void decodeTickLabelInfo(Area area, TickLabelEntity info, Chart chart) {
        if (info == null) {
            return;
        }
        ChartModel model = chart.getModel();
        int seq = (Integer)chart.getAttribute("TICK_SEQ");
        if (model instanceof CategoryModel) {
            Comparable category = ((CategoryModel)model).getCategory(seq);
            area.setAttribute("category", (Object)category);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(category.toString());
            }
        }
    }

    private void decodeCategoryLabelInfo(Area area, CategoryLabelEntity info, Chart chart) {
        Comparable category = info.getKey();
        area.setAttribute("category", (Object)category);
        if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
            area.setTooltiptext(category.toString());
        }
    }

    private void decodePieInfo(Area area, PieSectionEntity info) {
        if (info == null) {
            return;
        }
        PieDataset dataset = info.getDataset();
        Comparable category = info.getSectionKey();
        area.setAttribute("category", (Object)category);
        area.setAttribute("value", (Object)dataset.getValue(category));
    }

    private void decodeCategoryInfo(Area area, CategoryItemEntity info) {
        if (info == null) {
            return;
        }
        CategoryDataset dataset = info.getDataset();
        Comparable category = info.getColumnKey();
        Comparable series = info.getRowKey();
        area.setAttribute("series", (Object)series);
        area.setAttribute("category", (Object)category);
        if (dataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset gd = (GanttCategoryDataset)dataset;
            area.setAttribute("start", (Object)gd.getStartValue(series, category));
            area.setAttribute("end", (Object)gd.getEndValue(series, category));
            area.setAttribute("percent", (Object)gd.getPercentComplete(series, category));
        } else {
            area.setAttribute("value", (Object)dataset.getValue(series, category));
        }
    }

    private void decodeXYInfo(Area area, XYItemEntity info, Chart chart) {
        if (info == null) {
            return;
        }
        TimeZone tz = chart.getTimeZone();
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        XYDataset dataset = info.getDataset();
        int si = info.getSeriesIndex();
        int ii = info.getItem();
        area.setAttribute("series", (Object)dataset.getSeriesKey(si));
        if (dataset instanceof OHLCDataset) {
            OHLCDataset ds = (OHLCDataset)dataset;
            area.setAttribute("date", (Object)new Date(ds.getX(si, ii).longValue()));
            area.setAttribute("open", (Object)ds.getOpen(si, ii));
            area.setAttribute("high", (Object)ds.getHigh(si, ii));
            area.setAttribute("low", (Object)ds.getLow(si, ii));
            area.setAttribute("close", (Object)ds.getClose(si, ii));
            area.setAttribute("volume", (Object)ds.getVolume(si, ii));
        } else if (dataset instanceof XYZDataset) {
            XYZDataset ds = (XYZDataset)dataset;
            area.setAttribute("x", (Object)ds.getX(si, ii));
            area.setAttribute("y", (Object)ds.getY(si, ii));
            area.setAttribute("z", (Object)ds.getZ(si, ii));
        } else {
            area.setAttribute("x", (Object)dataset.getX(si, ii));
            area.setAttribute("y", (Object)dataset.getY(si, ii));
        }
    }

    private void setupDateAxis(JFreeChart jchart, Chart chart) {
        Plot plot = jchart.getPlot();
        DateAxis axisX = (DateAxis)((XYPlot)plot).getDomainAxis();
        TimeZone zone = chart.getTimeZone();
        if (zone != null) {
            axisX.setTimeZone(zone);
        }
        if (chart.getDateFormat() != null) {
            axisX.setDateFormatOverride((DateFormat)_dateFormat);
        }
    }

    protected String getGanttTaskTooltip(Date start, Date end, Number percent) {
        return new MessageFormat("{2,number,0.0%}, {0} ~ {1}").format(new Object[]{_dateFormat.format(start), _dateFormat.format(end), percent});
    }

    private PlotOrientation getOrientation(String orient) {
        return "horizontal".equals(orient) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
    }

    static {
        _periodMap.put("millisecond", Millisecond.class);
        _periodMap.put("second", Second.class);
        _periodMap.put("minute", Minute.class);
        _periodMap.put("hour", Hour.class);
        _periodMap.put("day", Day.class);
        _periodMap.put("week", Week.class);
        _periodMap.put("month", Month.class);
        _periodMap.put("quarter", Quarter.class);
        _periodMap.put("year", Year.class);
    }

    private class Wind
    extends ChartImpl {
        private Wind() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYZModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYZModel");
            }
            JFreeChart jchart = ChartFactory.createWindPlot((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (WindDataset)JFreeChartEngine.this.XYZModelToWindDataset((XYZModel)model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            JFreeChartEngine.this.setupDateAxis(jchart, chart);
            return jchart;
        }
    }

    private class Gantt
    extends ChartImpl {
        private Gantt() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                JFreeChartEngine.this.decodeCategoryLabelInfo(area, (CategoryLabelEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(this.ganttTooltip(chart, area));
                }
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof GanttModel)) {
                throw new UiException("model must be a org.zkoss.zul.GanttModel");
            }
            return ChartFactory.createGanttChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (IntervalCategoryDataset)JFreeChartEngine.this.GanttModelToGanttDataset((GanttModel)model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }

        private String ganttTooltip(Chart chart, Area area) {
            long start = ((Number)area.getAttribute("start")).longValue();
            Date startDate = new Date(start);
            long end = ((Number)area.getAttribute("end")).longValue();
            Date endDate = new Date(end);
            Number percent = (Number)area.getAttribute("percent");
            return JFreeChartEngine.this.getGanttTaskTooltip(startDate, endDate, percent);
        }
    }

    private static class MyWaferMapRenderer
    extends WaferMapRenderer {
        private boolean _inrender = false;

        private MyWaferMapRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Paint getSeriesPaint(int series) {
            if (this._inrender) {
                return null;
            }
            Paint paint = super.getSeriesPaint(series);
            if (paint != null) {
                return paint;
            }
            boolean pre = this._inrender;
            try {
                this._inrender = true;
                Paint paint2 = this.lookupSeriesPaint(series);
                return paint2;
            }
            finally {
                this._inrender = pre;
            }
        }
    }

    private class Wafermap
    extends ChartImpl {
        private Wafermap() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof WaferMapModel)) {
                throw new UiException("model must be a org.zkoss.zul.WaferMapModel");
            }
            JFreeChart jfchart = ChartFactory.createWaferMapChart((String)chart.getTitle(), (WaferMapDataset)JFreeChartEngine.this.WaferMapModelToWaferMapDataset((WaferMapModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            MyWaferMapRenderer renderer = new MyWaferMapRenderer();
            ((WaferMapPlot)jfchart.getPlot()).setRenderer((WaferMapRenderer)renderer);
            return jfchart;
        }
    }

    private class Bubble
    extends ChartImpl {
        private Bubble() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYZModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYZModel");
            }
            return ChartFactory.createBubbleChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYZDataset)JFreeChartEngine.this.XYZModelToXYZDataset((XYZModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Highlow
    extends ChartImpl {
        private Highlow() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof HiLoModel)) {
                throw new UiException("model must be a org.zkoss.zul.HiLoModel");
            }
            JFreeChart jchart = ChartFactory.createHighLowChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (OHLCDataset)JFreeChartEngine.this.HiLoModelToOHLCDataset((HiLoModel)model), (boolean)chart.isShowLegend());
            JFreeChartEngine.this.setupDateAxis(jchart, chart);
            return jchart;
        }
    }

    private class Candlestick
    extends ChartImpl {
        private Candlestick() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof HiLoModel)) {
                throw new UiException("model must be a org.zkoss.zul.HiLoModel");
            }
            JFreeChart jchart = ChartFactory.createCandlestickChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (OHLCDataset)JFreeChartEngine.this.HiLoModelToOHLCDataset((HiLoModel)model), (boolean)chart.isShowLegend());
            JFreeChartEngine.this.setupDateAxis(jchart, chart);
            return jchart;
        }
    }

    private class Histogram
    extends ChartImpl {
        private Histogram() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createHistogram((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (IntervalXYDataset)((IntervalXYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model)), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Step
    extends ChartImpl {
        private Step() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createXYStepChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StepArea
    extends ChartImpl {
        private StepArea() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createXYStepAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class TimeSeries
    extends ChartImpl {
        private TimeSeries() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            JFreeChart jchart = ChartFactory.createTimeSeriesChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToTimeDataset((XYModel)model, chart), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            JFreeChartEngine.this.setupDateAxis(jchart, chart);
            return jchart;
        }
    }

    private class Scatter
    extends ChartImpl {
        private Scatter() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createScatterPlot((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Polar
    extends ChartImpl {
        private Polar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createPolarChart((String)chart.getTitle(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Waterfall
    extends ChartImpl {
        private Waterfall() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createWaterfallChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StackedArea
    extends ChartImpl {
        private StackedArea() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createStackedAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createStackedXYAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (TableXYDataset)JFreeChartEngine.this.XYModelToTableXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class StackedBar3d
    extends StackedBar {
        private StackedBar3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createStackedBarChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StackedBar
    extends ChartImpl {
        private StackedBar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createStackedBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Line3d
    extends Line {
        private Line3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createLineChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Line
    extends ChartImpl {
        private Line() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createLineChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYLineChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class AreaImpl
    extends ChartImpl {
        private AreaImpl() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Bar3d
    extends Bar {
        private Bar3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createBarChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Bar
    extends ChartImpl {
        private Bar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodeXYInfo(area, (XYItemEntity)info, chart);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", (Object)"CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)JFreeChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (boolean)false, (String)chart.getYAxis(), (IntervalXYDataset)((IntervalXYDataset)JFreeChartEngine.this.XYModelToXYDataset((XYModel)model)), (PlotOrientation)JFreeChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Ring
    extends Pie {
        private Ring() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createRingChart((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Pie3d
    extends Pie {
        private Pie3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createPieChart3D((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Pie
    extends ChartImpl {
        private Pie() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", (Object)"LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", (Object)seq);
                JFreeChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof PieSectionEntity) {
                area.setAttribute("entity", (Object)"DATA");
                JFreeChartEngine.this.decodePieInfo(area, (PieSectionEntity)info);
            } else {
                area.setAttribute("entity", (Object)"TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        protected PieDataset getDataset(ChartModel model) {
            if (model instanceof CategoryModel) {
                return JFreeChartEngine.this.CategoryModelToPieDataset((CategoryModel)model);
            }
            if (model instanceof PieModel) {
                return JFreeChartEngine.this.PieModelToPieDataset((PieModel)model);
            }
            throw new UiException("model must be a org.zkoss.zul.PieModel or a org.zkoss.zul.CategoryModel");
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createPieChart((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private abstract class ChartImpl {
        private ChartImpl() {
        }

        abstract void render(Chart var1, Area var2, ChartEntity var3);

        abstract JFreeChart createChart(Chart var1);
    }
}

