/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.ui.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.impl.ExecutionCarryOver;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Configuration;

public class PollingServerPush
implements ServerPush {
    private static final Log log = Log.lookup((Class)PollingServerPush.class);
    private static final int GIVEUP = -99;
    private Desktop _desktop;
    private final List _pending = new LinkedList();
    private ThreadInfo _active;
    private ExecutionCarryOver _carryOver;
    private final Object _mutex = new Object();

    protected void startClientPush() {
        Clients.response((AuResponse)new AuScript(null, this.getStartScript()));
    }

    protected void stopClientPush() {
        Clients.response((AuResponse)new AuScript(null, this.getStopScript()));
    }

    protected String getStartScript() {
        String start = this._desktop.getWebApp().getConfiguration().getPreference("PollingServerPush.start", null);
        if (start != null) {
            return start;
        }
        String dtid = this._desktop.getId();
        StringBuffer sb = new StringBuffer(128).append("zk.invoke('zkex.ui.cpsp',function(){zkCpsp.start('").append(dtid).append('\'');
        int v1 = this.getIntPref("PollingServerPush.delay.min");
        int v2 = this.getIntPref("PollingServerPush.delay.max");
        if (v1 > 0 && v2 > 0) {
            sb.append(',').append(v1).append(',').append(v2);
        }
        return sb.append(");},'").append(dtid).append("');").toString();
    }

    private int getIntPref(String key) {
        String s = this._desktop.getWebApp().getConfiguration().getPreference(key, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                log.warning("Not a number specified at " + key);
            }
        }
        return -1;
    }

    protected String getStopScript() {
        String stop = this._desktop.getWebApp().getConfiguration().getPreference("PollingServerPush.stop", null);
        return stop != null ? stop : "zkCpsp.stop('" + this._desktop.getId() + "');";
    }

    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    public void start(Desktop desktop) {
        if (this._desktop != null) {
            log.warning("Ignored: Sever-push already started");
            return;
        }
        this._desktop = desktop;
        this.startClientPush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean inexec;
        if (this._desktop == null) {
            log.warning("Ignored: Sever-push not started");
            return;
        }
        boolean bl = inexec = Executions.getCurrent() != null;
        if (inexec) {
            this.stopClientPush();
        }
        this._desktop = null;
        this.wakePending();
        if (!inexec) {
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakePending() {
        List list = this._pending;
        synchronized (list) {
            Iterator it = this._pending.iterator();
            while (it.hasNext()) {
                ThreadInfo info;
                ThreadInfo threadInfo = info = (ThreadInfo)it.next();
                synchronized (threadInfo) {
                    info.notify();
                }
            }
            this._pending.clear();
        }
    }

    public void setDelay(int min, int max, int factor) {
        Clients.response((AuResponse)new AuScript(null, "zkau.setSPushInfo('" + this._desktop.getId() + "',{min:" + min + ",max:" + max + ",factor:" + factor + "})"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPiggyback() {
        Configuration config = this._desktop.getWebApp().getConfiguration();
        long tmexpired = 0L;
        int cnt = 0;
        while (!this._pending.isEmpty()) {
            ThreadInfo info;
            if (tmexpired == 0L) {
                tmexpired = System.currentTimeMillis() + (long)(config.getMaxProcessTime() >> 1);
                cnt = this._pending.size() + 3;
            } else if (--cnt < 0 || System.currentTimeMillis() > tmexpired) break;
            Object object = this._pending;
            synchronized (object) {
                if (this._pending.isEmpty()) {
                    return;
                }
                info = (ThreadInfo)this._pending.remove(0);
            }
            object = this._mutex;
            synchronized (object) {
                this._carryOver = new ExecutionCarryOver(this._desktop);
                ThreadInfo threadInfo = info;
                synchronized (threadInfo) {
                    if (info.nActive == -99) {
                        continue;
                    }
                    info.nActive = 1;
                    info.notify();
                }
                if (this._desktop == null) {
                    break;
                }
                try {
                    this._mutex.wait();
                }
                catch (InterruptedException ex) {
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        boolean loop;
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        ThreadInfo info = new ThreadInfo(curr);
        List list = this._pending;
        synchronized (list) {
            if (this._desktop != null) {
                this._pending.add(info);
            }
        }
        do {
            loop = false;
            ThreadInfo threadInfo = info;
            synchronized (threadInfo) {
                if (this._desktop != null) {
                    if (info.nActive == 0) {
                        info.wait(timeout <= 0L ? 600000L : timeout);
                    }
                    if (info.nActive <= 0) {
                        boolean bDead;
                        boolean bTimeout = timeout > 0L;
                        boolean bl = bDead = this._desktop == null || !this._desktop.isAlive();
                        if (bTimeout || bDead) {
                            info.nActive = -99;
                            List list2 = this._pending;
                            synchronized (list2) {
                                this._pending.remove(info);
                            }
                            if (bDead) {
                                throw new DesktopUnavailableException("Stopped");
                            }
                            return false;
                        }
                        log.debug("Executions.activate() took more than 10 minutes");
                        loop = true;
                    }
                }
            }
        } while (loop);
        if (this._desktop == null) {
            throw new DesktopUnavailableException("Stopped");
        }
        this._carryOver.carryOver();
        this._active = info;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (stop) {
                this.stopClientPush();
            }
            this._carryOver.cleanup();
            this._carryOver = null;
            this._active.nActive = 0;
            this._active = null;
            if (stop) {
                this.wakePending();
                this._desktop = null;
                stopped = true;
            }
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notify();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return stopped;
    }

    private static class ThreadInfo {
        private final Thread thread;
        private int nActive;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public String toString() {
            return "[" + this.thread + ',' + this.nActive + ']';
        }
    }
}

