/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.xel.mvel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.zkoss.lang.Classes;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zkmax.xel.mvel.MVELXelExpression;
import org.zkoss.zkmax.xel.mvel.XelMVELResolver;
import org.zkoss.zkmax.xel.util.ExpressionFragment;

public class MVELFactory
implements ExpressionFactory {
    public boolean isSupported(int feature) {
        return feature == 2;
    }

    public Expression parseExpression(XelContext ctx, String expression, Class expectedType) throws XelException {
        ParserContext pctx = this.getParserContext(ctx);
        List frags = ExpressionFragment.parse(expression);
        Object[] fs = new Object[frags.size()];
        int j = 0;
        Iterator it = frags.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            fs[j] = o instanceof ExpressionFragment ? this.compile(((ExpressionFragment)o).getExpression(), pctx) : o;
            ++j;
        }
        return new MVELXelExpression(fs, expectedType);
    }

    public Object evaluate(XelContext ctx, String expression, Class expectedType) throws XelException {
        XelMVELResolver resolver = new XelMVELResolver(ctx.getVariableResolver());
        ParserContext pctx = this.getParserContext(ctx);
        List frags = ExpressionFragment.parse(expression);
        if (frags.size() == 1) {
            Object o = frags.get(0);
            return Classes.coerce((Class)expectedType, o instanceof String ? o : this.eval(((ExpressionFragment)o).getExpression(), resolver, pctx));
        }
        StringBuffer sb = new StringBuffer(256);
        Iterator it = frags.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                sb.append(o);
                continue;
            }
            Object val = this.eval(((ExpressionFragment)o).getExpression(), resolver, pctx);
            if (val == null) continue;
            sb.append(val);
        }
        return Classes.coerce((Class)expectedType, (Object)sb.toString());
    }

    private Object eval(String expr, XelMVELResolver resolver, ParserContext pctx) {
        return pctx == null ? MVEL.eval((String)expr, (VariableResolverFactory)resolver) : MVEL.executeExpression((Object)this.compile(expr, pctx), (VariableResolverFactory)resolver);
    }

    private Object compile(String expr, ParserContext pctx) {
        return pctx == null ? MVEL.compileExpression((String)expr) : ParseTools.optimizeTree((CompiledExpression)new ExpressionCompiler(expr).compile(pctx));
    }

    private ParserContext getParserContext(XelContext ctx) {
        Collection c;
        FunctionMapper mapper;
        if (ctx != null && (mapper = ctx.getFunctionMapper()) != null && (c = mapper.getClassNames()) != null && !c.isEmpty()) {
            ParserContext pctx = new ParserContext();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                String nm = (String)it.next();
                pctx.addImport(nm, mapper.resolveClass(nm));
            }
            return pctx;
        }
        return null;
    }
}

