/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.xel.mvel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.integration.impl.BaseVariableResolverFactory;
import org.zkoss.xel.VariableResolver;

class XelMVELResolver
extends BaseVariableResolverFactory {
    private final VariableResolver _resolver;
    private Map _values;

    XelMVELResolver(VariableResolver resolver) {
        this._resolver = resolver;
    }

    public org.mvel.integration.VariableResolver getVariableResolver(String name) {
        if (this._values != null && this._values.containsKey(name) || this._resolver != null && this._resolver.resolveVariable(name) != null) {
            return this.variableResolvers != null && this.variableResolvers.containsKey(name) ? (org.mvel.integration.VariableResolver)this.variableResolvers.get(name) : new VarResolver(name);
        }
        return this.nextFactory != null ? this.nextFactory.getVariableResolver(name) : null;
    }

    public boolean isResolveable(String name) {
        return this.variableResolvers != null && this.variableResolvers.containsKey(name) || this._values != null && this._values.containsKey(name) || this._resolver != null && this._resolver.resolveVariable(name) != null || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    public Set getKnownVariables() {
        return this.nextFactory != null ? this.nextFactory.getKnownVariables() : Collections.EMPTY_SET;
    }

    public org.mvel.integration.VariableResolver createVariable(String name, Object value) {
        org.mvel.integration.VariableResolver vr = this.getVariableResolver(name);
        if (vr == null) {
            vr = new VarResolver(name);
        }
        vr.setValue(value);
        return vr;
    }

    public org.mvel.integration.VariableResolver createVariable(String name, Object value, Class type) {
        org.mvel.integration.VariableResolver vr = this.getVariableResolver(name);
        if (vr != null && vr.getType() != null) {
            throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new VarResolver(name, type);
        this.addResolver(name, vr);
        vr.setValue(value);
        return vr;
    }

    private void addResolver(String name, org.mvel.integration.VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
    }

    private class VarResolver
    implements org.mvel.integration.VariableResolver {
        private final String _name;
        private Class _type;

        private VarResolver(String name) {
            this._name = name;
        }

        private VarResolver(String name, Class type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public Class getType() {
            return this._type;
        }

        public void setStaticType(Class type) {
            this._type = type;
        }

        public int getFlags() {
            return 0;
        }

        public Object getValue() {
            Object o;
            if (XelMVELResolver.this._values != null && ((o = XelMVELResolver.this._values.get(this._name)) != null || XelMVELResolver.this._values.containsKey(this._name))) {
                return o;
            }
            return XelMVELResolver.this._resolver.resolveVariable(this._name);
        }

        public void setValue(Object value) {
            if (this._type != null && value != null && value.getClass() != this._type) {
                if (!DataConversion.canConvert((Class)this._type, value.getClass())) {
                    throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this._type.getName());
                }
                try {
                    value = DataConversion.convert((Object)value, (Class)this._type);
                }
                catch (Exception e) {
                    throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this._type.getName());
                }
            }
            if (XelMVELResolver.this._values == null) {
                XelMVELResolver.this._values = new HashMap();
            }
            XelMVELResolver.this._values.put(this._name, value);
        }
    }
}

