/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zkplus.databind.DataBinder;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.ComboitemRendererExt;

class BindingComboitemRenderer
implements ComboitemRenderer,
ComboitemRendererExt,
Serializable {
    private static final long serialVersionUID = 200808191415L;
    private static final String KIDS = "zkplus.databind.KIDS";
    private Comboitem _template;
    private DataBinder _binder;
    private int x = 0;

    public BindingComboitemRenderer(Comboitem template, DataBinder binder) {
        this._template = template;
        this._binder = binder;
    }

    private void linkTemplates(Component clone, Component template, Map templatemap) {
        if (this._binder.existsBindings(template)) {
            templatemap.put(template, clone);
            clone.setAttribute("zkplus.databind.TEMPLATEMAP", (Object)templatemap);
            clone.setAttribute("zkplus.databind.TEMPLATE", (Object)template);
        }
        if (DataBinder.isCollectionOwner(template)) {
            return;
        }
        Iterator itt = template.getChildren().iterator();
        Iterator itc = clone.getChildren().iterator();
        while (itt.hasNext()) {
            Component t = (Component)itt.next();
            Component c = (Component)itc.next();
            this.linkTemplates(c, t, templatemap);
        }
    }

    private void setupCloneIds(Component clone) {
        clone.setId("@" + clone.getUuid() + "_" + this.x++);
        Component template = DataBinder.getComponent(clone);
        if (template != null && DataBinder.isCollectionOwner(template)) {
            return;
        }
        Iterator it = clone.getChildren().iterator();
        while (it.hasNext()) {
            this.setupCloneIds((Component)it.next());
        }
    }

    public void render(Comboitem item, Object bean) throws Exception {
        List kids = (List)item.getAttribute(KIDS);
        item.getChildren().addAll(kids);
        this._binder.setupTemplateComponent((Component)item, null);
        this.setupCloneIds((Component)item);
        String varname = (String)this._template.getAttribute("zkplus.databind.VARNAME");
        Map templatemap = (Map)item.getAttribute("zkplus.databind.TEMPLATEMAP");
        templatemap.put(varname, bean);
        this._binder.loadComponent((Component)item);
    }

    public Comboitem newComboitem(Combobox combobox) {
        Comboitem clone = (Comboitem)this._template.clone();
        if (!ComponentsCtrl.isAutoId((String)clone.getId())) {
            clone.setId("@" + clone.getUuid() + "_" + this.x++);
        }
        HashMap<String, Map> templatemap = new HashMap<String, Map>(7);
        this.linkTemplates((Component)clone, (Component)this._template, templatemap);
        Map parenttemplatemap = (Map)combobox.getAttribute("zkplus.databind.TEMPLATEMAP");
        if (parenttemplatemap != null) {
            templatemap.put("zkplus.databind.TEMPLATEMAP", parenttemplatemap);
        }
        ArrayList kids = new ArrayList(clone.getChildren());
        clone.setAttribute(KIDS, kids);
        clone.getChildren().clear();
        return clone;
    }
}

