/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Primitives;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.ModificationException;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zkplus.databind.Binding;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.BindingListModelExt;
import org.zkoss.zkplus.databind.BindingNode;
import org.zkoss.zkplus.databind.CollectionItem;
import org.zkoss.zkplus.databind.CollectionItemExt;
import org.zkoss.zkplus.databind.ComboitemCollectionItem;
import org.zkoss.zkplus.databind.ListitemCollectionItem;
import org.zkoss.zkplus.databind.RowCollectionItem;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Row;

public class DataBinder
implements Serializable {
    private static final long serialVersionUID = 200808191508L;
    public static final String NULLIFY = "none";
    public static final String ARGS = "bindingArgs";
    public static final String VARNAME = "zkplus.databind.VARNAME";
    public static final String TEMPLATEMAP = "zkplus.databind.TEMPLATEMAP";
    public static final String TEMPLATE = "zkplus.databind.TEMPLATE";
    private static final String OWNER = "zkplus.databind.OWNER";
    private static final String ITEM = "zkplus.databind.ITEM";
    private static final String IAMOWNER = "zkplus.databind.IAMOWNER";
    private static final String HASTEMPLATEOWNER = "zkplus.databind.HASTEMPLATEOWNER";
    private static final Object NA = new Object();
    private Map _compBindingMap = new LinkedHashMap(29);
    private Map _beans = new HashMap(29);
    private Map _beanSameNodes = new HashMap(29);
    private BindingNode _pathTree = new BindingNode("/", false, "/", false);
    private boolean _defaultConfig = true;
    private boolean _init;
    private EventListener _listener = new LoadOnSaveEventListener();
    protected Map _collectionItemMap = new HashMap(3);
    protected Map _collectionOwnerMap = new HashMap(3);

    public void addBinding(Component comp, String attr, String expr) {
        this.addBinding(comp, attr, expr, (List)null, (List)null, null, null);
    }

    public void addBinding(Component comp, String attr, String expr, String[] loadWhenEvents, String saveWhenEvent, String access, String converter) {
        ArrayList<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.length > 0) {
            loadEvents = new ArrayList<String>(loadWhenEvents.length);
            for (int j = 0; j < loadWhenEvents.length; ++j) {
                loadEvents.add(loadWhenEvents[j]);
            }
        }
        this.addBinding(comp, attr, expr, loadEvents, saveWhenEvent, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, String[] loadWhenEvents, String[] saveWhenEvents, String access, String converter) {
        ArrayList<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.length > 0) {
            loadEvents = new ArrayList<String>(loadWhenEvents.length);
            for (int j = 0; j < loadWhenEvents.length; ++j) {
                loadEvents.add(loadWhenEvents[j]);
            }
        }
        ArrayList<String> saveEvents = null;
        if (saveWhenEvents != null && saveWhenEvents.length > 0) {
            saveEvents = new ArrayList<String>(saveWhenEvents.length);
            for (int j = 0; j < saveWhenEvents.length; ++j) {
                saveEvents.add(saveWhenEvents[j]);
            }
        }
        this.addBinding(comp, attr, expr, loadEvents, saveEvents, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, List loadWhenEvents, String saveWhenEvent, String access, String converter) {
        ArrayList<String> saveEvents = new ArrayList<String>(1);
        saveEvents.add(saveWhenEvent);
        this.addBinding(comp, attr, expr, loadWhenEvents, saveEvents, access, converter);
    }

    public void addBinding(Component comp, String attr, String expr, List loadWhenEvents, List saveWhenEvents, String access, String converter) {
        this.addBinding(comp, attr, expr, loadWhenEvents, saveWhenEvents, access, converter, null);
    }

    public void addBinding(Component comp, String attr, String expr, List loadWhenEvents, List saveWhenEvents, String access, String converter, Map args) {
        LinkedHashMap<String, Binding> attrMap;
        if ("each".equals(attr)) {
            attr = "_var";
        }
        if (this.isDefaultConfig()) {
            Object[] objs = this.loadPropertyAnnotation(comp, attr, "default-bind");
            if (loadWhenEvents == null && objs[1] != null) {
                loadWhenEvents = (List)objs[1];
            }
            if (saveWhenEvents == null && objs[2] != null) {
                saveWhenEvents = (List)objs[2];
            }
            if (access == null && objs[3] != null) {
                access = (String)objs[3];
            }
            if (converter == null && objs[4] != null) {
                converter = (String)objs[4];
            }
        }
        LinkedHashSet<String> loadEvents = null;
        if (loadWhenEvents != null && loadWhenEvents.size() > 0) {
            loadEvents = new LinkedHashSet<String>(loadWhenEvents.size());
            Iterator it = loadWhenEvents.iterator();
            while (it.hasNext()) {
                String event = (String)it.next();
                if (NULLIFY.equals(event)) {
                    loadEvents.clear();
                    continue;
                }
                loadEvents.add(event);
            }
            if (loadEvents.isEmpty()) {
                loadEvents = null;
            }
        }
        HashSet<String> saveEvents = null;
        if (saveWhenEvents != null && saveWhenEvents.size() > 0) {
            saveEvents = new HashSet<String>(saveWhenEvents.size());
            Iterator it = saveWhenEvents.iterator();
            while (it.hasNext()) {
                String event = (String)it.next();
                if (NULLIFY.equals(event)) {
                    saveEvents.clear();
                    continue;
                }
                saveEvents.add(event);
            }
            if (saveEvents.isEmpty()) {
                saveEvents = null;
            }
        }
        if (NULLIFY.equals(converter)) {
            converter = null;
        }
        if ((attrMap = (LinkedHashMap<String, Binding>)this._compBindingMap.get(comp)) == null) {
            attrMap = new LinkedHashMap<String, Binding>(3);
            this._compBindingMap.put(comp, attrMap);
        }
        if (attrMap.containsKey(attr)) {
            Binding binding = (Binding)attrMap.get(attr);
            binding.setExpression(expr);
            binding.setLoadWhenEvents(loadEvents);
            binding.setSaveWhenEvents(saveEvents);
            binding.setAccess(access);
            binding.setConverter(converter);
        } else {
            attrMap.put(attr, new Binding(this, comp, attr, expr, loadEvents, saveEvents, access, converter, args));
        }
    }

    public void removeBinding(Component comp, String attr) {
        Map attrMap = (Map)this._compBindingMap.get(comp);
        if (attrMap != null) {
            attrMap.remove(attr);
        }
    }

    public Binding getBinding(Component comp, String attr) {
        Map attrMap;
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return (attrMap = (Map)this._compBindingMap.get(comp)) != null ? (Binding)attrMap.get(attr) : null;
    }

    public Collection getBindings(Component comp) {
        Map attrMap;
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return (attrMap = (Map)this._compBindingMap.get(comp)) != null ? attrMap.values() : null;
    }

    public Collection getAllBindings() {
        ArrayList bindings = new ArrayList(this._compBindingMap.size() * 2);
        Iterator it = this._compBindingMap.values().iterator();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            bindings.addAll(map.values());
        }
        return bindings;
    }

    public boolean existsBindings(Component comp) {
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        return this._compBindingMap.containsKey(comp);
    }

    public boolean existBinding(Component comp, String attr) {
        if (DataBinder.isClone(comp)) {
            comp = (Component)comp.getAttribute(TEMPLATE);
        }
        if (this._compBindingMap.containsKey(comp)) {
            Map attrMap = (Map)this._compBindingMap.get(comp);
            return attrMap.containsKey(attr);
        }
        return false;
    }

    public boolean isDefaultConfig() {
        return this._defaultConfig;
    }

    public void setDefaultConfig(boolean b) {
        this._defaultConfig = b;
    }

    public void bindBean(String beanid, Object bean) {
        this._beans.put(beanid, bean);
    }

    public void loadAttribute(Component comp, String attr) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Binding binding = this.getBinding(comp, attr);
        if (binding != null) {
            binding.loadAttribute(comp);
        }
    }

    public void saveAttribute(Component comp, String attr) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Binding binding = this.getBinding(comp, attr);
        if (binding != null) {
            binding.saveAttribute(comp);
        }
    }

    public void loadComponent(Component comp) {
        this.init();
        if (this.loadComponent0(comp)) {
            return;
        }
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.loadComponent((Component)it.next());
        }
    }

    private boolean loadComponent0(Component comp) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return true;
        }
        Collection bindings = this.getBindings(comp);
        if (bindings != null) {
            this.loadAttrs(comp, bindings);
        }
        return false;
    }

    public void saveComponent(Component comp) {
        if (DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.init();
        Collection bindings = this.getBindings(comp);
        if (bindings != null) {
            this.saveAttrs(comp, bindings);
        }
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.saveComponent((Component)it.next());
        }
    }

    public void loadAll() {
        this.init();
        Iterator it = this._compBindingMap.keySet().iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            this.loadComponent0(comp);
        }
    }

    public void saveAll() {
        this.init();
        Iterator it = this._compBindingMap.keySet().iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            this.saveComponent(comp);
        }
    }

    private void loadAttrs(Component comp, Collection attrs) {
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.loadAttribute(comp);
        }
    }

    private void saveAttrs(Component comp, Collection attrs) {
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.saveAttribute(comp);
        }
    }

    protected Object[] loadPropertyAnnotation(Component comp, String propName, String bindName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(propName, bindName);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            List loadWhenEvents = null;
            List saveWhenEvents = null;
            String access = null;
            String converter = null;
            String expr = null;
            HashMap<String, String> args = null;
            Iterator it = attrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String tag = (String)entry.getKey();
                String tagExpr = (String)entry.getValue();
                if ("save-when".equals(tag)) {
                    saveWhenEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("access".equals(tag)) {
                    access = tagExpr;
                    continue;
                }
                if ("converter".equals(tag)) {
                    converter = tagExpr;
                    continue;
                }
                if ("load-when".equals(tag)) {
                    loadWhenEvents = DataBinder.parseExpression(tagExpr, ",");
                    continue;
                }
                if ("value".equals(tag)) {
                    expr = tagExpr;
                    continue;
                }
                if (args == null) {
                    args = new HashMap<String, String>();
                }
                args.put(tag, tagExpr);
            }
            return new Object[]{expr, loadWhenEvents, saveWhenEvents, access, converter, args};
        }
        return new Object[6];
    }

    protected void init() {
        if (!this._init) {
            this._init = true;
            this.initCollectionItem();
            HashSet<String> varnameSet = new HashSet<String>();
            LinkedHashSet<Component> toBeDetached = new LinkedHashSet<Component>();
            Iterator it = this._compBindingMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Component comp = (Component)me.getKey();
                Map attrMap = (Map)me.getValue();
                Collection bindings = attrMap.values();
                if (attrMap.containsKey("_var")) {
                    comp.setAttribute(ITEM, (Object)comp);
                    Component owner = this.getComponentCollectionOwner(comp);
                    owner.setAttribute(IAMOWNER, (Object)Boolean.TRUE);
                    this.setupTemplateComponent(comp, owner);
                    String varname = ((Binding)attrMap.get("_var")).getExpression();
                    varnameSet.add(varname);
                    comp.setAttribute(VARNAME, (Object)varname);
                    this.setupBindingRenderer(comp);
                    toBeDetached.add(comp);
                }
                if (bindings == null) continue;
                this.setupPathTree(bindings, varnameSet);
                this.registerSaveEvents(comp, bindings);
                this.registerLoadEvents(comp, bindings);
            }
            it = toBeDetached.iterator();
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                comp.detach();
            }
        }
    }

    private void initCollectionItem() {
        this.addCollectionItem(Listitem.class, Listbox.class, new ListitemCollectionItem());
        this.addCollectionItem(Row.class, Grid.class, new RowCollectionItem());
        this.addCollectionItem(Comboitem.class, Combobox.class, new ComboitemCollectionItem());
    }

    public void addCollectionItem(String comp, CollectionItem decor) {
        this._collectionItemMap.put(comp, decor);
    }

    public void addCollectionItem(Class item, Class owner, CollectionItem decor) {
        this._collectionItemMap.put(item.getName(), decor);
        this._collectionOwnerMap.put(owner.getName(), decor);
    }

    private Component getComponentCollectionOwner(Component comp) {
        CollectionItem decor = this.getBindingCollectionItem(comp);
        return decor.getComponentCollectionOwner(comp);
    }

    protected CollectionItem getBindingCollectionItem(Component comp) {
        String name = comp.getClass().getName();
        if (comp instanceof Listitem) {
            name = Listitem.class.getName();
        } else if (comp instanceof Row) {
            name = Row.class.getName();
        } else if (comp instanceof Comboitem) {
            name = Comboitem.class.getName();
        }
        CollectionItem decorName = (CollectionItem)this._collectionItemMap.get(name);
        if (decorName != null) {
            return decorName;
        }
        throw new UiException("Cannot find associated CollectionItem:" + comp);
    }

    CollectionItem getCollectionItemByOwner(Component comp) {
        CollectionItem decorName = this.myGetCollectionItemByOwner(comp);
        if (decorName == null) {
            throw new UiException("Cannot find associated CollectionItem by owner: " + comp);
        }
        return decorName;
    }

    private CollectionItem myGetCollectionItemByOwner(Component comp) {
        String name = comp.getClass().getName();
        if (comp instanceof Listbox) {
            name = Listbox.class.getName();
        } else if (comp instanceof Grid) {
            name = Grid.class.getName();
        } else if (comp instanceof Combobox) {
            name = Combobox.class.getName();
        }
        CollectionItem decorName = (CollectionItem)this._collectionOwnerMap.get(name);
        return decorName;
    }

    Component getCollectionOwner(Component comp) {
        if (DataBinder.isTemplate(comp)) {
            return (Component)comp.getAttribute(OWNER);
        }
        return this.getComponentCollectionOwner(comp);
    }

    private Component getCollectionItem(Component comp, Object bean, boolean isCollectionItem) {
        Component[] comps = this.getCollectionItems(comp, bean, isCollectionItem);
        return comps.length == 0 ? null : comps[0];
    }

    private Component[] getCollectionItems(Component comp, Object bean, boolean isCollectionItem) {
        Component owner = this.getCollectionOwner(comp);
        Component item = (Component)comp.getAttribute(ITEM);
        CollectionItem decor = this.myGetCollectionItemByOwner(owner);
        if (decor == null) {
            decor = this.getBindingCollectionItem(item);
        }
        ListModel xmodel = decor.getModelByOwner(owner);
        if (isCollectionItem && comp == item) {
            BindingListModel model;
            int index;
            if (xmodel instanceof BindingListModelExt && !((BindingListModelExt)xmodel).isDistinct()) {
                BindingListModelExt model2 = (BindingListModelExt)xmodel;
                int[] indexes = model2.indexesOf(bean);
                int sz = indexes.length;
                ArrayList<Component> comps = new ArrayList<Component>(sz);
                for (int j = 0; j < sz; ++j) {
                    Component xcomp = DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, indexes[j]), comp);
                    comps.add(xcomp);
                }
                return comps.toArray(new Component[comps.size()]);
            }
            if (xmodel instanceof BindingListModel && (index = (model = (BindingListModel)xmodel).indexOf(bean)) >= 0) {
                return new Component[]{DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, index), comp)};
            }
        } else {
            int sz = xmodel.getSize();
            ArrayList<Component> comps = new ArrayList<Component>(sz);
            if (decor instanceof CollectionItemExt) {
                List items = ((CollectionItemExt)decor).getItems(owner);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    Component cloneitem = (Component)it.next();
                    Component xcomp = DataBinder.lookupClone(cloneitem, comp);
                    comps.add(xcomp);
                }
            } else {
                for (int j = 0; j < sz; ++j) {
                    Component xcomp = DataBinder.lookupClone(decor.getComponentAtIndexByOwner(owner, j), comp);
                    comps.add(xcomp);
                }
            }
            return comps.toArray(new Component[sz]);
        }
        return new Component[0];
    }

    private void setupBindingRenderer(Component comp) {
        this.getBindingCollectionItem(comp).setupBindingRenderer(comp, this);
    }

    private void setupPathTree(Collection bindings, Set varnameSet) {
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            String[] paths = binding.getPaths();
            for (int j = 0; j < paths.length; ++j) {
                String path = paths[j];
                this._pathTree.addBinding(path, binding, varnameSet);
            }
        }
    }

    private void registerSaveEvents(Component comp, Collection bindings) {
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.registerSaveEvents(comp);
        }
    }

    private void registerLoadEvents(Component comp, Collection bindings) {
        Iterator it = bindings.iterator();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            binding.registerLoadEvents(comp);
        }
    }

    boolean existsBean(String beanid) {
        return this._beans.containsKey(beanid);
    }

    Object getBean(String beanid) {
        return this._beans.get(beanid);
    }

    void setBean(String beanid, Object bean) {
        this._beans.put(beanid, bean);
    }

    public void setupTemplateComponent(Component comp, Object owner) {
        this.mySetupTemplateComponent(comp, owner, comp);
    }

    private void mySetupTemplateComponent(Component comp, Object owner, Component item) {
        if (this.existsBindings(comp)) {
            if (comp.getAttribute(OWNER) != null) {
                comp.setAttribute(HASTEMPLATEOWNER, (Object)Boolean.TRUE);
            }
            comp.setAttribute(OWNER, owner);
            comp.setAttribute(ITEM, (Object)item);
        }
        List kids = comp.getChildren();
        Iterator it = kids.iterator();
        while (it.hasNext()) {
            this.mySetupTemplateComponent((Component)it.next(), owner, item);
        }
    }

    static List parseExpression(String expr, String separator) {
        if (expr == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(6);
        while (true) {
            int j;
            if ((j = expr.indexOf(separator)) < 0) {
                results.add(expr.trim());
                return results;
            }
            results.add(expr.substring(0, j).trim());
            if (expr.length() <= j + 1) {
                return results;
            }
            expr = expr.substring(j + 1);
        }
    }

    static boolean isCollectionOwner(Component owner) {
        return owner.getAttribute(IAMOWNER) != null;
    }

    static boolean isTemplate(Component comp) {
        return comp != null && comp.getAttribute(OWNER) != null;
    }

    static boolean isClone(Component comp) {
        return comp != null && comp.getAttribute(TEMPLATE) instanceof Component;
    }

    static Component getComponent(Component clone) {
        return (Component)clone.getAttribute(TEMPLATE);
    }

    static boolean hasTemplateOwner(Component comp) {
        return comp != null && comp.getAttribute(HASTEMPLATEOWNER) != null;
    }

    void setBeanSameNodes(Object bean, Set set) {
        this._beanSameNodes.put(bean, set);
    }

    Set getBeanSameNodes(Object bean) {
        return (Set)this._beanSameNodes.get(bean);
    }

    Set removeBeanSameNodes(Object bean) {
        return (Set)this._beanSameNodes.remove(bean);
    }

    Object getBeanAndRegisterBeanSameNodes(Component comp, String path) {
        return this.myGetBeanWithExpression(comp, path, true);
    }

    private Object getBeanWithExpression(Component comp, String path) {
        return this.myGetBeanWithExpression(comp, path, false);
    }

    private Object myGetBeanWithExpression(Component comp, String path, boolean registerNode) {
        String nodeid;
        Object bean = null;
        BindingNode currentNode = this._pathTree;
        List nodeids = DataBinder.parseExpression(path, ".");
        Iterator it = nodeids.iterator();
        if (it != null && it.hasNext()) {
            nodeid = (String)it.next();
            if ((currentNode = currentNode.getKidNode(nodeid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
            bean = this.lookupBean(comp, nodeid);
            if (registerNode) {
                this.registerBeanNode(bean, currentNode);
            }
        } else {
            throw new UiException("Incorrect format of databind bean expression:" + path);
        }
        while (bean != null && it.hasNext()) {
            nodeid = (String)it.next();
            if ((currentNode = currentNode.getKidNode(nodeid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
            bean = this.fetchValue(bean, currentNode, nodeid, registerNode);
        }
        return bean;
    }

    private Object fetchValue(Object bean, BindingNode node, String nodeid, boolean registerNode) {
        if (bean != null) {
            if (bean instanceof Map) {
                bean = ((Map)bean).get(nodeid);
            } else {
                try {
                    bean = Fields.get((Object)bean, (String)nodeid);
                }
                catch (NoSuchMethodException ex) {
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            }
        }
        if (registerNode) {
            this.registerBeanNode(bean, node);
        }
        return bean;
    }

    void setBeanAndRegisterBeanSameNodes(Component comp, Object val, Binding binding, String path, boolean autoConvert, Object rawval, List loadOnSaveInfos) {
        Object orgVal = null;
        Object bean = null;
        BindingNode currentNode = this._pathTree;
        boolean refChanged = false;
        String beanid = null;
        List nodeids = DataBinder.parseExpression(path, ".");
        ArrayList<BindingNode> nodes = new ArrayList<BindingNode>(nodeids.size());
        Iterator it = nodeids.iterator();
        if (it != null && it.hasNext()) {
            beanid = (String)it.next();
            if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                throw new UiException("Cannot find the specified databind bean expression:" + path);
            }
        } else {
            throw new UiException("Incorrect format of databind bean expression:" + path);
        }
        nodes.add(currentNode);
        bean = this.lookupBean(comp, beanid);
        if (!it.hasNext()) {
            orgVal = bean;
            if (Objects.equals((Object)orgVal, (Object)val)) {
                return;
            }
            if (this.existsBean(beanid)) {
                this.setBean(beanid, val);
            } else if (!this.setZScriptVariable(comp, beanid, val)) {
                comp.setVariable(beanid, val, false);
            }
            refChanged = true;
        } else {
            if (bean == null) {
                return;
            }
            for (int sz = nodeids.size() - 2; bean != null && it.hasNext() && sz > 0; --sz) {
                beanid = (String)it.next();
                if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                    throw new UiException("Cannot find the specified databind bean expression:" + path);
                }
                nodes.add(currentNode);
                try {
                    bean = Fields.get((Object)bean, (String)beanid);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    if (bean instanceof Map) {
                        bean = ((Map)bean).get(beanid);
                        continue;
                    }
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            }
            if (bean == null) {
                return;
            }
            beanid = (String)it.next();
            try {
                orgVal = Fields.get((Object)bean, (String)beanid);
                if (Objects.equals((Object)orgVal, (Object)val)) {
                    return;
                }
                Fields.set((Object)bean, (String)beanid, (Object)val, (boolean)autoConvert);
            }
            catch (NoSuchMethodException ex) {
                if (bean instanceof Map) {
                    ((Map)bean).put(beanid, val);
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            catch (ModificationException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
            if (!this.isPrimitive(val) && !this.isPrimitive(orgVal)) {
                if ((currentNode = currentNode.getKidNode(beanid)) == null) {
                    throw new UiException("Cannot find the specified databind bean expression:" + path);
                }
                nodes.add(currentNode);
                bean = orgVal;
                refChanged = true;
            }
        }
        if (val != null) {
            Binding varbinding;
            if (refChanged && !binding.isLoadable() && binding.isSavable()) {
                this.registerBeanNode(val, currentNode);
            }
            if (rawval instanceof Component && (varbinding = this.getBinding((Component)rawval, "_var")) != null) {
                this.registerBeanNode(val, currentNode);
                this.getBeanAndRegisterBeanSameNodes((Component)rawval, varbinding.getExpression());
            }
        }
        if (!comp.isListenerAvailable("onLoadOnSave", true)) {
            comp.addEventListener("onLoadOnSave", this._listener);
        }
        Object[] loadOnSaveInfo = new Object[]{this, currentNode, binding, refChanged ? val : bean, refChanged, nodes, comp};
        if (loadOnSaveInfos != null) {
            loadOnSaveInfos.add(loadOnSaveInfo);
        } else {
            Events.postEvent((Event)new Event("onLoadOnSave", comp, (Object)loadOnSaveInfo));
        }
    }

    private void registerBeanNode(Object bean, BindingNode node) {
        if (this.isPrimitive(bean)) {
            return;
        }
        Set nodeSameNodes = node.getSameNodes();
        Set binderSameNodes = this.getBeanSameNodes(bean);
        if (node.isVar() && binderSameNodes == null) {
            return;
        }
        if (!nodeSameNodes.contains(bean)) {
            Iterator it = nodeSameNodes.iterator();
            while (it.hasNext()) {
                Object elm = it.next();
                if (elm instanceof BindingNode) continue;
                it.remove();
                this.removeBeanSameNodes(elm);
                break;
            }
            if (bean != null) {
                nodeSameNodes.add(bean);
            }
        }
        if (binderSameNodes == null) {
            if (bean != null) {
                this.setBeanSameNodes(bean, nodeSameNodes);
            }
        } else {
            node.mergeAndSetSameNodes(binderSameNodes);
        }
    }

    private boolean isPrimitive(Object bean) {
        return bean instanceof String || bean != null && Primitives.toPrimitive(bean.getClass()) != null || bean instanceof Date || bean instanceof Number;
    }

    private boolean setZScriptVariable(Component comp, String beanid, Object val) {
        boolean found = false;
        Namespace ns = comp.getNamespace();
        Iterator it = comp.getPage().getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Interpreter ip = (Interpreter)it.next();
            if (ip instanceof HierachicalAware) {
                HierachicalAware ha = (HierachicalAware)ip;
                if (!ha.containsVariable(ns, beanid)) continue;
                ha.setVariable(ns, beanid, val);
                found = true;
                continue;
            }
            if (!ip.containsVariable(beanid)) continue;
            ip.setVariable(beanid, val);
            found = true;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookupBean(Component comp, String beanid) {
        Object bean = null;
        if ("self".equals(beanid)) {
            return comp;
        }
        if (DataBinder.isClone(comp) && (bean = this.myLookupBean1(comp, beanid)) != NA) {
            return bean;
        }
        if (this.existsBean(beanid)) {
            bean = this.getBean(beanid);
        } else if (beanid.startsWith("/")) {
            bean = Path.getComponent((String)beanid);
        } else if (beanid.startsWith(".")) {
            bean = Path.getComponent((IdSpace)comp.getSpaceOwner(), (String)beanid);
        } else {
            Page page = comp.getPage();
            if (page != null) {
                bean = page.getZScriptVariable(comp.getNamespace(), beanid);
            }
            if (bean == null) {
                Object self = page.getNamespace().getVariableNames().contains("self") ? page.getNamespace().getVariable("self", true) : null;
                try {
                    page.setVariable("self", (Object)comp);
                    bean = comp.getVariable(beanid, false);
                }
                finally {
                    if (self == null) {
                        page.unsetVariable("self");
                    } else {
                        page.setVariable("self", self);
                    }
                }
            }
        }
        return bean;
    }

    private Object myLookupBean1(Component comp, String beanid) {
        Map templatemap = (Map)comp.getAttribute(TEMPLATEMAP);
        return this.myLookupBean2(beanid, templatemap);
    }

    private Object myLookupBean2(String beanid, Map templatemap) {
        if (templatemap != null) {
            if (templatemap.containsKey(beanid)) {
                return templatemap.get(beanid);
            }
            templatemap = (Map)templatemap.get(TEMPLATEMAP);
            return this.myLookupBean2(beanid, templatemap);
        }
        return NA;
    }

    static Component lookupClone(Component srcClone, Component srcTemplate) {
        if (DataBinder.isTemplate(srcTemplate)) {
            Map templatemap = (Map)srcClone.getAttribute(TEMPLATEMAP);
            return DataBinder.myLookupClone(srcTemplate, templatemap);
        }
        return null;
    }

    private static Component myLookupClone(Component srcTemplate, Map templatemap) {
        if (templatemap != null) {
            if (templatemap.containsKey(srcTemplate)) {
                return (Component)templatemap.get(srcTemplate);
            }
            templatemap = (Map)templatemap.get(TEMPLATEMAP);
            return DataBinder.myLookupClone(srcTemplate, templatemap);
        }
        return null;
    }

    private Set getAssociateSameNodes(BindingNode parentNode, String path, int level) {
        Object obj;
        List nodeids = DataBinder.parseExpression(path, ".");
        int sz = nodeids.size();
        List subids = nodeids.subList(sz - level, sz);
        Iterator it = parentNode.getSameNodes().iterator();
        while (it.hasNext() && (obj = it.next()) instanceof BindingNode) {
        }
        HashSet<Object> assocateSameNodes = new HashSet<Object>();
        Iterator it2 = parentNode.getSameNodes().iterator();
        while (it2.hasNext()) {
            String nodeid;
            BindingNode currentNode = null;
            Object obj2 = it2.next();
            if (!(obj2 instanceof BindingNode) || currentNode == parentNode) continue;
            currentNode = (BindingNode)obj2;
            Iterator itx = subids.iterator();
            while (itx.hasNext() && (currentNode = currentNode.getKidNode(nodeid = (String)itx.next())) != null) {
            }
            if (currentNode == null) continue;
            if (!currentNode.isVar()) {
                assocateSameNodes.add(currentNode);
                continue;
            }
            Component varRootComp = this.getVarRootComponent(currentNode);
            assocateSameNodes.add(new Object[]{currentNode, varRootComp});
        }
        return assocateSameNodes;
    }

    private Component getVarRootComponent(BindingNode node) {
        BindingNode varRootNode = node.getRootNode(this._pathTree);
        Object bean = null;
        Iterator it = varRootNode.getSameNodes().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof BindingNode) continue;
            bean = obj;
            break;
        }
        Component comp = null;
        Iterator itx = varRootNode.getBindings().iterator();
        while (itx.hasNext()) {
            Binding binding = (Binding)itx.next();
            if (!"_var".equals(binding.getAttr())) continue;
            comp = binding.getComponent();
            break;
        }
        return this.getCollectionItem(comp, bean, true);
    }

    private class LoadOnSaveEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 200808191508L;

        public void onEvent(Event event) {
            HashSet walkedNodes = new HashSet(32);
            HashSet loadedComps = new HashSet(64);
            Object obj = event.getData();
            if (obj instanceof List) {
                Iterator it = ((List)obj).iterator();
                while (it.hasNext()) {
                    Object[] data = (Object[])it.next();
                    this.doLoad(data, walkedNodes, loadedComps);
                }
            } else {
                this.doLoad((Object[])obj, walkedNodes, loadedComps);
            }
        }

        private void doLoad(Object[] data, Set walkedNodes, Set loadedComps) {
            if (!data[0].equals(DataBinder.this)) {
                return;
            }
            BindingNode node = (BindingNode)data[1];
            Binding savebinding = (Binding)data[2];
            Object bean = data[3];
            boolean refChanged = (Boolean)data[4];
            List nodes = (List)data[5];
            Component savecomp = (Component)data[6];
            if (savecomp != null) {
                this.loadAllNodes(bean, node, savecomp, savebinding, refChanged, nodes, walkedNodes, loadedComps);
            }
        }

        private void loadAllNodes(Object bean, BindingNode node, Component collectionComp, Binding savebinding, boolean refChanged, List nodes, Set walkedNodes, Set loadedComps) {
            this.myLoadAllNodes(bean, node, new Component[]{collectionComp}, walkedNodes, savebinding, loadedComps, refChanged);
            if (!nodes.isEmpty()) {
                String path = node.getPath();
                int level = 1;
                ListIterator it = nodes.listIterator(nodes.size() - 1);
                while (it.hasPrevious()) {
                    BindingNode parentNode = (BindingNode)it.previous();
                    Set associateSameNodes = DataBinder.this.getAssociateSameNodes(parentNode, path, level);
                    Iterator itx = associateSameNodes.iterator();
                    while (itx.hasNext()) {
                        BindingNode samenode;
                        Object obj = itx.next();
                        if (obj instanceof BindingNode) {
                            samenode = (BindingNode)obj;
                            this.myLoadAllNodes(bean, samenode, new Component[]{collectionComp}, walkedNodes, savebinding, loadedComps, refChanged);
                            continue;
                        }
                        samenode = (BindingNode)((Object[])obj)[0];
                        Component varRootComp = (Component)((Object[])obj)[1];
                        this.myLoadAllNodes(bean, samenode, new Component[]{varRootComp}, walkedNodes, savebinding, loadedComps, refChanged);
                    }
                    ++level;
                }
            }
        }

        private void myLoadAllNodes(Object bean, BindingNode node, Component[] collectionComps, Set walkedNodes, Binding savebinding, Set loadedComps, boolean refChanged) {
            if (walkedNodes.contains(node)) {
                return;
            }
            walkedNodes.add(node);
            if (collectionComps.length == 0) {
                return;
            }
            int sz = collectionComps.length;
            Component[][] kidCollectionCompsArray = new Component[sz][];
            for (int j = 0; j < sz; ++j) {
                kidCollectionCompsArray[j] = this.loadAllBindings(bean, node, collectionComps[j], savebinding, loadedComps, refChanged);
            }
            Iterator it = node.getKidNodes().iterator();
            while (it.hasNext()) {
                BindingNode kidnode = (BindingNode)it.next();
                Object kidbean = DataBinder.this.fetchValue(bean, kidnode, kidnode.getNodeId(), true);
                for (int j = 0; j < sz; ++j) {
                    this.myLoadAllNodes(kidbean, kidnode, kidCollectionCompsArray[j], walkedNodes, savebinding, loadedComps, true);
                }
            }
            it = new ArrayList(node.getSameNodes()).iterator();
            while (it.hasNext()) {
                BindingNode samenode;
                Object obj = it.next();
                if (!(obj instanceof BindingNode) || node == (samenode = (BindingNode)obj) || (samenode.isVar() ? !samenode.isRoot() || !this.isSameBean(samenode, bean) || samenode.isInnerCollectionNode() : node.isVar() && !this.isSameBean(samenode, bean))) continue;
                this.myLoadAllNodes(bean, samenode, collectionComps, walkedNodes, savebinding, loadedComps, refChanged);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Component[] loadAllBindings(Object bean, BindingNode node, Component collectionComp, Binding savebinding, Set loadedComps, boolean refChanged) {
            Component[] componentArray;
            LinkedHashSet bindings = node.getBindings();
            Component[] collectionComps = null;
            Iterator it = bindings.iterator();
            while (it.hasNext()) {
                Binding binding = (Binding)it.next();
                if (loadedComps.contains(new Dual(collectionComp, binding))) continue;
                loadedComps.add(new Dual(collectionComp, binding));
                if (binding == savebinding) continue;
                String attr = binding.getAttr();
                boolean isCollectionItem = "_var".equals(attr);
                Component comp = binding.getComponent();
                if (DataBinder.isTemplate(comp)) {
                    Component[] clonecomps = new Component[]{};
                    if (DataBinder.isClone(collectionComp)) {
                        Component clonecomp = DataBinder.lookupClone(collectionComp, comp);
                        if (clonecomp == null) {
                            if (!isCollectionItem) throw new UiException("Cannot find associated CollectionItem=" + comp + ", binding=" + binding + ", collectionComp=" + collectionComp);
                            clonecomps = DataBinder.this.getCollectionItems(comp, bean, isCollectionItem);
                        } else {
                            clonecomps = new Component[]{clonecomp};
                        }
                    } else {
                        clonecomps = DataBinder.this.getCollectionItems(comp, bean, isCollectionItem);
                    }
                    if (refChanged) {
                        for (int j = 0; j < clonecomps.length; ++j) {
                            Component clonecomp = clonecomps[j];
                            binding.loadAttribute(clonecomp);
                        }
                    }
                    if (!isCollectionItem) continue;
                    collectionComps = clonecomps;
                    for (int j = 0; j < collectionComps.length; ++j) {
                        this.loadAllBindings(bean, node, collectionComps[j], binding, loadedComps, refChanged);
                    }
                    break;
                }
                if (!refChanged) continue;
                binding.loadAttribute(comp);
            }
            if (collectionComps == null) {
                Component[] componentArray2 = new Component[1];
                componentArray = componentArray2;
                componentArray2[0] = collectionComp;
                return componentArray;
            } else {
                componentArray = collectionComps;
            }
            return componentArray;
        }

        private boolean isSameBean(BindingNode node, Object bean) {
            LinkedHashSet bindings = node.getBindings();
            if (bindings.isEmpty()) {
                return true;
            }
            Component comp = ((Binding)bindings.iterator().next()).getComponent();
            if (DataBinder.isTemplate(comp)) {
                return true;
            }
            Object nodebean = DataBinder.this.getBeanWithExpression(comp, node.getPath());
            return Objects.equals((Object)nodebean, (Object)bean);
        }

        private class Dual
        implements Serializable {
            private static final long serialVersionUID = 200808191743L;
            private Component _comp;
            private Binding _binding;

            public Dual(Component comp, Binding binding) {
                this._comp = comp;
                this._binding = binding;
            }

            public int hashCode() {
                return (this._comp == null ? 0 : this._comp.hashCode()) ^ (this._binding == null ? 0 : this._binding.hashCode());
            }

            public boolean equals(Object other) {
                Dual o = (Dual)other;
                return o._comp == this._comp && o._binding == this._binding;
            }
        }
    }
}

