/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.ModificationException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zkplus.databind.BindingSaveEvent;
import org.zkoss.zkplus.databind.CollectionItem;
import org.zkoss.zkplus.databind.CollectionItemExt;
import org.zkoss.zkplus.databind.DataBinder;
import org.zkoss.zkplus.databind.TypeConverter;
import org.zkoss.zul.impl.InputElement;

public class Binding
implements Serializable {
    private static final long serialVersionUID = 200808191512L;
    private DataBinder _binder;
    private Component _comp;
    private String _attr;
    private String _expression;
    private LinkedHashSet _loadWhenEvents;
    private LinkedHashSet _loadAfterEvents;
    private LinkedHashSet _saveWhenEvents;
    private LinkedHashSet _saveAfterEvents;
    private boolean _loadable = true;
    private boolean _savable;
    private TypeConverter _converter;
    private String[] _paths;
    private Map _args;

    Binding(DataBinder binder, Component comp, String attr, String expr, LinkedHashSet loadWhenEvents, LinkedHashSet saveWhenEvents, String access, String converter) {
        this(binder, comp, attr, expr, loadWhenEvents, saveWhenEvents, access, converter, null, null, null);
    }

    Binding(DataBinder binder, Component comp, String attr, String expr, LinkedHashSet loadWhenEvents, LinkedHashSet saveWhenEvents, String access, String converter, Map args) {
        this(binder, comp, attr, expr, loadWhenEvents, saveWhenEvents, access, converter, args, null, null);
    }

    Binding(DataBinder binder, Component comp, String attr, String expr, LinkedHashSet loadWhenEvents, LinkedHashSet saveWhenEvents, String access, String converter, Map args, LinkedHashSet loadAfterEvents, LinkedHashSet saveAfterEvents) {
        this._binder = binder;
        this._comp = comp;
        this.setAttr(attr);
        this.setExpression(expr);
        this.setLoadWhenEvents(loadWhenEvents);
        this.setLoadAfterEvents(loadAfterEvents);
        this.setSaveWhenEvents(saveWhenEvents);
        this.setSaveAfterEvents(saveAfterEvents);
        this.setAccess(access);
        this.setConverter(converter);
        this.setArgs(args);
    }

    public DataBinder getBinder() {
        return this._binder;
    }

    public Component getComponent() {
        return this._comp;
    }

    void setAttr(String attr) {
        this._attr = attr;
    }

    public String getAttr() {
        return this._attr;
    }

    void setArgs(Map args) {
        this._args = args;
    }

    public Map getArgs() {
        return this._args;
    }

    void setExpression(String expr) {
        this._expression = expr;
        this._paths = this.parseBeanExpression(expr);
    }

    private String[] parseBeanExpression(String expr) {
        String[] paths = new String[]{expr};
        return paths;
    }

    public String getExpression() {
        return this._expression;
    }

    String[] getPaths() {
        return this._paths;
    }

    void setSaveWhenEvents(LinkedHashSet saveWhenEvents) {
        this._saveWhenEvents = saveWhenEvents;
    }

    public Set getSaveWhenEvents() {
        return this._saveWhenEvents;
    }

    void setSaveAfterEvents(LinkedHashSet saveAfterEvents) {
        this._saveAfterEvents = saveAfterEvents;
    }

    public Set getAfterWhenEvents() {
        return this._saveAfterEvents;
    }

    void setLoadWhenEvents(LinkedHashSet loadWhenEvents) {
        this._loadWhenEvents = loadWhenEvents;
    }

    public LinkedHashSet getLoadWhenEvents() {
        return this._loadWhenEvents;
    }

    void setLoadAfterEvents(LinkedHashSet loadAfterEvents) {
        this._loadAfterEvents = loadAfterEvents;
    }

    public LinkedHashSet getLoadAfterEvents() {
        return this._loadAfterEvents;
    }

    void setAccess(String access) {
        if (access == null) {
            return;
        }
        if ("both".equals(access)) {
            this._loadable = true;
            this._savable = true;
        } else if ("load".equals(access)) {
            this._loadable = true;
            this._savable = false;
        } else if ("save".equals(access)) {
            this._loadable = false;
            this._savable = true;
        } else if ("none".equals(access)) {
            this._loadable = false;
            this._savable = false;
        } else {
            throw new UiException("Unknown DataBinder access mode. Should be \"both\", \"load\", \"save\", or \"none\": " + access);
        }
    }

    public boolean isLoadable() {
        return this._loadable;
    }

    public boolean isSavable() {
        return this._savable;
    }

    void setConverter(String cvtClsName) {
        if (cvtClsName != null) {
            Class cls = null;
            if (this._comp == null || this._comp.getPage() == null) {
                try {
                    cls = Classes.forNameByThread((String)cvtClsName);
                }
                catch (ClassNotFoundException ex) {
                    throw UiException.Aide.wrap((Throwable)ex);
                }
            } else {
                cls = this._comp.getPage().getZScriptClass(cvtClsName);
                if (cls == null) {
                    throw UiException.Aide.wrap((Throwable)new ClassNotFoundException(cvtClsName));
                }
            }
            try {
                this._converter = (TypeConverter)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    public TypeConverter getConverter() {
        return this._converter;
    }

    public void loadAttribute(Component comp) {
        if (!this.isLoadable() || this._attr.startsWith("_") || DataBinder.isTemplate(comp) || comp == null || comp.getPage() == null) {
            return;
        }
        Object bean = this._binder.getBeanAndRegisterBeanSameNodes(comp, this._expression);
        this.myLoadAttribute(comp, bean);
    }

    public void loadAttribute(Component comp, Object bean) {
        if (!this.isLoadable() || this._attr.startsWith("_") || DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return;
        }
        this.myLoadAttribute(comp, bean);
    }

    private void myLoadAttribute(Component comp, Object bean) {
        block13: {
            try {
                HashMap bindArgs = (HashMap)comp.getAttribute("bindingArgs");
                if (bindArgs == null) {
                    bindArgs = new HashMap();
                    comp.setAttribute("bindingArgs", bindArgs);
                }
                if (this._args != null) {
                    bindArgs.putAll(this._args);
                    comp.setAttribute(this._attr + "_" + "bindingArgs", (Object)this._args);
                }
                if (this._converter != null && (bean = this._converter.coerceToUi(bean, comp)) == TypeConverter.IGNORE) {
                    return;
                }
                if (comp instanceof InputElement && "value".equals(this._attr)) {
                    Object value = bean;
                    Object oldv = null;
                    try {
                        Method m = comp.getClass().getMethod("getValue", null);
                        oldv = ((InputElement)comp).getRawValue();
                        value = Classes.coerce(m.getReturnType(), (Object)bean);
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                    if (!Objects.equals(oldv, (Object)value)) {
                        Fields.set((Object)comp, (String)"rawValue", (Object)value, (this._converter == null ? 1 : 0) != 0);
                    }
                    break block13;
                }
                Fields.set((Object)comp, (String)this._attr, (Object)bean, (this._converter == null ? 1 : 0) != 0);
            }
            catch (ClassCastException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                if (comp instanceof DynamicPropertied) {
                    DynamicPropertied dpcomp = (DynamicPropertied)comp;
                    if (dpcomp.hasDynamicProperty(this._attr)) {
                        dpcomp.setDynamicProperty(this._attr, bean);
                    }
                    throw UiException.Aide.wrap((Throwable)ex);
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            catch (ModificationException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    public void saveAttribute(Component comp) {
        Object[] vals = this.getAttributeValues(comp);
        if (vals != null) {
            this.saveAttributeValue(comp, vals, null);
        }
    }

    private void saveAttributeValue(Component comp, Object[] vals, List loadOnSaveInfos) {
        if (vals == null) {
            return;
        }
        Object val = vals[0];
        Object rawval = vals[1];
        this._binder.setBeanAndRegisterBeanSameNodes(comp, val, this, this._expression, this._converter == null, rawval, loadOnSaveInfos);
    }

    private Object[] getAttributeValues(Component comp) {
        if (!this.isSavable() || this._attr.startsWith("_") || DataBinder.isTemplate(comp) || comp.getPage() == null) {
            return null;
        }
        Object rawval = null;
        try {
            rawval = Fields.get((Object)comp, (String)this._attr);
        }
        catch (NoSuchMethodException ex) {
            if (comp instanceof DynamicPropertied) {
                DynamicPropertied dpcomp = (DynamicPropertied)comp;
                if (dpcomp.hasDynamicProperty(this._attr)) {
                    rawval = dpcomp.getDynamicProperty(this._attr);
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            throw UiException.Aide.wrap((Throwable)ex);
        }
        try {
            Object[] objectArray;
            Object val;
            Object object = val = this._converter == null ? rawval : this._converter.coerceToBean(rawval, comp);
            if (val == TypeConverter.IGNORE) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = val;
                objectArray = objectArray2;
                objectArray2[1] = rawval;
            }
            return objectArray;
        }
        catch (ClassCastException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    void registerSaveEvents(Component comp) {
        if (this.isSavable()) {
            BaseSaveEventListener listener;
            String evtname;
            Component target;
            Object[] objs;
            String expr;
            Iterator it;
            if (this._saveWhenEvents != null) {
                it = this._saveWhenEvents.iterator();
                while (it.hasNext()) {
                    expr = (String)it.next();
                    objs = ComponentsCtrl.parseEventExpression((Component)comp, (String)expr, (Component)comp, (boolean)false);
                    target = (Component)objs[0];
                    evtname = (String)objs[1];
                    listener = (SaveEventListener)target.getAttribute("zk.SaveEventListener." + evtname);
                    if (listener == null) {
                        listener = new SaveEventListener();
                        target.setAttribute("zk.SaveEventListener." + evtname, (Object)listener);
                        target.addEventListener(evtname, (EventListener)listener);
                    }
                    listener.addDataTarget(this, comp);
                }
            }
            if (this._saveAfterEvents != null) {
                it = this._saveAfterEvents.iterator();
                while (it.hasNext()) {
                    expr = (String)it.next();
                    objs = ComponentsCtrl.parseEventExpression((Component)comp, (String)expr, (Component)comp, (boolean)false);
                    target = (Component)objs[0];
                    evtname = (String)objs[1];
                    listener = (SaveAfterEventListener)target.getAttribute("zk.SaveAfterEventListener." + evtname);
                    if (listener == null) {
                        listener = new SaveAfterEventListener();
                        target.setAttribute("zk.SaveAfterEventListener." + evtname, (Object)listener);
                        target.addEventListener(evtname, (EventListener)listener);
                        target.addEventListener(evtname + "SaveAfter", (EventListener)listener);
                    }
                    listener.addDataTarget(this, comp);
                }
            }
        }
    }

    void registerLoadEvents(Component comp) {
        if (this.isLoadable()) {
            BaseLoadEventListener listener;
            String evtname;
            Component target;
            Object[] objs;
            String expr;
            Iterator it;
            if (this._loadWhenEvents != null) {
                it = this._loadWhenEvents.iterator();
                while (it.hasNext()) {
                    expr = (String)it.next();
                    objs = ComponentsCtrl.parseEventExpression((Component)comp, (String)expr, (Component)comp, (boolean)false);
                    target = (Component)objs[0];
                    evtname = (String)objs[1];
                    listener = (LoadEventListener)target.getAttribute("zk.LoadEventListener." + evtname);
                    if (listener == null) {
                        listener = new LoadEventListener();
                        target.setAttribute("zk.LoadEventListener." + evtname, (Object)listener);
                        target.addEventListener(evtname, (EventListener)listener);
                    }
                    listener.addDataTarget(this, comp);
                }
            }
            if (this._loadAfterEvents != null) {
                it = this._loadAfterEvents.iterator();
                while (it.hasNext()) {
                    expr = (String)it.next();
                    objs = ComponentsCtrl.parseEventExpression((Component)comp, (String)expr, (Component)comp, (boolean)false);
                    target = (Component)objs[0];
                    evtname = (String)objs[1];
                    listener = (LoadAfterEventListener)target.getAttribute("zk.LoadAfterEventListener." + evtname);
                    if (listener == null) {
                        listener = new LoadAfterEventListener();
                        target.setAttribute("zk.LoadAfterEventListener." + evtname, (Object)listener);
                        target.addEventListener(evtname, (EventListener)listener);
                        target.addEventListener(evtname + "LoadAfter", (EventListener)listener);
                    }
                    listener.addDataTarget(this, comp);
                }
            }
        }
    }

    public String toString() {
        return "[binder:" + this._binder + ", comp:" + this._comp + ", attr:" + this._attr + ", expr:" + this._expression + ", load-when:" + this._loadWhenEvents + ", save-when:" + this._saveWhenEvents + ", load-after:" + this._loadAfterEvents + ", save-after:" + this._saveAfterEvents + ", load:" + this._loadable + ", save:" + this._savable + ", converter:" + this._converter + "]";
    }

    private static List scanClones(DataBinder binder, Component comp) {
        if (DataBinder.isTemplate(comp)) {
            List owners = Binding.scanClones(binder, binder.getCollectionOwner(comp));
            ArrayList<Component> kidowners = new ArrayList<Component>(1024);
            Iterator it = owners.iterator();
            while (it.hasNext()) {
                Component owner = (Component)it.next();
                CollectionItem decor = binder.getCollectionItemByOwner(owner);
                if (decor instanceof CollectionItemExt) {
                    CollectionItemExt decorex = (CollectionItemExt)decor;
                    Iterator iti = decorex.getItems(owner).iterator();
                    while (iti.hasNext()) {
                        Component item = (Component)iti.next();
                        kidowners.add(DataBinder.lookupClone(item, comp));
                    }
                    continue;
                }
                try {
                    int j = 0;
                    while (true) {
                        Component item = decor.getComponentAtIndexByOwner(owner, j);
                        kidowners.add(DataBinder.lookupClone(item, comp));
                        ++j;
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                }
            }
            return kidowners;
        }
        ArrayList<Component> owners = new ArrayList<Component>(1);
        owners.add(comp);
        return owners;
    }

    private static abstract class BaseSaveEventListener
    extends BaseEventListener {
        protected void handleEvent(Event event) {
            Object[] vals;
            Component target = event.getTarget();
            ArrayList<BindingInfo> tmplist = new ArrayList<BindingInfo>(this._dataTargets.size());
            Iterator it = this._dataTargets.iterator();
            while (it.hasNext()) {
                Component dataTarget;
                BindingInfo bi = (BindingInfo)it.next();
                Component dt = bi.getComponent();
                Binding binding = bi.getBinding();
                DataBinder binder = binding.getBinder();
                Component component = dataTarget = DataBinder.isTemplate(dt) ? DataBinder.lookupClone(target, dt) : dt;
                if (dataTarget != null) {
                    vals = binding.getAttributeValues(dataTarget);
                    if (vals == null) continue;
                    tmplist.add(new BindingInfo(binding, dataTarget, vals));
                    Events.sendEvent((Event)new BindingSaveEvent("onBindingSave", dataTarget, target, binding, vals[0]));
                    continue;
                }
                List clones = Binding.scanClones(binder, dt);
                Iterator itc = clones.iterator();
                while (itc.hasNext()) {
                    Component dataTarget1 = (Component)itc.next();
                    Object[] vals2 = binding.getAttributeValues(dataTarget1);
                    if (vals2 == null) continue;
                    tmplist.add(new BindingInfo(binding, dataTarget1, vals2));
                    Events.sendEvent((Event)new BindingSaveEvent("onBindingSave", dataTarget1, target, binding, vals2[0]));
                }
            }
            Events.sendEvent((Event)new Event("onBindingValidate", target));
            Component loadOnSaveProxy = null;
            Component dataTarget = null;
            ArrayList loadOnSaveInfos = new ArrayList(tmplist.size());
            Iterator it2 = tmplist.iterator();
            while (it2.hasNext()) {
                BindingInfo bi = (BindingInfo)it2.next();
                dataTarget = bi.getComponent();
                Binding binding = bi.getBinding();
                vals = bi.getAttributeValues();
                binding.saveAttributeValue(dataTarget, vals, loadOnSaveInfos);
                if (loadOnSaveProxy != null || !dataTarget.isListenerAvailable("onLoadOnSave", true)) continue;
                loadOnSaveProxy = dataTarget;
            }
            if (loadOnSaveProxy != null) {
                Events.postEvent((Event)new Event("onLoadOnSave", loadOnSaveProxy, loadOnSaveInfos));
            }
        }
    }

    private static class SaveEventListener
    extends BaseSaveEventListener
    implements Express {
        private static final long serialVersionUID = 200808191313L;

        public void onEvent(Event event) {
            this.handleEvent(event);
        }
    }

    private static class SaveAfterEventListener
    extends BaseSaveEventListener {
        private static final long serialVersionUID = 20090423143051L;

        public void onEvent(Event event) {
            if (event instanceof AfterEvent) {
                this.handleEvent((Event)event.getData());
            } else {
                Events.postEvent((int)-10100, (Event)new AfterEvent(event.getName() + "SaveAfter", event));
            }
        }
    }

    private static class AfterEvent
    extends Event {
        public AfterEvent(String evtnm, Event event) {
            super(evtnm, event.getTarget(), (Object)event);
        }
    }

    private static class LoadAfterEventListener
    extends BaseLoadEventListener {
        private static final long serialVersionUID = 20090423120513L;

        public void onEvent(Event event) {
            if (event instanceof AfterEvent) {
                this.handleEvent((Event)event.getData());
            } else {
                Events.postEvent((int)-10100, (Event)new AfterEvent(event.getName() + "LoadAfter", event));
            }
        }
    }

    private static class LoadEventListener
    extends BaseLoadEventListener
    implements Express {
        private static final long serialVersionUID = 200808191313L;

        public void onEvent(Event event) {
            this.handleEvent(event);
        }
    }

    private static abstract class BaseLoadEventListener
    extends BaseEventListener {
        protected void handleEvent(Event event) {
            Iterator it = this._dataTargets.iterator();
            while (it.hasNext()) {
                Component dataTarget;
                BindingInfo bi = (BindingInfo)it.next();
                Component dt = bi.getComponent();
                Binding binding = bi.getBinding();
                DataBinder binder = binding.getBinder();
                Component component = dataTarget = DataBinder.isTemplate(dt) ? DataBinder.lookupClone(event.getTarget(), dt) : dt;
                if (dataTarget != null) {
                    binding.loadAttribute(dataTarget);
                    continue;
                }
                List clones = Binding.scanClones(binder, dt);
                Iterator itc = clones.iterator();
                while (itc.hasNext()) {
                    Component dataTarget1 = (Component)itc.next();
                    binding.loadAttribute(dataTarget1);
                }
            }
        }
    }

    private static abstract class BaseEventListener
    implements EventListener,
    Serializable {
        protected List _dataTargets = new ArrayList(8);

        public void addDataTarget(Binding binding, Component comp) {
            this._dataTargets.add(new BindingInfo(binding, comp, null));
        }
    }

    private static class BindingInfo
    implements Serializable {
        private static final long serialVersionUID = 200808191315L;
        private Binding _binding;
        private Component _comp;
        private Object[] _vals;

        public BindingInfo(Binding binding, Component comp, Object[] vals) {
            this._binding = binding;
            this._comp = comp;
            this._vals = vals;
        }

        public Component getComponent() {
            return this._comp;
        }

        public Binding getBinding() {
            return this._binding;
        }

        public Object[] getAttributeValues() {
            return this._vals;
        }
    }
}

