/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.io.Serializables;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;

public abstract class AbstractTreeModel
implements TreeModel,
Serializable {
    private Object _root;
    private transient List _listeners = new LinkedList();

    public AbstractTreeModel(Object root) {
        this._root = root;
    }

    public Object getRoot() {
        return this._root;
    }

    protected void fireEvent(Object node, int indexFrom, int indexTo, int evtType) {
        TreeDataEvent evt = new TreeDataEvent(this, evtType, node, indexFrom, indexTo);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((TreeDataListener)it.next()).onChange(evt);
        }
    }

    public int[] getPath(Object parent, Object lastNode) {
        ArrayList l = new ArrayList();
        this.dfSearch(l, parent, lastNode);
        Object[] objs = l.toArray();
        int[] path = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            path[i] = (Integer)objs[i];
        }
        return path;
    }

    private boolean dfSearch(List path, Object node, Object target) {
        if (node.equals(target)) {
            return true;
        }
        int size = this.getChildCount(node);
        for (int i = 0; i < size; ++i) {
            boolean flag = this.dfSearch(path, this.getChild(node, i), target);
            if (!flag) continue;
            path.add(0, new Integer(i));
            return true;
        }
        return false;
    }

    public void addTreeDataListener(TreeDataListener l) {
        this._listeners.add(l);
    }

    public void removeTreeDataListener(TreeDataListener l) {
        this._listeners.remove(l);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList();
        Serializables.smartRead((ObjectInputStream)s, (Collection)this._listeners);
    }
}

