/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Audio
extends XulElement
implements org.zkoss.zul.api.Audio {
    private String _align;
    private String _border;
    protected String _src;
    private org.zkoss.sound.Audio _audio;
    private byte _audver;
    private boolean _autostart;
    private boolean _loop;

    public Audio() {
    }

    public Audio(String src) {
        this.setSrc(src);
    }

    public void play() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "play"));
    }

    public void stop() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "stop"));
    }

    public void pause() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "pause"));
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) throws WrongValueException {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) throws WrongValueException {
        if (border != null && border.length() == 0) {
            border = null;
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._audio != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._audio = null;
            this.updateSrc();
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._audio != null ? this.getAudioSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./aud/mute.mid") : "");
    }

    public final boolean isAutostart() {
        return this._autostart;
    }

    public final void setAutostart(boolean autostart) {
        if (this._autostart != autostart) {
            this._autostart = autostart;
            this.smartUpdate("autostart", this._autostart);
        }
    }

    public void setContent(org.zkoss.sound.Audio audio) {
        if (this._src != null || audio != this._audio) {
            this._audio = audio;
            this._src = null;
            if (this._audio != null) {
                this._audver = (byte)(this._audver + 1);
            }
            this.updateSrc();
        }
    }

    private void updateSrc() {
        this.invalidate();
    }

    public org.zkoss.sound.Audio getContent() {
        return this._audio;
    }

    private String getAudioSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._audver, this._audio.getName(), this._audio.getFormat());
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getEncodedSrc());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"autostart", (boolean)this._autostart);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"loop", (boolean)this._loop);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"border", (String)this._border);
        sb.append(" z.autohide=\"true\"");
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Audio.this);
        }

        public Media getMedia(String pathInfo) {
            return Audio.this._audio;
        }
    }
}

