/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.Imagemap;
import org.zkoss.zul.WaferMapModel;
import org.zkoss.zul.event.ChartAreaListener;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;
import org.zkoss.zul.impl.ChartEngine;

public class Chart
extends Imagemap
implements org.zkoss.zul.api.Chart {
    public static final String PIE = "pie";
    public static final String RING = "ring";
    public static final String BAR = "bar";
    public static final String LINE = "line";
    public static final String AREA = "area";
    public static final String STACKED_BAR = "stacked_bar";
    public static final String STACKED_AREA = "stacked_area";
    public static final String WATERFALL = "waterfall";
    public static final String POLAR = "polar";
    public static final String SCATTER = "scatter";
    public static final String TIME_SERIES = "time_series";
    public static final String STEP = "step";
    public static final String STEP_AREA = "step_area";
    public static final String HISTOGRAM = "histogram";
    public static final String CANDLESTICK = "candlestick";
    public static final String HIGHLOW = "highlow";
    public static final String BUBBLE = "bubble";
    public static final String WAFERMAP = "wafermap";
    public static final String GANTT = "gantt";
    public static final String WIND = "wind";
    private static final Map DEFAULT_MODEL = new HashMap();
    public static final String YEAR = "year";
    public static final String QUARTER = "quarter";
    public static final String MONTH = "month";
    public static final String WEEK = "week";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    public static final String MILLISECOND = "millisecond";
    private boolean _smartDrawChart;
    private transient ChartDataListener _dataListener;
    private transient EventListener _smartDrawChartListener;
    private String _type = "pie";
    private boolean _threeD;
    private String _title;
    private int _intWidth = 400;
    private int _intHeight = 200;
    private String _xAxis;
    private String _yAxis;
    private boolean _showLegend = true;
    private boolean _showTooltiptext = true;
    private String _orient = "vertical";
    private ChartAreaListener _areaListener;
    private String _paneColor;
    private int[] _paneRGB;
    private int _paneAlpha = 255;
    private int _fgAlpha = 255;
    private String _bgColor;
    private int[] _bgRGB;
    private int _bgAlpha = 255;
    private TimeZone _tzone;
    private String _period;
    private String _dateFormat;
    private ChartModel _model;
    private ChartEngine _engine;

    public Chart() {
        this.init();
        this.setWidth("500px");
        this.setHeight("250px");
    }

    private ChartModel createDefaultModel() {
        if (WAFERMAP.equals(this.getType())) {
            return new WaferMapModel(100, 100);
        }
        String klass = (String)DEFAULT_MODEL.get(this.getType());
        if (klass != null) {
            try {
                return (ChartModel)Classes.newInstanceByThread((String)klass);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        throw new UiException("unknown chart type: " + this.getType());
    }

    private void init() {
        if (this._smartDrawChartListener == null) {
            this._smartDrawChartListener = new EventListener(){

                public void onEvent(Event event) {
                    if (Strings.isBlank((String)Chart.this.getType())) {
                        throw new UiException("chart must specify type (pie, bar, line, ...)");
                    }
                    if (Chart.this._model == null) {
                        Chart.this._model = Chart.this.createDefaultModel();
                    }
                    if (Strings.isBlank((String)Chart.this.getWidth())) {
                        throw new UiException("chart must specify width");
                    }
                    if (Strings.isBlank((String)Chart.this.getHeight())) {
                        throw new UiException("chart must specify height");
                    }
                    try {
                        String title = Chart.this.getTitle();
                        AImage image = new AImage("chart" + new Date().getTime(), Chart.this.getEngine().drawChart(Chart.this));
                        Chart.this.setContent((Image)image);
                    }
                    catch (IOException ex) {
                        throw UiException.Aide.wrap((Throwable)ex);
                    }
                    finally {
                        Chart.this._smartDrawChart = false;
                    }
                }
            };
        }
        this.addEventListener("onSmartDrawChart", this._smartDrawChartListener);
    }

    public void setType(String type) {
        if (Objects.equals((Object)this._type, (Object)type)) {
            return;
        }
        this._type = type;
        this.smartDrawChart();
    }

    public String getType() {
        return this._type;
    }

    public void setThreeD(boolean b) {
        if (this._threeD == b) {
            return;
        }
        this._threeD = b;
        this.smartDrawChart();
    }

    public boolean isThreeD() {
        return this._threeD;
    }

    public void setTitle(String title) {
        if (Objects.equals((Object)this._title, (Object)title)) {
            return;
        }
        this._title = title;
        this.smartDrawChart();
    }

    public String getTitle() {
        return this._title;
    }

    public void setWidth(String w) {
        if (Objects.equals((Object)w, (Object)this.getWidth())) {
            return;
        }
        this._intWidth = Chart.stringToInt(w);
        super.setWidth(w);
        this.smartDrawChart();
    }

    public int getIntWidth() {
        return this._intWidth;
    }

    public void setHeight(String h) {
        if (Objects.equals((Object)h, (Object)this.getHeight())) {
            return;
        }
        this._intHeight = Chart.stringToInt(h);
        super.setHeight(h);
        this.smartDrawChart();
    }

    public int getIntHeight() {
        return this._intHeight;
    }

    public void setXAxis(String label) {
        if (Objects.equals((Object)this._xAxis, (Object)label)) {
            return;
        }
        this._xAxis = label;
        this.smartDrawChart();
    }

    public String getXAxis() {
        return this._xAxis;
    }

    public void setYAxis(String label) {
        if (Objects.equals((Object)this._yAxis, (Object)label)) {
            return;
        }
        this._yAxis = label;
        this.smartDrawChart();
    }

    public String getYAxis() {
        return this._yAxis;
    }

    public void setShowLegend(boolean showLegend) {
        if (this._showLegend == showLegend) {
            return;
        }
        this._showLegend = showLegend;
        this.smartDrawChart();
    }

    public boolean isShowLegend() {
        return this._showLegend;
    }

    public void setShowTooltiptext(boolean showTooltiptext) {
        if (this._showTooltiptext == showTooltiptext) {
            return;
        }
        this._showTooltiptext = showTooltiptext;
        this.smartDrawChart();
    }

    public boolean isShowTooltiptext() {
        return this._showTooltiptext;
    }

    public void setPaneAlpha(int alpha) {
        if (alpha == this._paneAlpha) {
            return;
        }
        if (alpha > 255 || alpha < 0) {
            alpha = 255;
        }
        this._paneAlpha = alpha;
        this.smartDrawChart();
    }

    public int getPaneAlpha() {
        return this._paneAlpha;
    }

    public void setPaneColor(String color) {
        if (Objects.equals((Object)color, (Object)this._paneColor)) {
            return;
        }
        this._paneColor = color;
        if (this._paneColor == null) {
            this._paneRGB = null;
        } else {
            this._paneRGB = new int[3];
            Chart.decode(this._paneColor, this._paneRGB);
        }
        this.smartDrawChart();
    }

    public String getPaneColor() {
        return this._paneColor;
    }

    public int[] getPaneRGB() {
        return this._paneRGB;
    }

    public void setFgAlpha(int alpha) {
        if (alpha == this._fgAlpha) {
            return;
        }
        if (alpha > 255 || alpha < 0) {
            alpha = 255;
        }
        this._fgAlpha = alpha;
        this.smartDrawChart();
    }

    public int getFgAlpha() {
        return this._fgAlpha;
    }

    public void setBgAlpha(int alpha) {
        if (alpha == this._bgAlpha) {
            return;
        }
        if (alpha > 255 || alpha < 0) {
            alpha = 255;
        }
        this._bgAlpha = alpha;
        this.smartDrawChart();
    }

    public int getBgAlpha() {
        return this._bgAlpha;
    }

    public void setBgColor(String color) {
        if (Objects.equals((Object)color, (Object)this._bgColor)) {
            return;
        }
        this._bgColor = color;
        if (this._bgColor == null) {
            this._bgRGB = null;
        } else {
            this._bgRGB = new int[3];
            Chart.decode(this._bgColor, this._bgRGB);
        }
        this.smartDrawChart();
    }

    public String getBgColor() {
        return this._bgColor;
    }

    public int[] getBgRGB() {
        return this._bgRGB;
    }

    public void setOrient(String orient) {
        if (Objects.equals((Object)orient, (Object)this._orient)) {
            return;
        }
        this._orient = orient;
        this.smartDrawChart();
    }

    public String getOrient() {
        return this._orient;
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        if (Objects.equals((Object)tzone, (Object)this._tzone)) {
            return;
        }
        this._tzone = tzone;
        this.smartDrawChart();
    }

    public String getPeriod() {
        return this._period;
    }

    public void setPeriod(String period) {
        if (Objects.equals((Object)period, (Object)this._period)) {
            return;
        }
        this._period = period;
        this.smartDrawChart();
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(String format) {
        if (Objects.equals((Object)format, (Object)this._dateFormat)) {
            return;
        }
        this._dateFormat = format;
        this.smartDrawChart();
    }

    public ChartModel getModel() {
        return this._model;
    }

    public void setModel(ChartModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeChartDataListener(this._dataListener);
            }
            this._model = model;
            this.initDataListener();
        }
        this.smartDrawChart();
    }

    public void setModel(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setModel((ChartModel)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public ChartEngine getEngine() throws UiException {
        if (this._engine == null) {
            this._engine = this.newChartEngine();
        }
        return this._engine;
    }

    protected ChartEngine newChartEngine() throws UiException {
        Object v = this.getAttribute("chart-engine");
        if (v == null) {
            v = "org.zkoss.zkex.zul.impl.JFreeChartEngine";
        }
        try {
            Class cls;
            if (v instanceof String) {
                cls = Classes.forNameByThread((String)((String)v));
            } else if (v instanceof Class) {
                cls = (Class)v;
            } else {
                throw new UiException(v != null ? "Unknown chart-engine, " + v : "The chart-engine attribute is not defined");
            }
            v = cls.newInstance();
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        if (!(v instanceof ChartEngine)) {
            throw new UiException(ChartEngine.class + " must be implemented by " + v);
        }
        return (ChartEngine)v;
    }

    public void setEngine(ChartEngine engine) {
        if (this._engine != engine) {
            this._engine = engine;
        }
        this.smartDrawChart();
    }

    public void setEngine(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setEngine((ChartEngine)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ChartDataListener(){

                public void onChange(ChartDataEvent event) {
                    Chart.this.smartDrawChart();
                }
            };
        }
        this._model.addChartDataListener(this._dataListener);
    }

    public ChartAreaListener getAreaListener() {
        return this._areaListener;
    }

    public void setAreaListener(ChartAreaListener listener) {
        if (this._areaListener != listener) {
            this._areaListener = listener;
        }
    }

    public void setAreaListener(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setAreaListener((ChartAreaListener)Classes.newInstanceByThread((String)clsnm));
        }
    }

    protected void smartDrawChart() {
        if (this._smartDrawChart) {
            return;
        }
        this._smartDrawChart = true;
        Events.postEvent((String)"onSmartDrawChart", (Component)this, null);
    }

    static void decode(String color, int[] rgb) {
        if (color == null) {
            return;
        }
        if (color.length() != 7 || !color.startsWith("#")) {
            throw new UiException("Incorrect color format (#RRGGBB) : " + color);
        }
        rgb[0] = Integer.parseInt(color.substring(1, 3), 16);
        rgb[1] = Integer.parseInt(color.substring(3, 5), 16);
        rgb[2] = Integer.parseInt(color.substring(5, 7), 16);
    }

    static int stringToInt(String str) {
        int j = str.lastIndexOf("px");
        if (j > 0) {
            String num = str.substring(0, j);
            return Integer.parseInt(num);
        }
        j = str.lastIndexOf("pt");
        if (j > 0) {
            String num = str.substring(0, j);
            return (int)((double)Integer.parseInt(num) * 1.3333);
        }
        j = str.lastIndexOf("em");
        if (j > 0) {
            String num = str.substring(0, j);
            return (int)((double)Integer.parseInt(num) * 13.3333);
        }
        return Integer.parseInt(str);
    }

    public Object clone() {
        Chart clone = (Chart)super.clone();
        clone.getChildren().clear();
        clone._smartDrawChartListener = null;
        clone._smartDrawChart = false;
        clone.init();
        clone.smartDrawChart();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.getChildren().clear();
        this.init();
        this.smartDrawChart();
        if (this._model != null) {
            this.initDataListener();
        }
    }

    static {
        DEFAULT_MODEL.put(PIE, "org.zkoss.zul.SimplePieModel");
        DEFAULT_MODEL.put(RING, "org.zkoss.zul.SimplePieModel");
        DEFAULT_MODEL.put(BAR, "org.zkoss.zul.SimpleCategoryModel");
        DEFAULT_MODEL.put(LINE, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(AREA, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(STACKED_BAR, "org.zkoss.zul.SimpleCategoryModel");
        DEFAULT_MODEL.put(STACKED_AREA, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(WATERFALL, "org.zkoss.zul.SimpleCategoryModel");
        DEFAULT_MODEL.put(POLAR, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(SCATTER, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(TIME_SERIES, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(STEP, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(STEP_AREA, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(HISTOGRAM, "org.zkoss.zul.SimpleXYModel");
        DEFAULT_MODEL.put(CANDLESTICK, "org.zkoss.zul.SimpleHiLoModel");
        DEFAULT_MODEL.put(HIGHLOW, "org.zkoss.zul.SimpleHiLoModel");
        DEFAULT_MODEL.put(BUBBLE, "org.zkoss.zul.SimpleXYZModel");
        DEFAULT_MODEL.put(GANTT, "org.zkoss.zul.GanttModel");
        DEFAULT_MODEL.put(WIND, "org.zkoss.zul.SimpleXYZModel");
    }
}

