/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.HashMap;
import java.util.List;
import org.zkoss.mesg.Messages;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.ext.client.Updatable;
import org.zkoss.zul.impl.FileuploadDlg;
import org.zkoss.zul.mesg.MZul;

public class Fileupload
extends HtmlBasedComponent
implements org.zkoss.zul.api.Fileupload {
    private static String _templ = "~./zul/html/fileuploaddlg.zul";
    private int _maxnum = 1;
    private boolean _native;
    private int _maxsize = -1;

    public int getMaxsize() {
        return this._maxsize;
    }

    public void setMaxsize(int maxsize) {
        if (maxsize < 0) {
            maxsize = -1;
        }
        this._maxsize = maxsize;
    }

    public boolean isChildable() {
        return false;
    }

    public int getNumber() {
        return this._maxnum;
    }

    public void setNumber(int maxnum) throws WrongValueException {
        if (maxnum < -1000 || maxnum == 0 || maxnum > 1000) {
            throw new WrongValueException(maxnum == 0 ? "Positive or Negative is required" : "Number too big (maximal 1000)");
        }
        this._maxnum = maxnum;
    }

    public boolean isNative() {
        return this._native;
    }

    public void setNative(boolean alwaysNative) {
        this._native = alwaysNative;
    }

    public void onClose() {
        this.invalidate();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    public static Media get() throws InterruptedException {
        return Fileupload.get(null, null, false);
    }

    public static Media get(boolean alwaysNative) throws InterruptedException {
        return Fileupload.get(null, null, alwaysNative);
    }

    public static Media get(String message, String title) throws InterruptedException {
        return Fileupload.get(message, title, false);
    }

    public static Media get(String message, String title, boolean alwaysNative) throws InterruptedException {
        Media[] result = Fileupload.get(message, title, 1, alwaysNative);
        return result != null ? result[0] : null;
    }

    public static Media[] get(int max) throws InterruptedException {
        return Fileupload.get(null, null, max, false);
    }

    public static Media[] get(int max, boolean alwaysNative) throws InterruptedException {
        return Fileupload.get(null, null, max, alwaysNative);
    }

    public static Media[] get(String message, String title, int max) throws InterruptedException {
        return Fileupload.get(message, title, max, false);
    }

    public static Media[] get(String message, String title, int max, boolean alwaysNative) throws InterruptedException {
        return Fileupload.get(message, title, max, -1, alwaysNative);
    }

    public static Media[] get(String message, String title, int max, int maxsize, boolean alwaysNative) throws InterruptedException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        Execution exec = Executions.getCurrent();
        params.put("message", message == null ? Messages.get((int)MZul.UPLOAD_MESSAGE) : message);
        params.put("title", title == null ? Messages.get((int)MZul.UPLOAD_TITLE) : title);
        params.put("max", new Integer(max == 0 ? 1 : (max > 1000 ? 1000 : (max < -1000 ? -1000 : max))));
        params.put("native", alwaysNative);
        params.put("maxsize", String.valueOf(maxsize));
        FileuploadDlg dlg = (FileuploadDlg)exec.createComponents(_templ, null, params);
        try {
            dlg.doModal();
        }
        catch (Throwable ex) {
            dlg.detach();
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            throw UiException.Aide.wrap((Throwable)ex);
        }
        return dlg.getResult();
    }

    public static void setTemplate(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        _templ = uri;
    }

    public static String getTemplate() {
        return _templ;
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Updatable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Fileupload.this);
        }

        public void setResult(Object result) {
            Events.postEvent((Event)new UploadEvent("onUpload", (Component)Fileupload.this, FileuploadDlg.parseResult((List)result)));
        }
    }
}

