/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listitem;

public class Listgroup
extends Listitem
implements org.zkoss.zul.api.Listgroup {
    private boolean _open = true;
    private transient List _items;

    public Listgroup() {
        this.init();
    }

    public Listgroup(String label) {
        this();
        this.setLabel(label);
    }

    public Listgroup(String label, Object value) {
        this();
        this.setLabel(label);
        this.setValue(value);
    }

    private void init() {
        this._items = new AbstractList(){

            public int size() {
                return Listgroup.this.getItemCount();
            }

            public Iterator iterator() {
                return new IterItems();
            }

            public Object get(int index) {
                Listbox lb = Listgroup.this.getListbox();
                if (lb == null) {
                    throw new IndexOutOfBoundsException("Index: " + index);
                }
                return lb.getItemAtIndex(Listgroup.this.getIndex() + index + 1);
            }
        };
    }

    public List getItems() {
        return this._items;
    }

    public int getItemCount() {
        int[] g;
        Listbox lb = this.getListbox();
        if (lb != null && (g = lb.getGroupsInfoAt(this.getIndex(), true)) != null) {
            if (g[2] == -1) {
                return g[1] - 1;
            }
            return g[1] - 2;
        }
        return 0;
    }

    public int getVisibleItemCount() {
        int count = this.getItemCount();
        int visibleCount = 0;
        if (this.getNextSibling() instanceof Listitem) {
            Listitem item = (Listitem)this.getNextSibling();
            while (count-- > 0) {
                if (item.isVisible()) {
                    ++visibleCount;
                }
                if (!(item.getNextSibling() instanceof Listitem)) break;
                item = (Listitem)item.getNextSibling();
            }
        }
        return visibleCount;
    }

    public int getListgroupfootIndex() {
        int[] g;
        Listbox lb = (Listbox)this.getParent();
        if (lb != null && (g = lb.getGroupsInfoAt(this.getIndex(), true)) != null) {
            return g[2];
        }
        return -1;
    }

    public Listfoot getListfoot() {
        int index = this.getListgroupfootIndex();
        if (index < 0) {
            return null;
        }
        Listbox lb = (Listbox)this.getParent();
        return (Listfoot)lb.getChildren().get(index);
    }

    public org.zkoss.zul.api.Listfoot getListfootApi() {
        return this.getListfoot();
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z.open", this._open);
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                listbox.addVisibleItemCount(this.isOpen() ? this.getVisibleItemCount() : -this.getVisibleItemCount());
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-list-group" : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.open", (boolean)this.isOpen());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.nostripe", (boolean)true);
        if (this.getListbox().inPagingMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onOpen", (boolean)true);
        } else {
            this.appendAsapAttr(sb, "onOpen");
        }
        return sb.toString();
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.invalidate();
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.invalidate();
    }

    public Object clone() {
        Listgroup clone = (Listgroup)super.clone();
        clone.init();
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class IterItems
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private IterItems() {
            this._it = Listgroup.this.getListbox().getItems().listIterator(Listgroup.this.getIndex() + 1);
        }

        public boolean hasNext() {
            return this._j < Listgroup.this.getItemCount();
        }

        public Object next() {
            ++this._j;
            return this._it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listgroup.this);
        }

        public void setOpenByClient(boolean open) {
            Listgroup.this._open = open;
            Listbox listbox = Listgroup.this.getListbox();
            if (listbox != null) {
                listbox.addVisibleItemCount(Listgroup.this._open ? Listgroup.this.getVisibleItemCount() : -Listgroup.this.getVisibleItemCount());
            }
        }
    }
}

