/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.impl.XulElement;

public class Listitem
extends XulElement
implements org.zkoss.zul.api.Listitem {
    private static final Log log = Log.lookup((Class)Listitem.class);
    private Object _value;
    private int _index = -1;
    private boolean _selected;
    private boolean _disabled;
    private boolean _checkable = true;
    private boolean _loaded;

    public Listitem() {
    }

    public Listitem(String label) {
        this.setLabel(label);
    }

    public Listitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Listbox getListbox() {
        return (Listbox)this.getParent();
    }

    public org.zkoss.zul.api.Listbox getListboxApi() {
        return this.getListbox();
    }

    private final boolean inSelectMold() {
        Listbox listbox = this.getListbox();
        return listbox != null && listbox.inSelectMold();
    }

    protected String getRealStyle() {
        if (this instanceof Listgroup || this instanceof Listgroupfoot || !this.isVisible()) {
            return super.getRealStyle();
        }
        Listgroup lg = this.getListgroup();
        return super.getRealStyle() + (lg != null && !lg.isOpen() ? "display:none" : "");
    }

    public Listgroup getListgroup() {
        if (this instanceof Listgroup) {
            return (Listgroup)this;
        }
        Listbox lb = this.getListbox();
        if (lb != null) {
            return lb.getListgroupAt(this.getIndex());
        }
        return null;
    }

    public org.zkoss.zul.api.Listgroup getListgroupApi() {
        return this.getListgroup();
    }

    protected String getRealSclass() {
        String added;
        String scls = super.getRealSclass();
        String string = this.isDisabled() ? this.getZclass() + "-disd" : (added = this.isSelected() ? this.getZclass() + "-seld" : "");
        if (this instanceof Listgroup || this instanceof Listgroupfoot || !this.isVisible()) {
            return scls;
        }
        String sclx = (String)this.getListbox().getAttribute("org.zkoss.zul.StripeState");
        return scls + (sclx != null ? " " + sclx : "") + " " + added;
    }

    public String getZclass() {
        return this._zclass == null ? "z-list-item" : this._zclass;
    }

    public boolean isCheckable() {
        return this._checkable;
    }

    public void setCheckable(boolean checkable) {
        if (this._checkable != checkable) {
            this._checkable = checkable;
            this.invalidate();
        }
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        return listbox != null ? listbox.getMaxlength() : 0;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.inSelectMold()) {
                    this.smartUpdate("value", Objects.toString((Object)this._value));
                } else if (listbox.getName() != null) {
                    this.smartUpdate("z.value", Objects.toString((Object)this._value));
                }
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            if (this.inSelectMold()) {
                this.smartUpdate("disabled", this._disabled);
            } else {
                this.invalidate();
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null) {
                listbox.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    public String getLabel() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Listcell autoFirstCell() {
        Listcell cell = (Listcell)this.getFirstChild();
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
        }
        return cell;
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public String getImage() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getImage() : null;
    }

    public void setImage(String image) {
        this.autoFirstCell().setImage(image);
    }

    public final int getIndex() {
        return this._index;
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Listbox listbox = this.getListbox();
            if (listbox != null && listbox.getModel() != null) {
                if (this._loaded && !listbox.inPagingMold()) {
                    this.invalidate();
                } else {
                    this.smartUpdate("z.loaded", this._loaded);
                }
            }
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    final void setIndexDirectly(int index) {
        this.setIndex(index);
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    final void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            Listgroup g;
            this.smartUpdate("z.visible", visible);
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null && ((g = listbox.getListgroupAt(this.getIndex())) == null || g.isOpen())) {
                listbox.addVisibleItemCount(visible ? 1 : -1);
            }
        }
        return super.setVisible(visible);
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Listbox)) {
            throw new UiException("Listitem's parent must be Listbox, not " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Listcell)) {
            throw new UiException("Unsupported child for listitem: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void invalidate() {
        if (this.inSelectMold()) {
            this.getParent().invalidate();
            return;
        }
        super.invalidate();
    }

    public void onChildAdded(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildAdded(child);
    }

    public void onChildRemoved(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this.inSelectMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)Objects.toString((Object)this._value));
            if (this.isDisabled()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"selected", (String)"selected");
            }
        } else {
            String clkattrs;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.getName() != null) {
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z.value", (String)Objects.toString((Object)this._value));
                }
                if (listbox.getModel() != null) {
                    Component c;
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z.loaded", (boolean)this._loaded);
                    if (this._loaded && !listbox.inPagingMold() && (c = this.getNextSibling()) instanceof Listitem && !((Listitem)c)._loaded) {
                        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.skipsib", (String)"true");
                    }
                }
            }
            if (this.isDisabled()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)true);
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sel", (boolean)true);
            }
            if ((clkattrs = this.getAllOnClickAttrs()) != null) {
                sb.append(clkattrs);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)this.getListbox().getUuid());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.visible", (boolean)this.isVisible());
        }
        return sb.toString();
    }

    public Object clone() {
        Listitem clone = (Listitem)super.clone();
        clone._index = -1;
        return clone;
    }
}

