/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Menu;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menuseparator;
import org.zkoss.zul.impl.XulElement;

public class Menubar
extends XulElement
implements org.zkoss.zul.api.Menubar {
    private boolean _autodrop;
    private String _orient = "horizontal";

    public Menubar() {
    }

    public Menubar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public final boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("z.autodrop", autodrop);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menubar" + ("vertical".equals(this.getOrient()) ? "-ver" : "-hor") : this._zclass;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        return this._autodrop ? attrs + " z.autodrop=\"true\"" : attrs;
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Menu || child instanceof Menuitem || child instanceof Menuseparator)) {
            throw new UiException("Unsupported child for menubar: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        if ("vertical".equals(this.getOrient())) {
            String height;
            StringBuffer sb = new StringBuffer(32).append("<tr id=\"").append(child.getUuid()).append("!chdextr\"");
            if (child instanceof HtmlBasedComponent && (height = ((HtmlBasedComponent)child).getHeight()) != null) {
                sb.append(" height=\"").append(height).append('\"');
            }
            sb.append('>');
            if (JVMs.isJava5()) {
                out.insert(0, sb);
            } else {
                out.insert(0, sb.toString());
            }
            out.append("</tr>");
        }
    }
}

