/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Checkable;
import org.zkoss.zul.Menubar;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.impl.LabelImageElement;

public class Menuitem
extends LabelImageElement
implements org.zkoss.zul.api.Menuitem {
    private String _value = "";
    private String _href;
    private String _target;
    private boolean _autocheck;
    private boolean _checked;
    private boolean _disabled = false;
    private boolean _checkmark;

    public Menuitem() {
    }

    public Menuitem(String label) {
        this();
        this.setLabel(label);
    }

    public Menuitem(String label, String src) {
        this();
        this.setLabel(label);
        this.setImage(src);
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.invalidate();
        }
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        String added = this.isDisabled() ? this.getZclass() + "-disd" : "";
        return scls != null && scls.length() > 0 ? scls + " " + added : added;
    }

    public String getZclass() {
        return this._zclass == null ? "z-menu-item" : this._zclass;
    }

    public String getImgTag() {
        return this.getImgTag(this.getZclass() + "-img", true);
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this._value = value;
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            if (this._checked) {
                this.setCheckmark(true);
            }
            this.invalidate();
        }
    }

    public boolean isAutocheck() {
        return this._autocheck;
    }

    public void setAutocheck(boolean autocheck) {
        if (this._autocheck != autocheck) {
            this._autocheck = autocheck;
            this.invalidate();
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.invalidate();
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public boolean isTopmost() {
        return !(this.getParent() instanceof Menupopup);
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        boolean topmost = this.isTopmost();
        if (!(topmost || this._autocheck || this._disabled)) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        if (topmost) {
            sb.append(" z.top=\"true\"");
        }
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)true);
        }
        if (!topmost && this._autocheck) {
            sb.append(" z.autock=\"true\"");
            if (this._checked) {
                sb.append(" z.checked=\"true\"");
            }
        }
        return sb.toString();
    }

    protected String getRealStyle() {
        String style = super.getRealStyle();
        return this.isTopmost() ? style + "padding-left:4px;padding-right:4px;" : style;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Menupopup) && !(parent instanceof Menubar)) {
            throw new UiException("Unsupported parent for menuitem: " + parent);
        }
        super.setParent(parent);
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends LabelImageElement.ExtraCtrl
    implements Checkable {
        protected ExtraCtrl() {
            super(Menuitem.this);
        }

        public void setCheckedByClient(boolean checked) {
            Menuitem.this.setChecked(checked);
        }
    }
}

