/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.HashMap;
import org.zkoss.mesg.Messages;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.impl.MessageboxDlg;

public class Messagebox {
    private static String _templ = "~./zul/html/messagebox.zul";
    public static final String QUESTION = "z-msgbox z-msgbox-question";
    public static final String EXCLAMATION = "z-msgbox z-msgbox-exclamation";
    public static final String INFORMATION = "z-msgbox z-msgbox-imformation";
    public static final String ERROR = "z-msgbox z-msgbox-error";
    public static final String NONE = null;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;

    public static final int show(String message, String title, int buttons, String icon) throws InterruptedException {
        return Messagebox.show(message, title, buttons, icon, 0, null);
    }

    public static final int show(String message, String title, int buttons, String icon, EventListener listener) throws InterruptedException {
        return Messagebox.show(message, title, buttons, icon, 0, listener);
    }

    public static final int show(String message, String title, int buttons, String icon, int focus) throws InterruptedException {
        return Messagebox.show(message, title, buttons, icon, focus, null);
    }

    public static final int show(String message, String title, int buttons, String icon, int focus, EventListener listener) throws InterruptedException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", message);
        params.put("title", title != null ? title : Executions.getCurrent().getDesktop().getWebApp().getAppName());
        params.put("icon", icon);
        params.put("buttons", new Integer((buttons & 0x733) != 0 ? buttons : 1));
        if ((buttons & 1) != 0) {
            params.put("OK", new Integer(1));
        }
        if ((buttons & 2) != 0) {
            params.put("CANCEL", new Integer(2));
        }
        if ((buttons & 0x10) != 0) {
            params.put("YES", new Integer(16));
        }
        if ((buttons & 0x20) != 0) {
            params.put("NO", new Integer(32));
        }
        if ((buttons & 0x200) != 0) {
            params.put("RETRY", new Integer(512));
        }
        if ((buttons & 0x100) != 0) {
            params.put("ABORT", new Integer(256));
        }
        if ((buttons & 0x400) != 0) {
            params.put("IGNORE", new Integer(1024));
        }
        MessageboxDlg dlg = (MessageboxDlg)Executions.createComponents((String)_templ, null, params);
        dlg.setButtons(buttons);
        dlg.setEventListener(listener);
        if (focus > 0) {
            dlg.setFocus(focus);
        }
        if (dlg.getDesktop().getWebApp().getConfiguration().isEventThreadEnabled()) {
            try {
                dlg.doModal();
            }
            catch (Throwable ex) {
                dlg.detach();
                if (ex instanceof InterruptedException) {
                    throw (InterruptedException)ex;
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            return dlg.getResult();
        }
        dlg.doHighlighted();
        return 1;
    }

    public static final int show(String message) throws InterruptedException {
        return Messagebox.show(message, null, 1, INFORMATION, 0, null);
    }

    public static final int show(int messageCode, Object[] args, int titleCode, int buttons, String icon) throws InterruptedException {
        return Messagebox.show(messageCode, args, titleCode, buttons, icon, 0, null);
    }

    public static final int show(int messageCode, Object[] args, int titleCode, int buttons, String icon, int focus) throws InterruptedException {
        return Messagebox.show(messageCode, args, titleCode, buttons, icon, focus, null);
    }

    public static final int show(int messageCode, Object[] args, int titleCode, int buttons, String icon, int focus, EventListener listener) throws InterruptedException {
        return Messagebox.show(Messages.get((int)messageCode, (Object[])args), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static final int show(int messageCode, Object arg, int titleCode, int buttons, String icon) throws InterruptedException {
        return Messagebox.show(messageCode, arg, titleCode, buttons, icon, 0, null);
    }

    public static final int show(int messageCode, Object arg, int titleCode, int buttons, String icon, int focus) throws InterruptedException {
        return Messagebox.show(messageCode, arg, titleCode, buttons, icon, focus, null);
    }

    public static final int show(int messageCode, Object arg, int titleCode, int buttons, String icon, int focus, EventListener listener) throws InterruptedException {
        return Messagebox.show(Messages.get((int)messageCode, (Object)arg), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static final int show(int messageCode, int titleCode, int buttons, String icon) throws InterruptedException {
        return Messagebox.show(messageCode, titleCode, buttons, icon, 0);
    }

    public static final int show(int messageCode, int titleCode, int buttons, String icon, int focus) throws InterruptedException {
        return Messagebox.show(messageCode, titleCode, buttons, icon, focus, null);
    }

    public static final int show(int messageCode, int titleCode, int buttons, String icon, int focus, EventListener listener) throws InterruptedException {
        return Messagebox.show(Messages.get((int)messageCode), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static void setTemplate(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        _templ = uri;
    }

    public static String getTemplate() {
        return _templ;
    }
}

