/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.mesg.Messages;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Paginated;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public class Paging
extends XulElement
implements org.zkoss.zul.api.Paging,
Paginal {
    private int _pgsz = 20;
    private int _ttsz = 0;
    private int _npg = 1;
    private int _actpg = 0;
    private int _pginc = 10;
    private boolean _autohide;
    private boolean _detailed;

    public Paging() {
    }

    public Paging(int totalsz, int pagesz) {
        this();
        this.setTotalSize(totalsz);
        this.setPageSize(pagesz);
    }

    public void smartUpdate(String attr, String value) {
        super.smartUpdate(attr, value);
        this.invalidateWholeIfAny();
    }

    public void smartUpdate(String attr, int value) {
        super.smartUpdate(attr, Integer.toString(value));
        this.invalidateWholeIfAny();
    }

    public void smartUpdate(String attr, boolean value) {
        super.smartUpdate(attr, Boolean.toString(value));
        this.invalidateWholeIfAny();
    }

    public void invalidate() {
        if (this.isBothPaging()) {
            this.getParent().invalidate();
        } else {
            super.invalidate();
        }
    }

    protected void invalidateWholeIfAny() {
        if (this.isBothPaging()) {
            this.getParent().invalidate();
        }
    }

    private boolean isBothPaging() {
        Component parent = this.getParent();
        if (parent instanceof Paginated) {
            return "both".equals(((Paginated)parent).getPagingPosition());
        }
        return false;
    }

    public int getPageSize() {
        return this._pgsz;
    }

    public void setPageSize(int size) throws WrongValueException {
        if (size <= 0) {
            throw new WrongValueException("positive only");
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            this.updatePageNum();
            Events.postEvent((Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    public int getTotalSize() {
        return this._ttsz;
    }

    public void setTotalSize(int size) throws WrongValueException {
        if (size < 0) {
            throw new WrongValueException("non-negative only");
        }
        if (this._ttsz != size) {
            this._ttsz = size;
            this.updatePageNum();
            if (this._detailed) {
                this.invalidate();
            }
        }
    }

    private void updatePageNum() {
        int v = (this._ttsz - 1) / this._pgsz + 1;
        if (v == 0) {
            v = 1;
        }
        if (v != this._npg) {
            this._npg = v;
            if (this._actpg >= this._npg) {
                this._actpg = this._npg - 1;
            }
            this.invalidate();
        }
    }

    public int getPageCount() {
        return this._npg;
    }

    public int getActivePage() {
        return this._actpg;
    }

    public void setActivePage(int pg) throws WrongValueException {
        if (pg >= this._npg || pg < 0) {
            throw new WrongValueException("Unable to set active page to " + pg + " since only " + this._npg + " pages");
        }
        if (this._actpg != pg) {
            this._actpg = pg;
            this.invalidate();
            Events.postEvent((Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    public int getPageIncrement() {
        return this._pginc;
    }

    public void setPageIncrement(int pginc) throws WrongValueException {
        if (pginc <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + pginc);
        }
        if (this._pginc != pginc) {
            this._pginc = pginc;
            this.invalidate();
        }
    }

    public boolean isDetailed() {
        return this._detailed;
    }

    public void setDetailed(boolean detailed) {
        if (this._detailed != detailed) {
            this._detailed = detailed;
            this.invalidate();
        }
    }

    public boolean isAutohide() {
        return this._autohide;
    }

    public void setAutohide(boolean autohide) {
        if (this._autohide != autohide) {
            this._autohide = autohide;
            if (this._npg == 1) {
                this.invalidate();
            }
        }
    }

    public String getInfoTags() {
        if (this._ttsz == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(512);
        int lastItem = (this._actpg + 1) * this._pgsz;
        sb.append("<div class=\"").append(this.getZclass()).append("-info\">[ ").append(this._actpg * this._pgsz + 1).append(" - ").append(lastItem > this._ttsz ? this._ttsz : lastItem).append(" / ").append(this._ttsz).append(" ]</div>");
        return sb.toString();
    }

    public String getInnerTags() {
        boolean bNext;
        int begin;
        StringBuffer sb = new StringBuffer(512);
        int half = this._pginc / 2;
        int end = this._actpg + half - 1;
        if (end >= this._npg) {
            end = this._npg - 1;
            begin = end - this._pginc + 1;
            if (begin < 0) {
                begin = 0;
            }
        } else {
            begin = this._actpg - half;
            if (begin < 0) {
                begin = 0;
            }
            if ((end = begin + this._pginc - 1) >= this._npg) {
                end = this._npg - 1;
            }
        }
        String zcs = this.getZclass();
        if (this._actpg > 0) {
            if (begin > 0) {
                Paging.appendAnchor(zcs, sb, Messages.get((int)MZul.FIRST), 0);
            }
            Paging.appendAnchor(zcs, sb, Messages.get((int)MZul.PREV), this._actpg - 1);
        }
        boolean bl = bNext = this._actpg < this._npg - 1;
        while (begin <= end) {
            if (begin == this._actpg) {
                Paging.appendAnchor(zcs, sb, Integer.toString(begin + 1), begin, true);
            } else {
                Paging.appendAnchor(zcs, sb, Integer.toString(begin + 1), begin);
            }
            ++begin;
        }
        if (bNext) {
            Paging.appendAnchor(zcs, sb, Messages.get((int)MZul.NEXT), this._actpg + 1);
            if (end < this._npg - 1) {
                Paging.appendAnchor(zcs, sb, Messages.get((int)MZul.LAST), this._npg - 1);
            }
        }
        if (this._detailed) {
            sb.append("<span>[").append(this._actpg * this._pgsz + 1).append('/').append(this._ttsz).append("]</span>");
        }
        return sb.toString();
    }

    private static final void appendAnchor(String zclass, StringBuffer sb, String label, int val) {
        Paging.appendAnchor(zclass, sb, label, val, false);
    }

    private static final void appendAnchor(String zclass, StringBuffer sb, String label, int val, boolean seld) {
        zclass = zclass + "-cnt" + (seld ? " " + zclass + "-seld" : "");
        sb.append("<a class=\"").append(zclass).append("\" href=\"javascript:;\" onclick=\"zkPgOS.go(this,").append(val).append(")\">").append(label).append("</a>&nbsp;");
    }

    public String getZclass() {
        String added = "os".equals(this.getMold()) ? "-os" : "";
        return this._zclass == null ? "z-paging" + added : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.actpg", (int)this._actpg);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.numpg", (int)this._npg);
        return sb.toString();
    }

    public boolean isVisible() {
        return super.isVisible() && (this._npg > 1 || !this._autohide);
    }

    public boolean isChildable() {
        return false;
    }
}

