/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Maximizable;
import org.zkoss.zk.ui.ext.client.Minimizable;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.ext.client.Updatable;
import org.zkoss.zk.ui.ext.render.Floating;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zul.api.Caption;
import org.zkoss.zul.api.Panelchildren;
import org.zkoss.zul.api.Toolbar;
import org.zkoss.zul.impl.XulElement;

public class Panel
extends XulElement
implements org.zkoss.zul.api.Panel {
    private boolean _noSmartUpdate;
    private transient Component _noSmartParent;
    private transient org.zkoss.zul.Toolbar _tbar;
    private transient org.zkoss.zul.Toolbar _bbar;
    private transient org.zkoss.zul.Toolbar _fbar;
    private transient org.zkoss.zul.Panelchildren _panelchildren;
    private transient org.zkoss.zul.Caption _caption;
    private String _border = "none";
    private String _title = "";
    private boolean _closable;
    private boolean _collapsible;
    private boolean _floatable;
    private boolean _framable;
    private boolean _movable;
    private boolean _maximizable;
    private boolean _minimizable;
    private boolean _maximized;
    private boolean _minimized;
    private boolean _open = true;

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z.open", this._open);
        }
    }

    public boolean isFramable() {
        return this._framable;
    }

    public void setFramable(boolean framable) {
        if (this._framable != framable) {
            this._framable = framable;
            this.invalidate();
        }
    }

    public void setMovable(boolean movable) {
        if (this._movable != movable) {
            this._movable = movable;
            this.invalidate();
        }
    }

    public boolean isMovable() {
        return this._movable;
    }

    public boolean isFloatable() {
        return this._floatable;
    }

    public boolean setVisible(boolean visible) {
        if (visible == this._visible) {
            return visible;
        }
        this._minimized = false;
        this._maximized = false;
        return this.setVisible0(visible);
    }

    private boolean setVisible0(boolean visible) {
        return super.setVisible(visible);
    }

    public void setFloatable(boolean floatable) {
        if (this._floatable != floatable) {
            this._floatable = floatable;
            this.invalidate();
        }
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean maximized) {
        if (this._maximized != maximized) {
            if (!this._maximizable) {
                throw new UiException("Not maximizable, " + this);
            }
            this._maximized = maximized;
            if (this._maximized) {
                this._minimized = false;
                this.setVisible0(true);
            }
            this.smartUpdate("z.maximized", this._maximized);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (this._maximizable != maximizable) {
            this._maximizable = maximizable;
            this.invalidate();
        }
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this._minimized != minimized) {
            if (!this._minimizable) {
                throw new UiException("not minimizable, " + this);
            }
            this._minimized = minimized;
            if (this._minimized) {
                this._maximized = false;
                this.setVisible0(false);
            } else {
                this.setVisible0(true);
            }
            this.smartUpdate("z.minimized", this._minimized);
        }
    }

    public boolean isMinimizable() {
        return this._minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this._minimizable != minimizable) {
            this._minimizable = minimizable;
            this.invalidate();
        }
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (this._collapsible != collapsible) {
            this._collapsible = collapsible;
            this.invalidate();
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.invalidate();
        }
    }

    public org.zkoss.zul.Caption getCaption() {
        return this._caption;
    }

    public Caption getCaptionApi() {
        return this.getCaption();
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.invalidate();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            if (this._caption != null) {
                this._caption.invalidate();
            } else {
                this.invalidate();
            }
        }
    }

    public boolean addToolbar(String name, org.zkoss.zul.Toolbar toolbar) {
        if ("tbar".equals(name)) {
            if (this._tbar != null) {
                throw new UiException("Only one top toolbar child is allowed: " + this);
            }
            this._tbar = toolbar;
        } else if ("bbar".equals(name)) {
            if (this._bbar != null) {
                throw new UiException("Only one bottom toolbar child is allowed: " + this);
            }
            this._bbar = toolbar;
        } else if ("fbar".equals(name)) {
            if (this._fbar != null) {
                throw new UiException("Only one foot toolbar child is allowed: " + this);
            }
            this._fbar = toolbar;
        } else {
            throw new UiException("Uknown toolbar: " + name);
        }
        if (super.insertBefore((Component)toolbar, null)) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean addToolbarApi(String name, Toolbar toolbarApi) {
        org.zkoss.zul.Toolbar toolbar = (org.zkoss.zul.Toolbar)toolbarApi;
        return this.addToolbar(name, toolbar);
    }

    public void onClose() {
        this.detach();
    }

    public org.zkoss.zul.Toolbar getTopToolbar() {
        return this._tbar;
    }

    public Toolbar getTopToolbarApi() {
        return this.getTopToolbar();
    }

    public org.zkoss.zul.Toolbar getBottomToolbar() {
        return this._bbar;
    }

    public Toolbar getBottomToolbarApi() {
        return this.getBottomToolbar();
    }

    public org.zkoss.zul.Toolbar getFootToolbar() {
        return this._fbar;
    }

    public Toolbar getFootToolbarApi() {
        return this.getFootToolbar();
    }

    public org.zkoss.zul.Panelchildren getPanelchildren() {
        return this._panelchildren;
    }

    public Panelchildren getPanelchildrenApi() {
        return this.getPanelchildren();
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        String zcls = this.getZclass();
        return scls + ("normal".equals(this._border) ? "" : ' ' + zcls + "-noborder") + (this._open ? "" : " " + zcls + "-colpsd");
    }

    public String getZclass() {
        return this._zclass == null ? "z-panel" : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onMove");
        this.appendAsapAttr(sb, "onZIndex");
        this.appendAsapAttr(sb, "onOpen");
        this.appendAsapAttr(sb, "onMaximize");
        this.appendAsapAttr(sb, "onMinimize");
        String clkattrs = this.getAllOnClickAttrs();
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (this._panelchildren != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.children", (String)this._panelchildren.getUuid());
        }
        if (this._closable) {
            sb.append(" z.closable=\"true\"");
        }
        if (this._floatable) {
            sb.append(" z.floatable=\"true\"");
        }
        if (this._collapsible) {
            sb.append(" z.collapsible=\"true\"");
        }
        if (this._framable) {
            sb.append(" z.framable=\"true\"");
        }
        if (this._movable) {
            sb.append(" z.movable=\"true\"");
        }
        if (this._maximizable) {
            sb.append(" z.maximizable=\"true\"");
        }
        if (this._minimizable) {
            sb.append(" z.minimizable=\"true\"");
        }
        if (this._maximized) {
            sb.append(" z.maximized=\"true\"");
        }
        if (this._minimized) {
            sb.append(" z.minimized=\"true\"");
        }
        if (this._open) {
            sb.append(" z.open=\"true\"");
        }
        if (this.isVisible()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.visible", (boolean)this.isVisible());
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Caption) {
            if (this._caption != null && this._caption != newChild) {
                throw new UiException("Only one caption is allowed: " + this);
            }
            refChild = this.getFirstChild();
            this._caption = (org.zkoss.zul.Caption)newChild;
        } else {
            if (refChild instanceof org.zkoss.zul.Caption) {
                throw new UiException("caption must be the first child");
            }
            if (newChild instanceof org.zkoss.zul.Panelchildren) {
                if (this._panelchildren != null && this._panelchildren != newChild) {
                    throw new UiException("Only one panelchildren child is allowed: " + this);
                }
                this._panelchildren = (org.zkoss.zul.Panelchildren)newChild;
            } else {
                if (!(newChild instanceof org.zkoss.zul.Toolbar)) throw new UiException("Unsupported child for Panel: " + newChild);
                if (refChild instanceof org.zkoss.zul.Panelchildren || refChild == null && this.getChildren().isEmpty()) {
                    if (this._tbar != null && this._tbar != newChild) {
                        throw new UiException("Only one top toolbar child is allowed: " + this);
                    }
                    this._tbar = (org.zkoss.zul.Toolbar)newChild;
                } else {
                    if (refChild != null && refChild != this._fbar) throw new UiException("Only three toolbars child is allowed: " + this);
                    if (this._bbar != null && this._bbar != newChild) {
                        if (refChild != null && refChild == this._fbar) {
                            throw new UiException("Only one bottom toolbar child is allowed: " + this);
                        }
                        if (this._fbar != null && this._fbar != newChild) {
                            throw new UiException("Only one foot toolbar child is allowed: " + this);
                        }
                        this._fbar = (org.zkoss.zul.Toolbar)newChild;
                    } else {
                        this._bbar = (org.zkoss.zul.Toolbar)newChild;
                    }
                }
            }
        }
        if (!super.insertBefore(newChild, refChild)) return false;
        this.invalidate();
        return true;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._caption == child) {
            this._caption = null;
        } else if (this._tbar == child) {
            this._tbar = null;
        } else if (this._bbar == child) {
            this._bbar = null;
        } else if (this._panelchildren == child) {
            this._panelchildren = null;
        } else if (this._fbar == child) {
            this._fbar = null;
        }
        this.invalidate();
    }

    public Object clone() {
        Panel clone = (Panel)super.clone();
        clone.afterUnmarshal();
        return clone;
    }

    private void afterUnmarshal() {
        if (this._caption != null) {
            this._caption = (org.zkoss.zul.Caption)this.getChildren().get(this._caption.getParent().getChildren().indexOf(this._caption));
        }
        if (this._tbar != null) {
            this._tbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._tbar.getParent().getChildren().indexOf(this._tbar));
        }
        if (this._panelchildren != null) {
            this._panelchildren = (org.zkoss.zul.Panelchildren)this.getChildren().get(this._panelchildren.getParent().getChildren().indexOf(this._panelchildren));
        }
        if (this._bbar != null) {
            this._bbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._bbar.getParent().getChildren().indexOf(this._bbar));
        }
        if (this._fbar != null) {
            this._fbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._fbar.getParent().getChildren().indexOf(this._fbar));
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected void addMoved(Component oldparent, Page oldpg, Page newpg) {
        if (!this._noSmartUpdate || this._noSmartParent != this.getParent()) {
            super.addMoved(oldparent, oldpg, newpg);
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements MultiBranch,
    Openable,
    Floating,
    Maximizable,
    Minimizable,
    Updatable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Panel.this);
        }

        public boolean inDifferentBranch(Component child) {
            return child instanceof org.zkoss.zul.Caption;
        }

        public void setOpenByClient(boolean open) {
            Panel.this._open = open;
        }

        public boolean isFloating() {
            return Panel.this._floatable;
        }

        public void setMaximizedByClient(boolean maximized) {
            Panel.this._maximized = maximized;
            if (Panel.this._maximized) {
                Panel.this._visible = true;
            }
        }

        public void setMinimizedByClient(boolean minimized) {
            Panel.this._minimized = minimized;
            if (Panel.this._minimized) {
                Panel.this._visible = false;
            }
        }

        public void setResult(Object result) {
            Object[] r = (Object[])result;
            Panel.this._noSmartUpdate = (Boolean)r[0];
            Panel.this._noSmartParent = (Component)r[1];
        }
    }
}

