/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zul.Box;
import org.zkoss.zul.impl.XulElement;

public class Splitter
extends XulElement
implements org.zkoss.zul.api.Splitter {
    private String _collapse = "none";
    private boolean _open = true;

    public String getOrient() {
        Box box = (Box)this.getParent();
        return box != null ? box.getOrient() : "vertical";
    }

    public String getCollapse() {
        return this._collapse;
    }

    public void setCollapse(String collapse) throws WrongValueException {
        if (collapse == null || collapse.length() == 0) {
            collapse = "none";
        } else if (!("none".equals(collapse) || "before".equals(collapse) || "after".equals(collapse))) {
            throw new WrongValueException("Unknown collpase: " + collapse);
        }
        if (!Objects.equals((Object)this._collapse, (Object)collapse)) {
            this._collapse = collapse;
            this.smartUpdate("z.colps", collapse);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z.open", open);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-splitter" + ("vertical".equals(this.getOrient()) ? "-ver" : "-hor") : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onOpen");
        if ("vertical".equals(this.getOrient())) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vert", (String)"true");
        }
        if (!"none".equals(this._collapse)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.colps", (String)this._collapse);
        }
        if (!this._open) {
            sb.append(" z.open=\"false\"");
        }
        return sb.toString();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Box)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Splitter.this);
        }

        public void setOpenByClient(boolean open) {
            Splitter.this._open = open;
        }
    }
}

