/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.Set;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.api.Tabbox;
import org.zkoss.zul.api.Tabpanel;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends LabelImageElement
implements org.zkoss.zul.api.Tab {
    private boolean _selected;
    private boolean _closable;
    private boolean _disabled;

    public Tab() {
    }

    public Tab(String label) {
        this();
        this.setLabel(label);
    }

    public Tab(String label, String image) {
        this();
        this.setLabel(label);
        this.setImage(image);
    }

    public void setWidth(String width) {
        if (this.getTabbox().isVertical()) {
            throw new UnsupportedOperationException("Set Tabs' width instead");
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.invalidate();
        }
    }

    public void onClose() {
        org.zkoss.zul.Tabpanel panel;
        Tabs tabs;
        if (this._selected && (tabs = (Tabs)this.getParent()) != null) {
            Tab t = null;
            Tab tab = this.getPreviousSibling() != null ? (Tab)this.getPreviousSibling() : (t = this.getNextSibling() != null ? (Tab)this.getNextSibling() : null);
            if (t != null) {
                t.setSelected(true);
            }
        }
        if ((panel = this.getLinkedPanel()) != null) {
            panel.detach();
        }
        this.detach();
    }

    public org.zkoss.zul.Tabbox getTabbox() {
        Tabs tabs = (Tabs)this.getParent();
        return tabs != null ? tabs.getTabbox() : null;
    }

    public Tabbox getTabboxApi() {
        return this.getTabbox();
    }

    public org.zkoss.zul.Tabpanel getLinkedPanel() {
        Tabpanels tabpanels;
        org.zkoss.zul.Tabbox tabbox;
        int j = this.getIndex();
        if (j >= 0 && (tabbox = this.getTabbox()) != null && (tabpanels = tabbox.getTabpanels()) != null && tabpanels.getChildren().size() > j) {
            return (org.zkoss.zul.Tabpanel)tabpanels.getChildren().get(j);
        }
        return null;
    }

    public Tabpanel getLinkedPanelApi() {
        return this.getLinkedPanel();
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            org.zkoss.zul.Tabbox tabbox = this.getTabbox();
            if (tabbox != null) {
                tabbox.setSelectedTab(this);
            } else {
                this._selected = selected;
                this.invalidate();
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("z.disabled", this._disabled);
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getIndex() {
        Tabs tabs = (Tabs)this.getParent();
        if (tabs == null) {
            return -1;
        }
        int j = 0;
        Iterator it = tabs.getChildren().iterator();
        while (it.next() != this) {
            ++j;
        }
        return j;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onSelect");
        String clkattrs = this.getAllOnClickAttrs();
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sel", (boolean)this.isSelected());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.box", (String)this.getTabbox().getUuid());
        org.zkoss.zul.Tabpanel panel = this.getLinkedPanel();
        if (panel != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.panel", (String)panel.getUuid());
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disabled", (boolean)this.isDisabled());
        return sb.toString();
    }

    public String getZclass() {
        if (this._zclass != null) {
            return this._zclass;
        }
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        String added = tabbox != null ? (tabbox.inAccordionMold() ? "-" + tabbox.getMold() : (tabbox.isVertical() ? "-ver" : "")) : "";
        return "z-tab" + added;
    }

    protected String getRealSclass() {
        String cls = super.getRealSclass();
        String added = this.getZclass();
        if (this.isDisabled()) {
            added = added + "-disd";
        }
        if (this.isSelected()) {
            added = added + "-seld";
        }
        return cls != null ? cls + " " + added : added;
    }

    public void invalidate() {
        org.zkoss.zul.Tabbox tabbox = this.getTabbox();
        if (tabbox != null && tabbox.inAccordionMold()) {
            tabbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    public boolean isChildable() {
        return false;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Tabs)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends LabelImageElement.ExtraCtrl
    implements Selectable {
        protected ExtraCtrl() {
            super(Tab.this);
        }

        public void selectItemsByClient(Set selItems) {
            if (selItems == null || selItems.size() != 1) {
                throw new UiException("Exactly one selected tab is required: " + selItems);
            }
            org.zkoss.zul.Tabbox tabbox = Tab.this.getTabbox();
            if (tabbox != null) {
                tabbox.selectTabDirectly((Tab)selItems.iterator().next(), true);
            }
        }

        public void clearSelectionByClient() {
        }
    }
}

