/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.XulElement;

public class Toolbar
extends XulElement
implements org.zkoss.zul.api.Toolbar {
    private String _orient = "horizontal";
    private String _align = "start";

    public Toolbar() {
    }

    public Toolbar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align == null) {
            align = "start";
        }
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException("align cannot be " + align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.invalidate();
        }
    }

    final boolean inPanelMold() {
        return "panel".equals(this.getMold());
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (super.insertBefore(newChild, refChild)) {
            if (this.inPanelMold()) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    public String getZclass() {
        return this._zclass == null ? "z-toolbar" + (this.inPanelMold() ? "-panel" : "") : this._zclass;
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs();
        return clkattrs == null ? attrs : attrs + clkattrs;
    }
}

