/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.api.Treecol;
import org.zkoss.zul.impl.LabelImageElement;

public class Treecell
extends LabelImageElement
implements org.zkoss.zul.api.Treecell {
    private static final String ROOT_OPEN = "root-open";
    private static final String ROOT_CLOSE = "root-close";
    private static final String LAST_OPEN = "last-open";
    private static final String LAST_CLOSE = "last-close";
    private static final String TEE_OPEN = "tee-open";
    private static final String TEE_CLOSE = "tee-close";
    private static final String TEE = "tee";
    private static final String LAST = "last";
    private static final String VBAR = "vbar";
    private static final String SPACER = "spacer";
    private static final String FIRSTSPACER = "firstspacer";
    private int _span = 1;

    public Treecell() {
    }

    public Treecell(String label) {
        this.setLabel(label);
    }

    public Treecell(String label, String src) {
        this.setLabel(label);
        this.setImage(src);
    }

    public Tree getTree() {
        Treecell n = this;
        while ((n = n.getParent()) != null) {
            if (!(n instanceof Tree)) continue;
            return (Tree)((Object)n);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    protected String getRealStyle() {
        org.zkoss.zul.Treecol h = this.getTreecol();
        return this.isVisible() && h != null && !h.isVisible() ? super.getRealStyle() + "display:none;" : super.getRealStyle();
    }

    public org.zkoss.zul.Treecol getTreecol() {
        List lcschs;
        int j;
        Treecols lcs;
        Tree tree = this.getTree();
        if (tree != null && (lcs = tree.getTreecols()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (org.zkoss.zul.Treecol)lcschs.get(j);
        }
        return null;
    }

    public Treecol getTreecolApi() {
        return this.getTreecol();
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Tree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        org.zkoss.zul.Treecol lc = this.getTreecol();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treerow)parent).getLevel() : 0;
    }

    public int getSpan() {
        return this._span;
    }

    public void setSpan(int span) {
        if (this._span != span) {
            this._span = span;
            this.smartUpdate("colspan", Integer.toString(this._span));
        }
    }

    public String getColumnHtmlPrefix() {
        if (this.isFirstColumn()) {
            Treeitem item = this.getTreeitem();
            Tree tree = this.getTree();
            StringBuffer sb = new StringBuffer(80);
            if (tree != null && tree.isCheckmark()) {
                boolean isCheckable = item.isCheckable();
                sb.append("<input type=\"").append(tree.isMultiple() ? "checkbox" : "radio").append('\"');
                if (!isCheckable || item.isDisabled()) {
                    sb.append(" disabled=\"disabled\"");
                }
                if (item.isSelected()) {
                    sb.append(" checked=\"checked\"");
                }
                if (!tree.isMultiple()) {
                    sb.append(" name=\"").append(tree.getUuid()).append("\"");
                }
                if (!isCheckable) {
                    sb.append(" style=\"visibility:hidden;\"  z.fc=\"t\"/>");
                } else {
                    sb.append(" id=\"").append(this.getParent().getUuid()).append("!cm\" z.type=\"Tcfc\"/>");
                }
            }
            String iconScls = null;
            if (tree != null) {
                iconScls = tree.getZclass();
            }
            if (iconScls == null) {
                iconScls = "";
            }
            Treeitem[] pitems = this.getTreeitems((Component)item);
            for (int j = 0; j < pitems.length; ++j) {
                this.appendIcon(sb, iconScls, j == 0 || Treecell.isLastChild(pitems[j]) ? SPACER : VBAR, false);
            }
            if (item.isContainer()) {
                this.appendIcon(sb, iconScls, item.isOpen() ? (pitems.length == 0 ? ROOT_OPEN : (Treecell.isLastChild(item) ? LAST_OPEN : TEE_OPEN)) : (pitems.length == 0 ? ROOT_CLOSE : (Treecell.isLastChild(item) ? LAST_CLOSE : TEE_CLOSE)), true);
            } else {
                this.appendIcon(sb, iconScls, pitems.length == 0 ? FIRSTSPACER : (Treecell.isLastChild(item) ? LAST : TEE), false);
            }
            return sb.toString();
        }
        boolean empty = this.getImage() == null && this.getLabel().length() == 0 && this.getChildren().isEmpty();
        return empty ? "&nbsp;" : null;
    }

    public String getColumnHtmlPostfix() {
        return null;
    }

    private boolean isFirstColumn() {
        Component parent = this.getParent();
        return parent != null && parent.getFirstChild() == this;
    }

    public static boolean isLastChild(Treeitem item) {
        Component parent = item.getParent();
        return parent == null || parent.getLastChild() == item;
    }

    private Treeitem[] getTreeitems(Component item) {
        Component tch;
        LinkedList<Component> pitems = new LinkedList<Component>();
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            pitems.add(0, item);
        }
        return pitems.toArray(new Treeitem[pitems.size()]);
    }

    private Treeitem getTreeitem() {
        Component parent = this.getParent();
        return parent != null ? (Treeitem)parent.getParent() : null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-tree-cell" : this._zclass;
    }

    private void appendIcon(StringBuffer sb, String iconScls, String name, boolean button) {
        Treerow tr;
        Treeitem item;
        sb.append("<span z.fc=\"t\" class=\"");
        if (name.equals(TEE) || name.equals(LAST) || name.equals(VBAR) || name.equals(SPACER)) {
            sb.append(iconScls + "-line ").append(iconScls).append('-').append(name).append('\"');
        } else {
            sb.append(iconScls + "-ico ").append(iconScls).append('-').append(name).append('\"');
        }
        if (button && (item = this.getTreeitem()) != null && (tr = item.getTreerow()) != null) {
            sb.append(" z.type=\"Tcop\" id=\"").append(tr.getUuid()).append("!open\"");
        }
        sb.append("></span>");
    }

    public String getWidth() {
        org.zkoss.zul.Treecol col = this.getTreecol();
        return col != null ? col.getWidth() : null;
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Set treecol's width instead");
    }

    public String getLabelAttrs() {
        String style = HTMLs.getTextRelevantStyle((String)this.getRealStyle());
        return style.length() > 0 ? " style=\"" + style + '\"' : "";
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        org.zkoss.zul.Treecol col = this.getTreecol();
        String clkattrs = this.getAllOnClickAttrs();
        if (col == null && clkattrs == null && this._span == 1) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        if (col != null) {
            sb.append(col.getColAttrs());
        }
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (this._span != 1) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"colspan", (int)this._span);
        }
        return sb.toString();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Treerow)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }
}

