/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.api.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Treechildren
extends XulElement
implements org.zkoss.zul.api.Treechildren {
    private static final String VISIBLE_ITEM = "org.zkoss.zul.Treechildren.visibleItem";
    private int _visibleItemCount;

    public Tree getTree() {
        Treechildren p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    public org.zkoss.zul.Treerow getLinkedTreerow() {
        Component parent = this.getParent();
        return parent instanceof Treeitem ? ((Treeitem)parent).getTreerow() : null;
    }

    public Treerow getLinkedTreerowApi() {
        return this.getLinkedTreerow();
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        if (!((Treeitem)comp).isOpen()) {
            return false;
        }
        return !((comp = comp.getParent()) instanceof Treechildren) || ((Treechildren)comp).isVisible();
    }

    public Collection getItems() {
        return new AbstractCollection(){

            public int size() {
                return Treechildren.this.getItemCount();
            }

            public boolean isEmpty() {
                return Treechildren.this.getChildren().isEmpty();
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final Iterator _it;
                    private Iterator _sub;
                    {
                        this._it = Treechildren.this.getChildren().iterator();
                    }

                    public boolean hasNext() {
                        return this._sub != null && this._sub.hasNext() || this._it.hasNext();
                    }

                    public Object next() {
                        if (this._sub != null && this._sub.hasNext()) {
                            return this._sub.next();
                        }
                        Treeitem item = (Treeitem)this._it.next();
                        Treechildren tc = item.getTreechildren();
                        this._sub = tc != null ? tc.getItems().iterator() : null;
                        return item;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("readonly");
                    }
                };
            }
        };
    }

    public int getItemCount() {
        int sz = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)it.next();
            Treechildren tchs = item.getTreechildren();
            if (tchs != null) {
                sz += tchs.getItemCount();
            }
            ++sz;
        }
        return sz;
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (((Treeitem)child).isVisible()) {
            this.addVisibleItemCount(1);
        }
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (((Treeitem)child).isVisible()) {
            this.addVisibleItemCount(-1);
        }
    }

    void addVisibleItemCount(int count) {
        if (count == 0) {
            return;
        }
        Component parent = this.getParent();
        if (parent instanceof Treeitem) {
            if (((Treeitem)parent).isOpen()) {
                ((Treeitem)parent).addVisibleItemCount(count, false);
            }
        } else if (parent instanceof Tree) {
            ((Tree)parent).addVisibleItemCount(count);
        }
        this._visibleItemCount += count;
    }

    public int getPageSize() {
        return -1;
    }

    public void setPageSize(int size) throws WrongValueException {
    }

    public int getPageCount() {
        return 1;
    }

    public int getActivePage() {
        return 0;
    }

    public void setActivePage(int pg) throws WrongValueException {
    }

    public int getVisibleBegin() {
        return 0;
    }

    public int getVisibleEnd() {
        return Integer.MAX_VALUE;
    }

    public void setParent(Component parent) {
        Tree tree;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        if (parent != null && !(parent instanceof Tree) && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (oldtree != null) {
            oldtree.onTreechildrenRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreechildrenAdded(this);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Treeitem)) {
            throw new UiException("Unsupported child for treechildren: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void invalidate() {
        Component parent = this.getParent();
        if (parent instanceof Tree) {
            parent.invalidate();
        } else if (!this.getChildren().isEmpty()) {
            super.invalidate();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-tree-children" : this._zclass;
    }

    public void smartUpdate(String name, String value) {
        Object comp = this.getParent();
        if (comp instanceof Treeitem) {
            comp = ((Treeitem)comp).getTreerow();
        }
        if (comp != null) {
            ((ComponentCtrl)comp).smartUpdate(name, value);
        }
    }

    public Iterator getVisibleChildrenIterator() {
        return new VisibleChildrenIterator();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treechildren.this);
        }

        public boolean isCropper() {
            Tree tree = Treechildren.this.getTree();
            return tree != null && tree.inPagingMold();
        }

        public Set getAvailableAtClient() {
            String attrnm;
            if (!this.isCropper()) {
                return null;
            }
            Tree tree = Treechildren.this.getTree();
            Component parent = Treechildren.this.getParent();
            Execution exe = Executions.getCurrent();
            Map map = (Map)exe.getAttribute(attrnm = Treechildren.VISIBLE_ITEM + tree.getUuid());
            if (map == null) {
                if (parent instanceof Treeitem) {
                    Treeitem ti = (Treeitem)parent;
                    while (true) {
                        if (!ti.isOpen()) {
                            return Collections.EMPTY_SET;
                        }
                        Component gp = ti.getParent().getParent();
                        if (!(gp instanceof Treeitem)) break;
                        ti = (Treeitem)gp;
                    }
                }
                map = tree.getVisibleItems();
                Executions.getCurrent().setAttribute(attrnm, (Object)map);
            }
            if (parent != tree && !map.containsKey(parent)) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet<Treeitem> avail = new LinkedHashSet<Treeitem>(32);
            Iterator it = Treechildren.this.getChildren().iterator();
            while (it.hasNext()) {
                Treeitem item = (Treeitem)it.next();
                if (!map.containsKey(item)) {
                    if (!avail.isEmpty() && item.isVisible()) break;
                    continue;
                }
                avail.add(item);
            }
            return avail;
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final Iterator _it;
        private Tree _tree;

        private VisibleChildrenIterator() {
            this._it = Treechildren.this.getChildren().iterator();
            this._tree = Treechildren.this.getTree();
        }

        public boolean hasNext() {
            if (this._tree == null || !this._tree.inPagingMold()) {
                return this._it.hasNext();
            }
            Integer renderedCount = (Integer)this._tree.getAttribute("org.zkoss.zul.RenderedItemCount");
            if (renderedCount == null || renderedCount < this._tree.getPaginal().getPageSize()) {
                return this._it.hasNext();
            }
            return false;
        }

        public Object next() {
            return this._it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

