/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.zkoss.zul.AbstractChartModel;

public class WaferMapModel
extends AbstractChartModel {
    private int _xsize;
    private int _ysize;
    private double _space;
    private Map _values;

    public WaferMapModel(int xsize, int ysize) {
        this(xsize, ysize, 1.0);
    }

    public WaferMapModel(int xsize, int ysize, double space) {
        this._xsize = xsize;
        this._ysize = ysize;
        this._space = space;
    }

    public int getXsize() {
        return this._xsize;
    }

    public int getYsize() {
        return this._ysize;
    }

    public double getSpace() {
        return this._space;
    }

    public Number getValue(int x, int y) {
        if (this._values != null) {
            return (Number)this._values.get(new IntPair(x, y));
        }
        return null;
    }

    public void addValue(int value, int x, int y) {
        if (x >= this._xsize) {
            throw new IndexOutOfBoundsException("x size: " + this._xsize + ", x: " + x);
        }
        if (y >= this._ysize) {
            throw new IndexOutOfBoundsException("y size: " + this._ysize + ", y: " + y);
        }
        if (this._values == null) {
            this._values = new HashMap(256);
        }
        this._values.put(new IntPair(x, y), new Integer(value));
        this.fireEvent(0, null, null);
    }

    public Collection getEntrySet() {
        return this._values == null ? new HashSet(0) : this._values.entrySet();
    }

    public void removeValue(int x, int y) {
        Object old;
        if (this._values != null && (old = this._values.remove(new IntPair(x, y))) != null) {
            this.fireEvent(2, null, null);
        }
    }

    public void clear() {
        if (this._values != null && !this._values.isEmpty()) {
            this._values.clear();
            this.fireEvent(2, null, null);
        }
    }

    public static class IntPair {
        private int _x;
        private int _y;

        private IntPair(int x, int y) {
            this._x = x;
            this._y = y;
        }

        public int getX() {
            return this._x;
        }

        public int getY() {
            return this._y;
        }

        public int hashCode() {
            return this._x ^ this._y;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntPair)) {
                return false;
            }
            IntPair o = (IntPair)other;
            return o._x == this._x && o._y == this._y;
        }
    }
}

