/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.lang.Objects;
import org.zkoss.util.Dates;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.InputableX;
import org.zkoss.zul.impl.XulElement;

public class Calendar
extends XulElement
implements org.zkoss.zul.api.Calendar {
    private TimeZone _tzone;
    private Date _value;
    private String _name;
    private boolean _compact;

    public Calendar() {
        this(null);
    }

    public Calendar(Date value) {
        this._value = value != null ? value : Dates.today();
        this._compact = "zh".equals(Locales.getCurrent().getLanguage());
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
    }

    public Date getValue() {
        return this._value;
    }

    public void setValue(Date value) {
        if (value == null) {
            value = Dates.today();
        }
        if (!value.equals(this._value)) {
            this._value = value;
            this.smartUpdate("z.value", this.getDateFormat().format(this._value));
        }
    }

    private final DateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd", Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setCompact(boolean compact) {
        if (this._compact != compact) {
            this._compact = compact;
            this.invalidate();
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("z.name", this._name);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-calendar" : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onChange");
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.value", (String)this.getDateFormat().format(this._value));
        if (this._compact) {
            sb.append(" z.compact=\"true\"");
        }
        return sb.toString();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InputableX {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Calendar.this);
        }

        public boolean setTextByClient(String value) throws WrongValueException {
            try {
                Date newval = Calendar.this.getDateFormat().parse(value);
                if (!Objects.equals((Object)Calendar.this._value, (Object)newval)) {
                    Calendar.this._value = newval;
                    return true;
                }
                return false;
            }
            catch (ParseException ex) {
                throw new InternalError(value);
            }
        }
    }
}

