/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zul.Caption;
import org.zkoss.zul.impl.XulElement;

public class Groupbox
extends XulElement
implements org.zkoss.zul.api.Groupbox {
    private transient Caption _caption;
    private String _cntStyle;
    private String _cntscls;
    private Boolean _legend;
    private boolean _open = true;
    private boolean _closable = true;

    public Caption getCaption() {
        return this._caption;
    }

    public org.zkoss.zul.api.Caption getCaptionApi() {
        return this.getCaption();
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("z.open", this._open);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("z.closable", closable);
        }
    }

    public String getZclass() {
        return this._zclass == null ? (this.isLegend() ? "z-fieldset" : "z-groupbox") : this._zclass;
    }

    protected String getRealSclass() {
        String cls = super.getRealSclass();
        String added = this.isClosable() && !this.isOpen() ? this.getZclass() + "-colpsd" : "";
        return cls == null ? added : cls + " " + added;
    }

    public String getContentStyle() {
        return this._cntStyle;
    }

    public void setContentStyle(String style) {
        if (!Objects.equals((Object)this._cntStyle, (Object)style)) {
            this._cntStyle = style;
            this.smartUpdate("z.cntStyle", this._cntStyle);
        }
    }

    public String getContentSclass() {
        return this._cntscls;
    }

    public void setContentSclass(String scls) {
        if (!Objects.equals((Object)this._cntscls, (Object)scls)) {
            this._cntscls = scls;
            this.invalidate();
        }
    }

    public boolean isLegend() {
        return this._legend != null ? this._legend.booleanValue() : "default".equals(this.getMold());
    }

    public void setLegend(boolean legend) {
        this._legend = legend;
    }

    public String getCaptionLook() {
        return null;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onOpen");
        String clkattrs = this.getAllOnClickAttrs();
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (!this._closable) {
            sb.append(" z.closable=\"false\"");
        }
        return sb.toString();
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + this);
            }
        } else if (refChild instanceof Caption) {
            throw new UiException("caption must be the first child");
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(child, refChild)) {
                this._caption = (Caption)child;
                this.invalidate();
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    public Object clone() {
        Groupbox clone = (Groupbox)super.clone();
        if (this._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof Caption)) continue;
            this._caption = (Caption)child;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements MultiBranch,
    Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Groupbox.this);
        }

        public boolean inDifferentBranch(Component child) {
            return child instanceof Caption;
        }

        public void setOpenByClient(boolean open) {
            Groupbox.this._open = open;
        }
    }
}

