/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listitem;

class ListboxDrawerEngine
implements Serializable,
Cloneable {
    private Listbox _listbox;
    private int _curpos;
    private int _extent;
    private transient EventListener _scrollListener;

    ListboxDrawerEngine(Listbox listbox) {
        this._listbox = listbox;
        this.initDataListener();
    }

    private void initDataListener() {
        if (this._scrollListener == null) {
            this._scrollListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (ListboxDrawerEngine.this._listbox.inSpecialMold()) {
                        String[] data = ((String)event.getData()).split(",");
                        ListboxDrawerEngine.this._curpos = Integer.parseInt(data[0]);
                        ListboxDrawerEngine.this._extent = Integer.parseInt(data[1]);
                        if (ListboxDrawerEngine.this._listbox.getListhead() != null) {
                            ListboxDrawerEngine.this._listbox.setInnerWidth(data[2]);
                        }
                        ListboxDrawerEngine.this._listbox.setInnerHeight(data[3]);
                        ListboxDrawerEngine.this._listbox.setInnerTop(data[4]);
                        ListboxDrawerEngine.this._listbox.setInnerBottom(data[5]);
                        int pgsz = ListboxDrawerEngine.this.getRenderAmount();
                        Listbox.Renderer renderer = ListboxDrawerEngine.this._listbox.new Listbox.Renderer();
                        try {
                            ListIterator it = ListboxDrawerEngine.this._listbox.getItems().listIterator(ListboxDrawerEngine.this.getRenderBegin());
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((Listitem)it.next());
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    ListboxDrawerEngine.this._listbox.invalidate();
                }
            };
        }
        this._listbox.addEventListener("onRenderAtScroll", this._scrollListener);
    }

    Set getAvailableAtClient() {
        if (!this._listbox.inSpecialMold()) {
            return null;
        }
        LinkedHashSet<Listfoot> avail = new LinkedHashSet<Listfoot>(32);
        avail.addAll(this._listbox.getHeads());
        if (this._listbox.getListfoot() != null) {
            avail.add(this._listbox.getListfoot());
        }
        int pgsz = this.getRenderAmount();
        int ofs = this.getRenderBegin();
        ListIterator it = this._listbox.getItems().listIterator(ofs);
        while (--pgsz >= 0 && it.hasNext()) {
            avail.add((Listfoot)it.next());
        }
        return avail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInitRender() {
        Listbox.Renderer renderer = this._listbox.new Listbox.Renderer();
        try {
            if (this._listbox.getRows() > 0) {
                this._extent = this._listbox.getRows();
            }
            int pgsz = this.getRenderAmount();
            int ofs = this.getRenderBegin();
            ListIterator it = this._listbox.getItems().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    int getRenderBegin() {
        int begin = this.getCurpos() - this._listbox.getPreloadSize();
        if (begin < 0) {
            begin = 0;
        }
        return begin;
    }

    int getCurpos() {
        return this._curpos;
    }

    int getRenderEnd() {
        return this.getRenderAmount() + this.getRenderBegin() - 1;
    }

    Iterator getVisibleChildrenIterator() {
        return new VisibleChildrenIterator();
    }

    int getRenderAmount() {
        if (this.getCurpos() - this._listbox.getPreloadSize() >= 0) {
            return this._extent + this._listbox.getPreloadSize() * 2;
        }
        return this._extent + this._listbox.getPreloadSize() + this.getCurpos();
    }

    int getMaxpos() {
        return this._listbox.getItemCount() - this.getVisibleAmount();
    }

    int getVisibleAmount() {
        return this._extent;
    }

    public Object clone() {
        ListboxDrawerEngine clone;
        try {
            clone = (ListboxDrawerEngine)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._scrollListener = null;
        clone.initDataListener();
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initDataListener();
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private ListIterator _it;
        private int _end;
        private int _count;

        private VisibleChildrenIterator() {
            this._it = ListboxDrawerEngine.this._listbox.getItems().listIterator(ListboxDrawerEngine.this.getRenderBegin());
            this._end = ListboxDrawerEngine.this.getRenderEnd();
        }

        public boolean hasNext() {
            return this._count < this._end;
        }

        public Object next() {
            ++this._count;
            return this._it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

