/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.api.Treechildren;
import org.zkoss.zul.api.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Treeitem
extends XulElement
implements org.zkoss.zul.api.Treeitem {
    private transient org.zkoss.zul.Treerow _treerow;
    private transient org.zkoss.zul.Treechildren _treechildren;
    private Object _value;
    private boolean _open = true;
    private boolean _selected;
    private boolean _disabled;
    private boolean _checkable = true;
    private boolean _loaded;

    public Treeitem() {
    }

    public Treeitem(String label) {
        this.setLabel(label);
    }

    public Treeitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public boolean isCheckable() {
        return this._checkable;
    }

    public void setCheckable(boolean checkable) {
        if (this._checkable != checkable) {
            this._checkable = checkable;
            this.invalidate();
        }
    }

    public void unload() {
        if (this.isLoaded()) {
            if (this.getTreechildren() != null) {
                this.getTreechildren().getChildren().clear();
            }
            this.setLoaded(false);
            this.setOpen(false);
        }
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    void setLoaded(boolean loaded) {
        if (this._loaded != loaded) {
            this._loaded = loaded;
            if (this._treerow != null) {
                this._treerow.smartUpdate("z.lod", this._loaded ? "" : "t");
            }
        }
    }

    public int indexOf() {
        List list = this.getParent().getChildren();
        return list.indexOf(this);
    }

    public org.zkoss.zul.Treerow getTreerow() {
        return this._treerow;
    }

    public Treerow getTreerowApi() {
        return this.getTreerow();
    }

    public org.zkoss.zul.Treechildren getTreechildren() {
        return this._treechildren;
    }

    public Treechildren getTreechildrenApi() {
        return this.getTreechildren();
    }

    public boolean isContainer() {
        return this._treechildren != null;
    }

    public boolean isEmpty() {
        return this._treechildren == null || this._treechildren.getChildren().isEmpty();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Tree tree = this.getTree();
            if (tree != null && tree.getName() != null) {
                this.smartUpdate("z.value", Objects.toString((Object)this._value));
            }
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            boolean shouldNotify;
            this._open = open;
            if (this._treerow != null) {
                this._treerow.smartUpdate("z.open", this._open);
            }
            boolean bl = shouldNotify = this._treechildren != null && this.isVisible();
            if (this._open) {
                Tree tree;
                if (shouldNotify) {
                    this.addVisibleItemCount(this._treechildren.getVisibleItemCount(), false);
                }
                if ((tree = this.getTree()) != null && tree.getModel() != null) {
                    tree.renderItem(this);
                }
            } else if (shouldNotify) {
                this.addVisibleItemCount(-this._treechildren.getVisibleItemCount(), true);
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Tree tree = this.getTree();
            if (tree != null) {
                tree.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getLevel() {
        Component tch;
        int level = 0;
        Treeitem item = this;
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            ++level;
        }
        return level;
    }

    public String getLabel() {
        Treecell cell = this.getFirstCell();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Treecell getFirstCell() {
        return this._treerow != null ? (Treecell)this._treerow.getFirstChild() : null;
    }

    private Treecell autoFirstCell() {
        Treecell cell;
        if (this._treerow == null) {
            org.zkoss.zul.Treerow row = new org.zkoss.zul.Treerow();
            row.applyProperties();
            row.setParent((Component)this);
        }
        if ((cell = (Treecell)this._treerow.getFirstChild()) == null) {
            cell = new Treecell();
            cell.applyProperties();
            cell.setParent((Component)this._treerow);
        }
        return cell;
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public String getImage() {
        Treecell cell = this.getFirstCell();
        return cell != null ? cell.getImage() : null;
    }

    public void setImage(String image) {
        this.autoFirstCell().setImage(image);
    }

    public Treeitem getParentItem() {
        Component p = this.getParent();
        Component gp = p != null ? p.getParent() : null;
        return gp instanceof Treeitem ? (Treeitem)gp : null;
    }

    public org.zkoss.zul.api.Treeitem getParentItemApi() {
        return this.getParentItem();
    }

    public Tree getTree() {
        Treeitem p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    protected boolean isAsapRequired(String evtnm) {
        return super.isAsapRequired(evtnm);
    }

    public void smartUpdate(String attr, String value) {
        if (this._treerow != null) {
            this._treerow.smartUpdate(attr, value);
        }
    }

    public void setDraggable(String draggable) {
        if (draggable != null) {
            throw new UnsupportedOperationException("Use Treerow.setDraggable() instead");
        }
    }

    public void setDroppable(String dropable) {
        if (dropable != null) {
            throw new UnsupportedOperationException("Use Treerow.setDroppable() instead");
        }
    }

    public void setAction(String action) {
        if (action != null) {
            throw new UnsupportedOperationException("Use Treerow.setAction() instead");
        }
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            if (this.isVisible() != visible && this._treerow != null) {
                this._treerow.smartUpdate("z.visible", visible);
            }
            int count = this.isOpen() && this._treechildren != null ? this._treechildren.getVisibleItemCount() + 1 : 1;
            boolean result = super.setVisible(visible);
            if (this.isVisible()) {
                this.addVisibleItemCount(count, false);
            } else {
                this.addVisibleItemCount(-count, true);
            }
            return result;
        }
        return visible;
    }

    public int getVisibleItemCount() {
        return this.isVisible() ? 1 + (this._treechildren != null ? this._treechildren.getVisibleItemCount() : 0) : 0;
    }

    void addVisibleItemCount(int count, boolean force) {
        org.zkoss.zul.Treechildren tc = (org.zkoss.zul.Treechildren)this.getParent();
        if (tc != null && (force || this.isVisible())) {
            tc.addVisibleItemCount(count);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof org.zkoss.zul.Treechildren)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void setParent(Component parent) {
        Tree tree;
        List sibs;
        int sz;
        List sibs2;
        int sz2;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        Treeitem affected = null;
        if (oldp != null && (sz2 = (sibs2 = oldp.getChildren()).size()) > 1 && sibs2.get(sibs2.size() - 1) == this) {
            affected = (Treeitem)sibs2.get(sibs2.size() - 2);
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (affected != null && affected._treerow != null) {
            affected._treerow.invalidate();
        }
        if (parent != null && (sz = (sibs = parent.getChildren()).size()) > 1 && sibs.get(sz - 1) == this) {
            affected = (Treeitem)sibs.get(sz - 2);
            if (affected._treerow != null) {
                affected._treerow.invalidate();
            }
        }
        if (oldtree != null) {
            oldtree.onTreeitemRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreeitemAdded(this);
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof org.zkoss.zul.Treerow) {
            if (this._treerow != null && this._treerow != child) {
                throw new UiException("Only one treerow is allowed: " + this);
            }
        } else if (child instanceof org.zkoss.zul.Treechildren) {
            if (this._treechildren != null && this._treechildren != child) {
                throw new UiException("Only one treechildren is allowed: " + this);
            }
        } else {
            throw new UiException("Unsupported child for tree item: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof org.zkoss.zul.Treerow) {
            if (super.insertBefore(child, refChild)) {
                this._treerow = (org.zkoss.zul.Treerow)child;
                if (!this.isSelected()) {
                    return true;
                }
                Tree tree = this.getTree();
                if (tree.isMultiple()) {
                    tree.smartUpdateSelection();
                } else {
                    tree.smartUpdate("select", this._treerow.getUuid());
                }
                return true;
            }
        } else if (child instanceof org.zkoss.zul.Treechildren) {
            if (super.insertBefore(child, refChild)) {
                this._treechildren = (org.zkoss.zul.Treechildren)child;
                if (this._treerow != null) {
                    this._treerow.invalidate();
                }
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this._treechildren == child) {
            this.addVisibleItemCount(this._treechildren.getVisibleItemCount(), false);
        }
    }

    public void onChildRemoved(Component child) {
        if (child instanceof org.zkoss.zul.Treerow) {
            this._treerow = null;
        } else if (child instanceof org.zkoss.zul.Treechildren) {
            this.addVisibleItemCount(-this._treechildren.getVisibleItemCount(), false);
            this._treechildren = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public void invalidate() {
        if (this._treerow != null) {
            super.invalidate();
        }
    }

    public Object clone() {
        Treeitem clone = (Treeitem)super.clone();
        int cnt = 0;
        if (clone._treerow != null) {
            ++cnt;
        }
        if (clone._treechildren != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof org.zkoss.zul.Treerow) {
                this._treerow = (org.zkoss.zul.Treerow)child;
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof org.zkoss.zul.Treechildren)) continue;
            this._treechildren = (org.zkoss.zul.Treechildren)child;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treeitem.this);
        }

        public void setOpenByClient(boolean open) {
            Treeitem.this._open = open;
            if (Treeitem.this._treechildren != null && Treeitem.this.isVisible()) {
                if (Treeitem.this._open) {
                    Treeitem.this.addVisibleItemCount(Treeitem.this._treechildren.getVisibleItemCount(), false);
                } else {
                    Treeitem.this.addVisibleItemCount(-Treeitem.this._treechildren.getVisibleItemCount(), true);
                }
            }
            Tree tree = Treeitem.this.getTree();
            if (Treeitem.this._open && tree != null && tree.getModel() != null) {
                tree.renderItem(Treeitem.this);
            }
            if (tree != null && tree.inPagingMold()) {
                tree.focus();
            }
        }
    }
}

