/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ResourceInfo;
import org.zkoss.web.util.resource.ResourceLoader;

public class ResourceCaches {
    private static final Log log = Log.lookup((Class)ResourceCaches.class);
    private static final String ATTR_PAGE_CACHE = "org.zkoss.web.util.resource.PageCache";

    public static final Object get(ResourceCache cache, ServletContext ctx, String path, Object extra) {
        URL url = null;
        if (path == null || path.length() == 0) {
            path = "/";
        } else if (path.charAt(0) != '/') {
            if (path.indexOf("://") > 0) {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException ex) {
                    throw new SystemException((Throwable)ex);
                }
            } else {
                path = '/' + path;
            }
        }
        if (url == null) {
            File file;
            String flnm;
            if (path.startsWith("/~")) {
                String ctxpath;
                ServletContext ctx0 = ctx;
                String path0 = path;
                int j = path.indexOf(47, 2);
                if (j >= 0) {
                    ctxpath = "/" + path.substring(2, j);
                    path = path.substring(j);
                } else {
                    ctxpath = "/" + path.substring(2);
                    path = "/";
                }
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxpath.substring(1));
                if (extctx != null) {
                    url = extctx.getResource(path);
                    if (url == null) {
                        return null;
                    }
                    return cache.get((Object)new ResourceInfo(path, url, extra));
                }
                if ((ctx = ctx.getContext(ctxpath)) == null) {
                    ctx = ctx0;
                    path = path0;
                }
            }
            if ((flnm = ctx.getRealPath(path)) != null && (file = new File(flnm)).exists()) {
                return cache.get((Object)new ResourceInfo(path, file, extra));
            }
        }
        try {
            if (url == null) {
                url = ctx.getResource(path);
            }
            if (url != null) {
                return cache.get((Object)new ResourceInfo(path, url, extra));
            }
        }
        catch (Throwable ex) {
            log.warning("Unable to load " + path + "\n" + Exceptions.getMessage((Throwable)ex));
        }
        return null;
    }

    public static final String getContent(ServletContext ctx, String path) {
        return (String)ResourceCaches.get(ResourceCaches.getCache(ctx), ctx, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceCache getCache(ServletContext ctx) {
        ResourceCache cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
        if (cache == null) {
            Class clazz = ResourceCaches.class;
            synchronized (clazz) {
                cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
                if (cache == null) {
                    cache = new ResourceCache((Loader)new ContentLoader(ctx), 29);
                    cache.setMaxSize(1024);
                    cache.setLifetime(3600000);
                    ctx.setAttribute(ATTR_PAGE_CACHE, (Object)cache);
                }
            }
        }
        return cache;
    }

    private static class ContentLoader
    extends ResourceLoader {
        private final ServletContext _ctx;

        private ContentLoader(ServletContext ctx) {
            this._ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object parse(String path, File file, Object extra) throws Exception {
            FileInputStream is = new FileInputStream(file);
            try {
                String string = this.readAll(is);
                return string;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable ex) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object parse(String path, URL url, Object extra) throws Exception {
            InputStream is = url.openStream();
            try {
                String string = this.readAll(is);
                return string;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable ex) {}
            }
        }

        private String readAll(InputStream is) throws Exception {
            if (is == null) {
                return null;
            }
            return Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
        }
    }
}

