/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.Function;
import org.sqlite.RS;

abstract class DB
implements Codes {
    Conn conn = null;
    long pointer = 0L;
    long begin = 0L;
    long commit = 0L;
    private Map stmts = new Hashtable();

    DB() {
    }

    abstract void interrupt() throws SQLException;

    abstract void busy_timeout(int var1) throws SQLException;

    abstract String errmsg() throws SQLException;

    abstract String libversion() throws SQLException;

    abstract int changes() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void exec(String string) throws SQLException {
        long l = 0L;
        try {
            l = this.prepare(string);
            switch (this.step(l)) {
                case 101: {
                    this.ensureAutoCommit();
                    return;
                }
                case 100: {
                    return;
                }
            }
            this.throwex();
        }
        finally {
            this.finalize(l);
        }
    }

    final synchronized void open(Conn conn, String string) throws SQLException {
        this.conn = conn;
        this._open(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void close() throws SQLException {
        Map map = this.stmts;
        synchronized (map) {
            Iterator iterator = this.stmts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                RS rS = (RS)((WeakReference)entry.getValue()).get();
                this.finalize((Long)entry.getKey());
                if (rS != null) {
                    rS.pointer = 0L;
                    rS.db = null;
                }
                iterator.remove();
            }
        }
        this.free_functions();
        if (this.begin != 0L) {
            this.finalize(this.begin);
            this.begin = 0L;
        }
        if (this.commit != 0L) {
            this.finalize(this.commit);
            this.commit = 0L;
        }
        this._close();
    }

    final synchronized void prepare(RS rS) throws SQLException {
        if (rS.pointer != 0L) {
            this.finalize(rS);
        }
        rS.pointer = this.prepare(rS.sql);
        this.stmts.put(new Long(rS.pointer), new WeakReference<RS>(rS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int finalize(RS rS) throws SQLException {
        if (rS.pointer == 0L) {
            return 0;
        }
        int n = 1;
        try {
            n = this.finalize(rS.pointer);
        }
        finally {
            this.stmts.remove(new Long(rS.pointer));
            rS.pointer = 0L;
        }
        return n;
    }

    protected abstract void _open(String var1) throws SQLException;

    protected abstract void _close() throws SQLException;

    protected abstract long prepare(String var1) throws SQLException;

    protected abstract int finalize(long var1) throws SQLException;

    protected abstract int step(long var1) throws SQLException;

    protected abstract int reset(long var1) throws SQLException;

    abstract int clear_bindings(long var1) throws SQLException;

    abstract int bind_parameter_count(long var1) throws SQLException;

    abstract int column_count(long var1) throws SQLException;

    abstract int column_type(long var1, int var3) throws SQLException;

    abstract String column_decltype(long var1, int var3) throws SQLException;

    abstract String column_table_name(long var1, int var3) throws SQLException;

    abstract String column_name(long var1, int var3) throws SQLException;

    abstract String column_text(long var1, int var3) throws SQLException;

    abstract byte[] column_blob(long var1, int var3) throws SQLException;

    abstract double column_double(long var1, int var3) throws SQLException;

    abstract long column_long(long var1, int var3) throws SQLException;

    abstract int column_int(long var1, int var3) throws SQLException;

    abstract int bind_null(long var1, int var3) throws SQLException;

    abstract int bind_int(long var1, int var3, int var4) throws SQLException;

    abstract int bind_long(long var1, int var3, long var4) throws SQLException;

    abstract int bind_double(long var1, int var3, double var4) throws SQLException;

    abstract int bind_text(long var1, int var3, String var4) throws SQLException;

    abstract int bind_blob(long var1, int var3, byte[] var4) throws SQLException;

    abstract void result_null(long var1) throws SQLException;

    abstract void result_text(long var1, String var3) throws SQLException;

    abstract void result_blob(long var1, byte[] var3) throws SQLException;

    abstract void result_double(long var1, double var3) throws SQLException;

    abstract void result_long(long var1, long var3) throws SQLException;

    abstract void result_int(long var1, int var3) throws SQLException;

    abstract void result_error(long var1, String var3) throws SQLException;

    abstract int value_bytes(Function var1, int var2) throws SQLException;

    abstract String value_text(Function var1, int var2) throws SQLException;

    abstract byte[] value_blob(Function var1, int var2) throws SQLException;

    abstract double value_double(Function var1, int var2) throws SQLException;

    abstract long value_long(Function var1, int var2) throws SQLException;

    abstract int value_int(Function var1, int var2) throws SQLException;

    abstract int value_type(Function var1, int var2) throws SQLException;

    abstract int create_function(String var1, Function var2) throws SQLException;

    abstract int destroy_function(String var1) throws SQLException;

    abstract void free_functions() throws SQLException;

    abstract boolean[][] column_metadata(long var1) throws SQLException;

    final synchronized String[] column_names(long l) throws SQLException {
        String[] stringArray = new String[this.column_count(l)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.column_name(l, i);
        }
        return stringArray;
    }

    final synchronized int sqlbind(long l, int n, Object object) throws SQLException {
        ++n;
        if (object == null) {
            return this.bind_null(l, n);
        }
        if (object instanceof Integer) {
            return this.bind_int(l, n, (Integer)object);
        }
        if (object instanceof Long) {
            return this.bind_long(l, n, (Long)object);
        }
        if (object instanceof Double) {
            return this.bind_double(l, n, (Double)object);
        }
        if (object instanceof String) {
            return this.bind_text(l, n, (String)object);
        }
        if (object instanceof byte[]) {
            return this.bind_blob(l, n, (byte[])object);
        }
        throw new SQLException("unexpected param type: " + object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int[] executeBatch(long l, int n, Object[] objectArray) throws SQLException {
        if (n < 1) {
            throw new SQLException("count (" + n + ") < 1");
        }
        int n2 = this.bind_parameter_count(l);
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                this.reset(l);
                for (int j = 0; j < n2; ++j) {
                    if (this.sqlbind(l, j, objectArray[i * n2 + j]) == 0) continue;
                    this.throwex();
                }
                int n3 = this.step(l);
                if (n3 != 101) {
                    this.reset(l);
                    if (n3 == 100) {
                        throw new BatchUpdateException("batch entry " + i + ": query returns results", nArray);
                    }
                    this.throwex();
                }
                nArray[i] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit();
        }
        this.reset(l);
        return nArray;
    }

    final synchronized boolean execute(RS rS, Object[] objectArray) throws SQLException {
        if (objectArray != null) {
            int n = this.bind_parameter_count(rS.pointer);
            if (n != objectArray.length) {
                throw new SQLException("assertion failure: param count (" + n + ") != value count (" + objectArray.length + ")");
            }
            for (int i = 0; i < n; ++i) {
                if (this.sqlbind(rS.pointer, i, objectArray[i]) == 0) continue;
                this.throwex();
            }
        }
        switch (this.step(rS.pointer)) {
            case 101: {
                this.reset(rS.pointer);
                this.ensureAutoCommit();
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: {
                throw new SQLException("database locked");
            }
            case 21: {
                throw new SQLException(this.errmsg());
            }
        }
        this.finalize(rS);
        throw new SQLException(this.errmsg());
    }

    final synchronized int executeUpdate(RS rS, Object[] objectArray) throws SQLException {
        if (this.execute(rS, objectArray)) {
            throw new SQLException("query returns results");
        }
        this.reset(rS.pointer);
        return this.changes();
    }

    final void throwex() throws SQLException {
        throw new SQLException(this.errmsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureAutoCommit() throws SQLException {
        if (!this.conn.getAutoCommit()) {
            return;
        }
        if (this.begin == 0L) {
            this.begin = this.prepare("begin;");
        }
        if (this.commit == 0L) {
            this.commit = this.prepare("commit;");
        }
        try {
            if (this.step(this.begin) != 101) {
                return;
            }
            if (this.step(this.commit) != 101) {
                this.reset(this.commit);
                this.throwex();
            }
        }
        finally {
            this.reset(this.begin);
            this.reset(this.commit);
        }
    }
}

