/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.ibex.nestedvm.Runtime;
import org.sqlite.DB;
import org.sqlite.Function;

final class NestedDB
extends DB
implements Runtime.CallJavaCB {
    int handle = 0;
    private static Runtime rt = null;
    private static final Object rtLock = new Object();
    private static int open = 0;
    private Function[] functions = null;
    private String[] funcNames = null;
    private final int[] p0 = new int[0];
    private final int[] p1 = new int[]{0};
    private final int[] p2 = new int[]{0, 0};
    private final int[] p3 = new int[]{0, 0, 0};
    private final int[] p4 = new int[]{0, 0, 0, 0};
    private final int[] p5 = new int[]{0, 0, 0, 0, 0};

    NestedDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _open(String string) throws SQLException {
        if (this.handle != 0) {
            throw new SQLException("DB already open");
        }
        if (string.length() > 2) {
            char c = Character.toLowerCase(string.charAt(0));
            if (string.charAt(1) == ':' && c >= 'a' && c <= 'z') {
                string = string.substring(2);
                string = string.replace('\\', '/');
                string = "/" + c + ":" + string;
            }
        }
        Object object = rtLock;
        synchronized (object) {
            if (rt == null) {
                try {
                    rt = (Runtime)Class.forName("org.sqlite.SQLite").newInstance();
                    rt.start();
                }
                catch (Exception exception) {
                    throw new CausedSQLException(exception);
                }
                rt.setCallJavaCB(this);
            }
        }
        object = rtLock;
        synchronized (object) {
            ++open;
            int n = rt.xmalloc(4);
            int n2 = rt.strdup(string);
            if (this.call("sqlite3_open", n2, n) != 0) {
                this.throwex();
            }
            this.handle = this.deref(n);
            rt.free(n2);
            rt.free(n);
        }
    }

    public int call(int n, int n2, int n3, int n4) {
        this.xUDF(n, n2, n3, n4);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _close() throws SQLException {
        if (this.handle == 0) {
            return;
        }
        try {
            if (this.call("sqlite3_close", this.handle) != 0) {
                this.throwex();
            }
        }
        finally {
            this.handle = 0;
            Object object = rtLock;
            synchronized (object) {
                if (--open == 0) {
                    rt.stop();
                    rt = null;
                }
            }
        }
    }

    synchronized void interrupt() throws SQLException {
        this.call("sqlite3_interrupt", this.handle);
    }

    synchronized void busy_timeout(int n) throws SQLException {
        this.call("sqlite3_busy_timeout", this.handle, n);
    }

    protected synchronized long prepare(String string) throws SQLException {
        int n = rt.xmalloc(4);
        int n2 = rt.strdup(string);
        int n3 = this.call("sqlite3_prepare_v2", this.handle, n2, -1, n, 0);
        rt.free(n2);
        if (n3 != 0) {
            rt.free(n);
            this.throwex();
        }
        int n4 = this.deref(n);
        rt.free(n);
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String errmsg() throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.cstring(this.call("sqlite3_errmsg", this.handle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String libversion() throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.cstring(this.call("sqlite3_libversion", this.handle));
        }
    }

    synchronized int changes() throws SQLException {
        return this.call("sqlite3_changes", this.handle);
    }

    protected synchronized int finalize(long l) throws SQLException {
        return this.call("sqlite3_finalize", (int)l);
    }

    protected synchronized int step(long l) throws SQLException {
        return this.call("sqlite3_step", (int)l);
    }

    protected synchronized int reset(long l) throws SQLException {
        return this.call("sqlite3_reset", (int)l);
    }

    synchronized int clear_bindings(long l) throws SQLException {
        return this.call("sqlite3_clear_bindings", (int)l);
    }

    synchronized int bind_parameter_count(long l) throws SQLException {
        return this.call("sqlite3_bind_parameter_count", (int)l);
    }

    synchronized int column_count(long l) throws SQLException {
        return this.call("sqlite3_column_count", (int)l);
    }

    synchronized int column_type(long l, int n) throws SQLException {
        return this.call("sqlite3_column_type", (int)l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String column_name(long l, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.utfstring(this.call("sqlite3_column_name", (int)l, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String column_text(long l, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.utfstring(this.call("sqlite3_column_text", (int)l, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte[] column_blob(long l, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            int n2 = this.call("sqlite3_column_blob", (int)l, n);
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = new byte[this.call("sqlite3_column_bytes", (int)l, n)];
            this.copyin(n2, byArray, byArray.length);
            return byArray;
        }
    }

    synchronized double column_double(long l, int n) throws SQLException {
        try {
            return Double.parseDouble(this.column_text(l, n));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    synchronized long column_long(long l, int n) throws SQLException {
        try {
            return Long.parseLong(this.column_text(l, n));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    synchronized int column_int(long l, int n) throws SQLException {
        return this.call("sqlite3_column_int", (int)l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String column_decltype(long l, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.utfstring(this.call("sqlite3_column_decltype", (int)l, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String column_table_name(long l, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.utfstring(this.call("sqlite3_column_table_name", (int)l, n));
        }
    }

    synchronized int bind_null(long l, int n) throws SQLException {
        return this.call("sqlite3_bind_null", (int)l, n);
    }

    synchronized int bind_int(long l, int n, int n2) throws SQLException {
        return this.call("sqlite3_bind_int", (int)l, n, n2);
    }

    synchronized int bind_long(long l, int n, long l2) throws SQLException {
        return this.bind_text(l, n, Long.toString(l2));
    }

    synchronized int bind_double(long l, int n, double d) throws SQLException {
        return this.bind_text(l, n, Double.toString(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int bind_text(long l, int n, String string) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            if (string == null) {
                return this.bind_null(l, n);
            }
            return this.call("sqlite3_bind_text", (int)l, n, rt.strdup(string), -1, rt.lookupSymbol("free"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int bind_blob(long l, int n, byte[] byArray) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            if (byArray == null || byArray.length < 1) {
                return this.bind_null(l, n);
            }
            int n2 = byArray.length;
            int n3 = rt.xmalloc(n2);
            this.copyout(byArray, n3, n2);
            return this.call("sqlite3_bind_blob", (int)l, n, n3, n2, rt.lookupSymbol("free"));
        }
    }

    synchronized void result_null(long l) throws SQLException {
        this.call("sqlite3_result_null", (int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void result_text(long l, String string) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            this.call("sqlite3_result_text", (int)l, rt.strdup(string), -1, rt.lookupSymbol("free"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void result_blob(long l, byte[] byArray) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            if (byArray == null || byArray.length == 0) {
                this.result_null(l);
                return;
            }
            int n = rt.xmalloc(byArray.length);
            this.copyout(byArray, n, byArray.length);
            this.call("sqlite3_result_blob", (int)l, n, byArray.length, rt.lookupSymbol("free"));
        }
    }

    synchronized void result_double(long l, double d) throws SQLException {
        this.result_text(l, Double.toString(d));
    }

    synchronized void result_long(long l, long l2) throws SQLException {
        this.result_text(l, Long.toString(l2));
    }

    synchronized void result_int(long l, int n) throws SQLException {
        this.call("sqlite3_result_int", (int)l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void result_error(long l, String string) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            int n = rt.strdup(string);
            this.call("sqlite3_result_error", (int)l, n, -1);
            rt.free(n);
        }
    }

    synchronized int value_bytes(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_bytes", this.value(function, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String value_text(Function function, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            return this.utfstring(this.call("sqlite3_value_text", this.value(function, n)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte[] value_blob(Function function, int n) throws SQLException {
        Object object = rtLock;
        synchronized (object) {
            int n2 = this.call("sqlite3_value_blob", this.value(function, n));
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = new byte[this.value_bytes(function, n)];
            this.copyin(n2, byArray, byArray.length);
            return byArray;
        }
    }

    synchronized double value_double(Function function, int n) throws SQLException {
        return Double.parseDouble(this.value_text(function, n));
    }

    synchronized long value_long(Function function, int n) throws SQLException {
        return Long.parseLong(this.value_text(function, n));
    }

    synchronized int value_int(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_int", this.value(function, n));
    }

    synchronized int value_type(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_type", this.value(function, n));
    }

    private int value(Function function, int n) throws SQLException {
        return this.deref((int)function.value + n * 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int create_function(String string, Function function) throws SQLException {
        String[] stringArray;
        int n;
        if (this.functions == null) {
            this.functions = new Function[10];
            this.funcNames = new String[10];
        }
        for (n = 0; n < this.functions.length && this.functions[n] != null; ++n) {
        }
        if (n == this.functions.length) {
            Function[] functionArray = new Function[this.functions.length * 2];
            stringArray = new String[this.funcNames.length * 2];
            System.arraycopy(this.functions, 0, functionArray, 0, this.functions.length);
            System.arraycopy(this.funcNames, 0, stringArray, 0, this.funcNames.length);
            this.functions = functionArray;
            this.funcNames = stringArray;
        }
        this.functions[n] = function;
        this.funcNames[n] = string;
        stringArray = rtLock;
        synchronized (rtLock) {
            int n2 = rt.strdup(string);
            int n3 = this.call("create_function_helper", this.handle, n2, n, function instanceof Function.Aggregate ? 1 : 0);
            rt.free(n2);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int destroy_function(String string) throws SQLException {
        int n;
        int n2;
        if (string == null) {
            return 0;
        }
        for (n2 = 0; n2 < this.funcNames.length && !string.equals(this.funcNames[n2]); ++n2) {
        }
        if (n2 == this.funcNames.length) {
            return 0;
        }
        this.functions[n2] = null;
        this.funcNames[n2] = null;
        Object object = rtLock;
        synchronized (object) {
            int n3 = rt.strdup(string);
            n = this.call("create_function_helper", this.handle, n3, -1, 0);
            rt.free(n3);
        }
        return n;
    }

    synchronized void free_functions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void xUDF(int n, int n2, int n3, int n4) {
        Function function = null;
        Object object = rtLock;
        // MONITORENTER : object
        try {
            int n5 = this.call("sqlite3_user_data", n2);
            function = this.functions[n5];
            if (function == null) {
                throw new SQLException("function state inconsistent");
            }
            function.context = n2;
            function.value = n4;
            function.args = n3;
            switch (n) {
                case 1: {
                    function.xFunc();
                    return;
                }
                case 2: {
                    ((Function.Aggregate)function).xStep();
                    return;
                }
                case 3: {
                    ((Function.Aggregate)function).xFinal();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            try {
                String string = sQLException.toString();
                if (string == null) {
                    string = "unknown error";
                }
                int n6 = rt.strdup(string);
                this.call("sqlite3_result_error", n2, n6, -1);
                rt.free(n6);
                return;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                return;
            }
        }
        finally {
            if (function != null) {
                function.context = 0L;
                function.value = 0L;
                function.args = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean[][] column_metadata(long l) throws SQLException {
        int n = this.call("sqlite3_column_count", (int)l);
        boolean[][] blArray = new boolean[n][3];
        Object object = rtLock;
        synchronized (object) {
            int n2 = rt.xmalloc(12);
            for (int i = 0; i < n; ++i) {
                this.call("column_metadata_helper", this.handle, (int)l, i, n2);
                blArray[i][0] = this.deref(n2) == 1;
                blArray[i][1] = this.deref(n2 + 4) == 1;
                blArray[i][2] = this.deref(n2 + 8) == 1;
            }
            rt.free(n2);
        }
        return blArray;
    }

    private int call(String string, int n) throws SQLException {
        this.p1[0] = n;
        return this.call(string, this.p1);
    }

    private int call(String string, int n, int n2) throws SQLException {
        this.p2[0] = n;
        this.p2[1] = n2;
        return this.call(string, this.p2);
    }

    private int call(String string, int n, int n2, int n3) throws SQLException {
        this.p3[0] = n;
        this.p3[1] = n2;
        this.p3[2] = n3;
        return this.call(string, this.p3);
    }

    private int call(String string, int n, int n2, int n3, int n4) throws SQLException {
        this.p4[0] = n;
        this.p4[1] = n2;
        this.p4[2] = n3;
        this.p4[3] = n4;
        return this.call(string, this.p4);
    }

    private int call(String string, int n, int n2, int n3, int n4, int n5) throws SQLException {
        this.p5[0] = n;
        this.p5[1] = n2;
        this.p5[2] = n3;
        this.p5[3] = n4;
        this.p5[4] = n5;
        return this.call(string, this.p5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int call(String string, int[] nArray) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                return rt.call(string, nArray);
            }
        }
        catch (Runtime.CallException callException) {
            throw new CausedSQLException(callException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deref(int n) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                return rt.memRead(n);
            }
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String utfstring(int n) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                return rt.utfstring(n);
            }
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cstring(int n) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                return rt.cstring(n);
            }
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyin(int n, byte[] byArray, int n2) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                rt.copyin(n, byArray, n2);
            }
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyout(byte[] byArray, int n, int n2) throws SQLException {
        try {
            Object object = rtLock;
            synchronized (object) {
                rt.copyout(byArray, n, n2);
            }
        }
        catch (Runtime.FaultException faultException) {
            throw new CausedSQLException(faultException);
        }
    }

    private static final class CausedSQLException
    extends SQLException {
        private final Exception cause;

        CausedSQLException(Exception exception) {
            if (exception == null) {
                throw new RuntimeException("null exception cause");
            }
            this.cause = exception;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void printStackTrace() {
            this.cause.printStackTrace();
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.cause.printStackTrace(printWriter);
        }

        public Throwable fillInStackTrace() {
            return this.cause.fillInStackTrace();
        }

        public StackTraceElement[] getStackTrace() {
            return this.cause.getStackTrace();
        }

        public String getMessage() {
            return this.cause.getMessage();
        }
    }
}

