/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.File;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import org.sqlite.DB;
import org.sqlite.MetaData;
import org.sqlite.PrepStmt;
import org.sqlite.Stmt;

class Conn
implements Connection {
    private final String url;
    private DB db = null;
    private MetaData meta = null;
    private boolean autoCommit = true;
    private int timeout = 0;

    public Conn(String string, String string2) throws SQLException {
        Serializable serializable;
        if (!":memory:".equals(string2)) {
            serializable = new File(string2).getAbsoluteFile();
            File file = ((File)serializable).getParentFile();
            if (file != null && !file.exists()) {
                for (File file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
                    file = file2;
                }
                throw new SQLException("path to '" + string2 + "': '" + file + "' does not exist");
            }
            try {
                if (!((File)serializable).exists() && ((File)serializable).createNewFile()) {
                    ((File)serializable).delete();
                }
            }
            catch (Exception exception) {
                throw new SQLException("opening db: '" + string2 + "': " + exception.getMessage());
            }
            string2 = ((File)serializable).getAbsolutePath();
        }
        try {
            serializable = Class.forName("org.sqlite.NativeDB");
            if (((Boolean)((Class)serializable).getDeclaredMethod("load", null).invoke(null, null)).booleanValue()) {
                this.db = (DB)((Class)serializable).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.db == null) {
            try {
                this.db = (DB)Class.forName("org.sqlite.NestedDB").newInstance();
            }
            catch (Exception exception) {
                throw new SQLException("no SQLite library found");
            }
        }
        this.url = string;
        this.db.open(this, string2);
        this.setTimeout(3000);
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int n) throws SQLException {
        this.timeout = n;
        this.db.busy_timeout(n);
    }

    String url() {
        return this.url;
    }

    String libversion() throws SQLException {
        return this.db.libversion();
    }

    DB db() {
        return this.db;
    }

    private void checkOpen() throws SQLException {
        if (this.db == null) {
            throw new SQLException("database connection closed");
        }
    }

    private void checkCursor(int n, int n2, int n3) throws SQLException {
        if (n != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (n2 != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (n3 != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    public void finalize() throws SQLException {
        this.close();
    }

    public void close() throws SQLException {
        if (this.db == null) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.close();
        this.db = null;
    }

    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        if (n != 2) {
            throw new SQLException("SQLite only supports CLOSE_CURSORS_AT_COMMIT");
        }
    }

    public int getTransactionIsolation() {
        return 8;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 8) {
            throw new SQLException("SQLite supports only TRANSACTION_SERIALIZABLE");
        }
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public DatabaseMetaData getMetaData() {
        if (this.meta == null) {
            this.meta = new MetaData(this);
        }
        return this.meta;
    }

    public String nativeSQL(String string) {
        return string;
    }

    public void clearWarnings() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        if (this.autoCommit == bl) {
            return;
        }
        this.autoCommit = bl;
        this.db.exec(this.autoCommit ? "commit;" : "begin;");
    }

    public void commit() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;");
        this.db.exec("begin;");
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;");
        this.db.exec("begin;");
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkCursor(n, n2, n3);
        return new Stmt(this);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, 2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("SQLite does not support Stored Procedures");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkCursor(n, n2, n3);
        return new PrepStmt(this, string);
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLException("unsupported by SQLite");
    }
}

