/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ISOLatin1PolishAccentFilter
extends TokenFilter {
    private char[] output = new char[256];
    private int outputPos;

    public ISOLatin1PolishAccentFilter(TokenStream tokenStream) {
        super(tokenStream);
    }

    public final Token next(Token token) throws IOException {
        if ((token = this.input.next(token)) != null) {
            char[] cArray = token.termBuffer();
            int n = token.termLength();
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (c < '\u00c0' || c > '\u017f') continue;
                this.removeAccents(cArray, n);
                token.setTermBuffer(this.output, 0, this.outputPos);
                break;
            }
            return token;
        }
        return null;
    }

    public final void removeAccents(char[] cArray, int n) {
        int n2;
        int n3 = 2 * n;
        for (n2 = this.output.length; n2 < n3; n2 *= 2) {
        }
        if (n2 != this.output.length) {
            this.output = new char[n2];
        }
        this.outputPos = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char c = cArray[n4];
            if (c < '\u00c0') {
                this.output[this.outputPos++] = c;
            } else {
                switch (c) {
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u0104': {
                        this.output[this.outputPos++] = 65;
                        break;
                    }
                    case '\u00c6': {
                        this.output[this.outputPos++] = 65;
                        this.output[this.outputPos++] = 69;
                        break;
                    }
                    case '\u00c7': 
                    case '\u0106': {
                        this.output[this.outputPos++] = 67;
                        break;
                    }
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u0118': {
                        this.output[this.outputPos++] = 69;
                        break;
                    }
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        this.output[this.outputPos++] = 73;
                        break;
                    }
                    case '\u00d0': {
                        this.output[this.outputPos++] = 68;
                        break;
                    }
                    case '\u0141': {
                        this.output[this.outputPos++] = 76;
                        break;
                    }
                    case '\u00d1': 
                    case '\u0143': {
                        this.output[this.outputPos++] = 78;
                        break;
                    }
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d8': {
                        this.output[this.outputPos++] = 79;
                        break;
                    }
                    case '\u0152': {
                        this.output[this.outputPos++] = 79;
                        this.output[this.outputPos++] = 69;
                        break;
                    }
                    case '\u00de': {
                        this.output[this.outputPos++] = 84;
                        this.output[this.outputPos++] = 72;
                        break;
                    }
                    case '\u015a': {
                        this.output[this.outputPos++] = 83;
                        break;
                    }
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': {
                        this.output[this.outputPos++] = 85;
                        break;
                    }
                    case '\u00dd': 
                    case '\u0178': {
                        this.output[this.outputPos++] = 89;
                        break;
                    }
                    case '\u0179': 
                    case '\u017b': {
                        this.output[this.outputPos++] = 90;
                        break;
                    }
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': 
                    case '\u0105': {
                        this.output[this.outputPos++] = 97;
                        break;
                    }
                    case '\u00e6': {
                        this.output[this.outputPos++] = 97;
                        this.output[this.outputPos++] = 101;
                        break;
                    }
                    case '\u00e7': 
                    case '\u0107': {
                        this.output[this.outputPos++] = 99;
                        break;
                    }
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': 
                    case '\u0119': {
                        this.output[this.outputPos++] = 101;
                        break;
                    }
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': {
                        this.output[this.outputPos++] = 105;
                        break;
                    }
                    case '\u0142': {
                        this.output[this.outputPos++] = 108;
                        break;
                    }
                    case '\u00f0': {
                        this.output[this.outputPos++] = 100;
                        break;
                    }
                    case '\u00f1': 
                    case '\u0144': {
                        this.output[this.outputPos++] = 110;
                        break;
                    }
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': 
                    case '\u00f8': {
                        this.output[this.outputPos++] = 111;
                        break;
                    }
                    case '\u0153': {
                        this.output[this.outputPos++] = 111;
                        this.output[this.outputPos++] = 101;
                        break;
                    }
                    case '\u00df': {
                        this.output[this.outputPos++] = 115;
                        this.output[this.outputPos++] = 115;
                        break;
                    }
                    case '\u00fe': {
                        this.output[this.outputPos++] = 116;
                        this.output[this.outputPos++] = 104;
                        break;
                    }
                    case '\u015b': {
                        this.output[this.outputPos++] = 115;
                        break;
                    }
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': {
                        this.output[this.outputPos++] = 117;
                        break;
                    }
                    case '\u00fd': 
                    case '\u00ff': {
                        this.output[this.outputPos++] = 121;
                        break;
                    }
                    case '\u017a': 
                    case '\u017c': {
                        this.output[this.outputPos++] = 122;
                        break;
                    }
                    default: {
                        this.output[this.outputPos++] = c;
                    }
                }
            }
            ++n5;
            ++n4;
        }
    }
}

