/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import pl.edu.icm.yadda.service.search.analysis.ISOLatin1PolishAccentFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAccentAnalyzer
extends Analyzer {
    protected Set<?> stopSet;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;
    protected boolean useAccentFilter = true;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public StandardAccentAnalyzer() {
        this(STOP_WORDS);
    }

    public StandardAccentAnalyzer(Set<?> set) {
        this.stopSet = set;
    }

    public StandardAccentAnalyzer(String[] stringArray) {
        this.stopSet = StopFilter.makeStopSet((String[])stringArray);
    }

    public StandardAccentAnalyzer(File file) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((File)file);
    }

    public StandardAccentAnalyzer(Reader reader) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((Reader)reader);
    }

    public TokenStream tokenStream(String string, Reader reader) {
        StandardTokenizer standardTokenizer = new StandardTokenizer(reader, true);
        standardTokenizer.setMaxTokenLength(this.maxTokenLength);
        Object object = new StandardFilter((TokenStream)standardTokenizer);
        object = new LowerCaseFilter((TokenStream)object);
        if (this.stopSet != null && !this.stopSet.isEmpty()) {
            object = new StopFilter((TokenStream)object, this.stopSet);
        }
        if (this.useAccentFilter) {
            object = new ISOLatin1PolishAccentFilter((TokenStream)object);
        }
        return object;
    }

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        SavedStreams savedStreams = (SavedStreams)this.getPreviousTokenStream();
        if (savedStreams == null) {
            savedStreams = new SavedStreams();
            this.setPreviousTokenStream(savedStreams);
            savedStreams.tokenStream = new StandardTokenizer(reader, true);
            savedStreams.filteredTokenStream = new StandardFilter((TokenStream)savedStreams.tokenStream);
            savedStreams.filteredTokenStream = new LowerCaseFilter(savedStreams.filteredTokenStream);
            if (this.stopSet != null && !this.stopSet.isEmpty()) {
                savedStreams.filteredTokenStream = new StopFilter(savedStreams.filteredTokenStream, this.stopSet);
            }
            if (this.useAccentFilter) {
                savedStreams.filteredTokenStream = new ISOLatin1PolishAccentFilter(savedStreams.filteredTokenStream);
            }
        } else {
            savedStreams.tokenStream.reset(reader);
        }
        savedStreams.tokenStream.setMaxTokenLength(this.maxTokenLength);
        return savedStreams.filteredTokenStream;
    }

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

