/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.filter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryWrapperFilter;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.filter.FilterFactory;
import pl.edu.icm.yadda.service.search.filter.QueryWrapper;
import pl.edu.icm.yadda.service.search.filter.impl.FilterWrapper;

public class FilterFactoryImpl
implements FilterFactory {
    private static final Log log = LogFactory.getLog(FilterFactoryImpl.class);
    private int filtersLimit = 50;
    private Map<String, FilterWrapper> filterCache = new Hashtable<String, FilterWrapper>();
    private Object mutex = new Object();
    private static final Comparator<FilterWrapper> filterComparator = new Comparator<FilterWrapper>(){

        @Override
        public int compare(FilterWrapper filterWrapper, FilterWrapper filterWrapper2) {
            return filterWrapper.getCounter() - filterWrapper2.getCounter();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter(String string, QueryWrapper queryWrapper) throws SearchException {
        FilterWrapper filterWrapper = this.filterCache.get(string);
        if (filterWrapper == null) {
            Object object = this.mutex;
            synchronized (object) {
                filterWrapper = this.filterCache.get(string);
                if (filterWrapper == null) {
                    CachingWrapperFilter cachingWrapperFilter = new CachingWrapperFilter((Filter)new QueryWrapperFilter(queryWrapper.getQuery()));
                    filterWrapper = new FilterWrapper(string, (Filter)cachingWrapperFilter);
                    if (this.filtersLimit != 0 && this.filterCache.size() >= this.filtersLimit) {
                        this.removeLeastFrequentlyUsed();
                    }
                    this.filterCache.put(string, filterWrapper);
                    log.info((Object)("New filter '" + string + "' has been created"));
                }
            }
        }
        filterWrapper.incCounter();
        return filterWrapper.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(String string) {
        Object object = this.mutex;
        synchronized (object) {
            FilterWrapper filterWrapper = this.filterCache.remove(string);
            if (filterWrapper == null) {
                log.warn((Object)("Filter '" + string + "' is to be removed but does not exist"));
            } else {
                log.info((Object)("Filter '" + string + "' has been removed from cache (user request)"));
            }
        }
    }

    private void removeLeastFrequentlyUsed() {
        ArrayList<FilterWrapper> arrayList = new ArrayList<FilterWrapper>(this.filterCache.values());
        Collections.sort(arrayList, filterComparator);
        FilterWrapper filterWrapper = (FilterWrapper)arrayList.remove(0);
        this.filterCache.remove(filterWrapper.name);
        log.info((Object)("Filter '" + filterWrapper.name + "' has been removed from cache (useCount:" + filterWrapper.getCounter() + ", cacheSize:" + this.filterCache.size() + ")"));
    }

    public void setFiltersLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Filters limit can not be less than 0");
        }
        this.filtersLimit = n;
    }

    public int getFiltersLimit() {
        return this.filtersLimit;
    }
}

