/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.impl;

import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.NoSuchIndexException;
import pl.edu.icm.yadda.service.search.indexing.IndexSession;
import pl.edu.icm.yadda.service.search.indexing.Indexer;
import pl.edu.icm.yadda.service.search.indexing.IndexingException;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.SearchModule;

public class IndexAdminImpl {
    private SearchModule searchModule;

    public IndexSession connect(String string, Object ... objectArray) throws SearchException {
        Index index = this.getIndex(string);
        Indexer indexer = index.getIndexer();
        if (indexer == null) {
            throw new IndexingException("Search index '" + string + "' does not have indexer.");
        }
        return indexer.connect(objectArray);
    }

    public void setActive(String string, boolean bl) throws SearchException {
        Index index = this.getIndex(string);
        index.setActive(bl);
    }

    public boolean indexExists(String string) throws SearchException {
        try {
            Index index = this.getIndex(string);
            return index != null;
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return false;
        }
    }

    public void optimize(String string) throws SearchException {
        Indexer indexer = this.getIndexer(string);
        indexer.optimize();
    }

    public void recreate(String string) throws SearchException {
        Indexer indexer = this.getIndexer(string);
        indexer.recreate();
    }

    public SearchModule getSearchModule() {
        return this.searchModule;
    }

    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }

    private Index getIndex(String string) throws NoSuchIndexException {
        return this.searchModule.getIndex(string);
    }

    private Indexer getIndexer(String string) throws NoSuchIndexException, IndexingException {
        Index index = this.getIndex(string);
        Indexer indexer = index.getIndexer();
        if (indexer == null) {
            throw new IndexingException("Search index '" + string + "' does not have indexer.");
        }
        return indexer;
    }
}

