/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.indexing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.indexing.IndexDocument;
import pl.edu.icm.yadda.service.search.indexing.IndexSession;
import pl.edu.icm.yadda.service.search.indexing.impl.document.LuceneDocument;
import pl.edu.icm.yadda.service.search.indexing.impl.document.LuceneDocumentMapper;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.config.PhysicalLuceneIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSessionImpl
implements IndexSession {
    protected Date expirationTime;
    protected long EXPIRE_PERIOD = 3600000L;
    private String sessionId;
    private PhysicalLuceneIndex physicalLuceneIndex;
    private LuceneDocumentMapper documentMapper;
    private Index searchIndex;
    private boolean closed = false;

    public IndexSessionImpl(String string, PhysicalLuceneIndex physicalLuceneIndex, LuceneDocumentMapper luceneDocumentMapper, Index index) throws SearchException {
        this.sessionId = string;
        this.physicalLuceneIndex = physicalLuceneIndex;
        this.documentMapper = luceneDocumentMapper;
        this.searchIndex = index;
        this.physicalLuceneIndex.open();
        this.touch();
    }

    public synchronized void add(Collection<IndexDocument> collection) throws SearchException {
        if (this.closed) {
            throw new SearchException("Session " + this.sessionId + " has been closed");
        }
        this.physicalLuceneIndex.addDocuments(this.mapDocuments(collection));
        this.touch();
    }

    public synchronized void delete(Collection<String> collection) throws SearchException {
        if (this.closed) {
            throw new SearchException("Session " + this.sessionId + " has been closed");
        }
        this.physicalLuceneIndex.deleteDocuments(collection);
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws SearchException {
        if (this.closed) {
            throw new SearchException("Session " + this.sessionId + " has been closed");
        }
        try {
            this.physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.COMMIT);
        }
        finally {
            this.closed = true;
        }
        if (this.searchIndex != null) {
            try {
                this.searchIndex.doIndexChangedEvent();
            }
            catch (SearchException searchException) {
                throw new SearchException("Commit failed while populating index changed event", (Throwable)searchException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SearchException {
        if (this.closed) {
            throw new SearchException("Session " + this.sessionId + " has been closed");
        }
        try {
            this.physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.ROLLBACK);
        }
        finally {
            this.closed = true;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isAutoCommit() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setAutoCommit(boolean bl) {
    }

    public void setReadOnly(boolean bl) {
    }

    private Collection<LuceneDocument> mapDocuments(Collection<IndexDocument> collection) throws SearchException {
        ArrayList<LuceneDocument> arrayList = new ArrayList<LuceneDocument>(collection.size());
        for (IndexDocument indexDocument : collection) {
            arrayList.add(this.documentMapper.mapDocument(indexDocument));
        }
        return arrayList;
    }

    public void touch() {
        this.expirationTime = new Date(new Date().getTime() + this.EXPIRE_PERIOD);
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return new Date().after(this.expirationTime);
    }

    public synchronized void destroy() throws SearchException {
        if (!this.closed) {
            this.rollback();
        }
    }

    public boolean isOpened() {
        return !this.closed;
    }
}

