/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.indexing.impl;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.IndexAlreadyOpenedException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.errors.SearchMultiExceptionFactory;
import pl.edu.icm.yadda.service.search.indexing.IndexSession;
import pl.edu.icm.yadda.service.search.indexing.Indexer;
import pl.edu.icm.yadda.service.search.indexing.impl.IndexSessionImpl;
import pl.edu.icm.yadda.service.search.indexing.impl.document.LuceneDocumentMapper;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.config.IndexConfiguration;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationSingle;
import pl.edu.icm.yadda.service.search.module.config.PhysicalLuceneIndex;

public class IndexerImpl
implements Indexer {
    private static final Log log = LogFactory.getLog(IndexerImpl.class);
    private String id;
    private IndexConfigurationSingle indexConfiguration;
    private Index index;
    private boolean destroyed = false;
    private IndexSession currentSession;
    private Object sessionLock = new Object();
    private int sessionCount = 0;

    public void init(Index index) throws SearchException {
        if (!index.isSingle()) {
            throw new SearchConfigException("Indexer expects single index at initialization (actual index class: " + this.index.getClass() + ").");
        }
        this.index = index;
        IndexConfiguration indexConfiguration = this.index.getIndexConfiguration();
        if (indexConfiguration == null) {
            throw new SearchConfigException("Indexer '" + this.id + "' has null index configuration.");
        }
        if (!(indexConfiguration instanceof IndexConfigurationSingle)) {
            throw new SearchConfigException("Indexer expects index configuration to be of type IndexConfigurationSingle (was: " + indexConfiguration.getClass().getCanonicalName() + ")");
        }
        this.indexConfiguration = (IndexConfigurationSingle)this.index.getIndexConfiguration();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSession connect(Object ... objectArray) throws SearchException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.destroyed) {
                throw new SearchException("Indexer " + this.id + " has been destroyed");
            }
            if (this.currentSession != null && this.currentSession.isOpened()) {
                throw new SearchException("Another index session is already opened (indexer: " + this.id + ")");
            }
            String string = this.id + "." + System.currentTimeMillis() + "." + this.sessionCount;
            LuceneDocumentMapper luceneDocumentMapper = new LuceneDocumentMapper(this.indexConfiguration.getIndexMetadata());
            this.currentSession = new IndexSessionImpl(string, this.indexConfiguration.getPhysicalLuceneIndex(), luceneDocumentMapper, this.index);
            return this.currentSession;
        }
    }

    public void recreate() throws SearchException {
        if (this.destroyed) {
            throw new SearchException("Indexer " + this.id + " has been destroyed");
        }
        PhysicalLuceneIndex physicalLuceneIndex = this.indexConfiguration.getPhysicalLuceneIndex();
        try {
            physicalLuceneIndex.open();
            physicalLuceneIndex.recreate();
            physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.COMMIT);
        }
        catch (IndexAlreadyOpenedException indexAlreadyOpenedException) {
            throw indexAlreadyOpenedException;
        }
        catch (SearchException searchException) {
            if (physicalLuceneIndex.isOpened()) {
                try {
                    physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.ROLLBACK);
                }
                catch (Exception exception) {
                    log.error((Object)("Couldn't close physical lucene index while in catch block of another error (indexer: " + this.id + ")"), (Throwable)exception);
                }
            }
            throw searchException;
        }
        this.index.doIndexChangedEvent();
    }

    public void optimize() throws SearchException {
        if (this.destroyed) {
            throw new SearchException("Indexer " + this.id + " has been destroyed");
        }
        PhysicalLuceneIndex physicalLuceneIndex = this.indexConfiguration.getPhysicalLuceneIndex();
        try {
            physicalLuceneIndex.open();
            physicalLuceneIndex.optimize();
            physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.COMMIT);
        }
        catch (IndexAlreadyOpenedException indexAlreadyOpenedException) {
            throw indexAlreadyOpenedException;
        }
        catch (SearchException searchException) {
            if (physicalLuceneIndex.isOpened()) {
                try {
                    physicalLuceneIndex.close(PhysicalLuceneIndex.CloseMode.ROLLBACK);
                }
                catch (Exception exception) {
                    log.error((Object)("Couldn't close physical lucene index " + this.id + " while in catch block of another error"), (Throwable)exception);
                }
            }
            throw searchException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws SearchException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        ArrayList<SearchException> arrayList = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.currentSession != null && this.currentSession.isOpened()) {
                try {
                    this.currentSession.destroy();
                }
                catch (SearchException searchException) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<SearchException>();
                    }
                    arrayList.add(searchException);
                }
                finally {
                    this.currentSession = null;
                }
            }
        }
        object = this.indexConfiguration.getPhysicalLuceneIndex();
        if (object.isOpened()) {
            try {
                object.close(PhysicalLuceneIndex.CloseMode.ROLLBACK);
            }
            catch (SearchException searchException) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(searchException);
            }
        }
        if (!Utils.emptyCollection(arrayList)) {
            throw SearchMultiExceptionFactory.createException("Error while destroying indexer " + this.id, arrayList);
        }
    }
}

