/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.indexing.impl.document;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import pl.edu.icm.yadda.service.search.indexing.IndexingException;

public class LuceneDocument {
    private static final long serialVersionUID = 6808040789075537283L;
    public static final String ID_FIELD = "__DOCID__";
    private final String id;
    private final Document luceneDocument;

    public LuceneDocument(Document document, String string) throws IndexingException {
        this.luceneDocument = document;
        this.id = string;
        Field field = document.getField(ID_FIELD);
        if (field != null) {
            throw new IndexingException("Lucene document contains field with reserved name ('__DOCID__')");
        }
        document.add((Fieldable)new Field(ID_FIELD, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
    }

    public Document getDocument() {
        return this.luceneDocument;
    }

    public String getId() {
        return this.id;
    }
}

