/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.indexing.impl.document;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import pl.edu.icm.yadda.service.search.indexing.DocumentField;
import pl.edu.icm.yadda.service.search.indexing.IndexDocument;
import pl.edu.icm.yadda.service.search.indexing.IndexingException;
import pl.edu.icm.yadda.service.search.indexing.impl.LuceneUtils;
import pl.edu.icm.yadda.service.search.indexing.impl.document.LuceneDocument;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;

public class LuceneDocumentMapper {
    IndexMetadata indexMetadata;
    public static final int SORT_LENGTH = 15;

    public LuceneDocumentMapper(IndexMetadata indexMetadata) {
        this.indexMetadata = indexMetadata;
    }

    public LuceneDocument mapDocument(IndexDocument indexDocument) throws IndexingException {
        if (indexDocument.getId() == null) {
            throw new IndexingException("Index document without id!");
        }
        Document document = new Document();
        for (DocumentField documentField : indexDocument.getFields()) {
            String string;
            String string2 = documentField.getName();
            FieldMetadata fieldMetadata = this.indexMetadata.getFieldMetadata(string2);
            if (fieldMetadata == null) {
                throw new IndexingException("Mapping Lucene document error - unknown index field '" + string2 + "'");
            }
            Field field = null;
            switch (documentField.getFieldType()) {
                case READER: {
                    if (fieldMetadata.getStored() != Field.Store.NO) {
                        throw new IndexingException("Document field with reader value can not be stored (field name: " + string2 + ")");
                    }
                    if (fieldMetadata.getIndexed() != Field.Index.TOKENIZED) {
                        throw new IndexingException("Document field with reader value must be tokenized (field name: " + string2 + ")");
                    }
                    if (fieldMetadata.isSortable()) {
                        throw new IndexingException("Sortable document field can not have reader value (field name: " + string2 + ")");
                    }
                    if (fieldMetadata.getSpan() >= 0) {
                        throw new IndexingException("Span document field can not have reader value (field name: " + string2 + ")");
                    }
                    field = new Field(string2, documentField.getReaderValue());
                    break;
                }
                case BINARY: {
                    if (fieldMetadata.getIndexed() != Field.Index.NO) {
                        throw new IndexingException("Binary document field can not be indexed (field name: " + string2 + ")");
                    }
                    if (fieldMetadata.getStored() == Field.Store.NO) {
                        throw new IndexingException("Binary document field must be stored (field name: " + string2 + ")");
                    }
                    field = new Field(string2, documentField.getBinaryValue(), fieldMetadata.getStored());
                    break;
                }
                case STRING: {
                    string = documentField.getStringValue();
                    field = new Field(string2, string, fieldMetadata.getStored(), fieldMetadata.getIndexed());
                }
            }
            if (fieldMetadata.isSortable()) {
                if (document.get(string2) != null) {
                    throw new IndexingException("Mapping Lucene document error - sortable field '" + string2 + "' has more than one value.");
                }
                if (fieldMetadata.getIndexed() != Field.Index.UN_TOKENIZED) {
                    string = LuceneUtils.getSortField(string2, fieldMetadata);
                    String string3 = field.stringValue().trim();
                    if (string3.length() > 15) {
                        string3 = string3.substring(0, 15);
                    }
                    string3 = string3.toLowerCase();
                    document.add((Fieldable)new Field(string, string3, Field.Store.NO, Field.Index.UN_TOKENIZED));
                }
            }
            document.add(field);
        }
        return new LuceneDocument(document, indexDocument.getId());
    }
}

