/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Field;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.config.AnalyzerFactory;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.impl.PerFieldWithVariantsAnalyzerWrapper;

public class AnalyzerFactoryMetadataImpl
implements AnalyzerFactory {
    private static final Log log = LogFactory.getLog(AnalyzerFactoryMetadataImpl.class);
    private PerFieldWithVariantsAnalyzerWrapper analyzerInstance;

    public AnalyzerFactoryMetadataImpl(IndexMetadata indexMetadata) throws SearchConfigException {
        try {
            HashMap<Class<? extends Analyzer>, Analyzer> hashMap = new HashMap<Class<? extends Analyzer>, Analyzer>();
            Analyzer analyzer = null;
            Class<? extends Analyzer> clazz = indexMetadata.getDefaultAnalyzerClass();
            if (clazz != null) {
                analyzer = clazz.newInstance();
                hashMap.put(indexMetadata.getDefaultAnalyzerClass(), analyzer);
            }
            KeywordAnalyzer keywordAnalyzer = new KeywordAnalyzer();
            this.analyzerInstance = new PerFieldWithVariantsAnalyzerWrapper(analyzer);
            for (FieldMetadata fieldMetadata : indexMetadata.getAllFieldsMetadata()) {
                Class<? extends Analyzer> clazz2 = fieldMetadata.getAnalyzerClass();
                if (clazz2 != null) {
                    Analyzer analyzer2 = (Analyzer)hashMap.get(clazz2);
                    if (analyzer2 == null) {
                        analyzer2 = clazz2.newInstance();
                        hashMap.put(clazz2, analyzer2);
                    }
                    this.analyzerInstance.addAnalyzer(fieldMetadata.getName(), analyzer2);
                } else if (fieldMetadata.getIndexed() == Field.Index.UN_TOKENIZED) {
                    this.analyzerInstance.addAnalyzer(fieldMetadata.getName(), (Analyzer)keywordAnalyzer);
                }
                if (!fieldMetadata.isSpan()) continue;
                this.analyzerInstance.setSpan(fieldMetadata.getName(), fieldMetadata.getSpan());
            }
        }
        catch (Exception exception) {
            log.error((Object)"Error occured during analyzer factory initialization.", (Throwable)exception);
            throw new SearchConfigException("Error occured during analyzer factory initialization.", exception);
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzerInstance;
    }
}

