/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMetadataImpl
implements FieldMetadata {
    private String name;
    private Field.Index indexed;
    private Field.Store stored;
    private Field.TermVector termVector;
    private int span = -1;
    private Class<? extends Analyzer> analyzerClass;
    private boolean sortable = false;

    public FieldMetadataImpl() {
    }

    public FieldMetadataImpl(String string, Field.Index index, Field.Store store) throws SearchConfigException {
        this.setName(string);
        this.setIndexed(index);
        this.setStored(store);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Class<? extends Analyzer> getAnalyzerClass() {
        return this.analyzerClass;
    }

    @Override
    public void setAnalyzerClass(Class<? extends Analyzer> clazz) throws SearchConfigException {
        if (this.analyzerClass != null) {
            throw new SearchConfigException("More than one analyzer class for field '" + this.name + "'");
        }
        this.analyzerClass = clazz;
    }

    @Override
    public Field.Index getIndexed() {
        return this.indexed;
    }

    @Override
    public void setIndexed(Field.Index index) throws SearchConfigException {
        if (this.indexed != null) {
            throw new SearchConfigException("More than one 'indexed' property for field '" + this.name + "'");
        }
        this.indexed = index;
    }

    @Override
    public Field.Store getStored() {
        return this.stored;
    }

    @Override
    public void setStored(Field.Store store) throws SearchConfigException {
        if (this.stored != null) {
            throw new SearchConfigException("More than one 'stored' property for field '" + this.name + "'");
        }
        this.stored = store;
    }

    @Override
    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    @Override
    public void setTermVector(Field.TermVector termVector) throws SearchConfigException {
        if (this.indexed != null) {
            throw new SearchConfigException("More than one 'termVector' property for field '" + this.name + "'");
        }
        this.termVector = termVector;
    }

    @Override
    public int getSpan() {
        return this.span;
    }

    @Override
    public void setSpan(int n) throws SearchConfigException {
        if (this.isSpan()) {
            throw new SearchConfigException("More than one 'span' property for field '" + this.name + "'");
        }
        this.span = n;
    }

    @Override
    public boolean isSpan() {
        return this.span >= 0;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldMetadataImpl)) {
            return false;
        }
        FieldMetadataImpl fieldMetadataImpl = (FieldMetadataImpl)object;
        return this.safeEqualObjects(this.name, fieldMetadataImpl.name) && this.safeEqualObjects(this.indexed, fieldMetadataImpl.indexed) && this.safeEqualObjects(this.stored, fieldMetadataImpl.stored) && this.safeEqualObjects(this.analyzerClass, fieldMetadataImpl.analyzerClass) && this.safeEqualObjects(this.termVector, fieldMetadataImpl.termVector) && this.span == fieldMetadataImpl.span && this.sortable == fieldMetadataImpl.sortable;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.indexed).append((Object)this.stored).append(this.analyzerClass).append((Object)this.termVector).append(this.span).append(this.sortable).toHashCode();
    }

    private final boolean safeEqualObjects(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("field '" + this.name + "' :: ");
        if (this.indexed == Field.Index.NO) {
            stringBuffer.append("unindexed, untokenized, ");
        } else if (this.indexed == Field.Index.TOKENIZED) {
            stringBuffer.append("indexed, tokenized, ");
        } else if (this.indexed == Field.Index.UN_TOKENIZED) {
            stringBuffer.append("indexed, untokenized, ");
        }
        if (this.stored == Field.Store.YES) {
            stringBuffer.append("stored, ");
        } else if (this.stored == Field.Store.NO) {
            stringBuffer.append("unstored, ");
        } else if (this.stored == Field.Store.COMPRESS) {
            stringBuffer.append("compressed, ");
        }
        if (this.isSpan()) {
            stringBuffer.append("span ").append(this.span).append(", ");
        }
        stringBuffer.append("analyzer=").append(this.analyzerClass == null ? null : this.analyzerClass.getCanonicalName());
        return stringBuffer.toString();
    }
}

