/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.MultiIndex;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationMulti;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;
import pl.edu.icm.yadda.service.search.module.config.impl.IndexConfigurationImpl;
import pl.edu.icm.yadda.service.search.module.config.impl.LuceneSearcherDataMultiImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexConfigurationMultiImpl
extends IndexConfigurationImpl
implements IndexConfigurationMulti {
    private static final Log log = LogFactory.getLog(IndexConfigurationMultiImpl.class);
    private List<Index> subindexes;
    private boolean initialized;
    private boolean emptySubindexListAllowed;

    @Override
    public void init() throws SearchConfigException {
        if (!this.initialized) {
            this.initialized = true;
            super.init();
            if (Utils.emptyCollection(this.subindexes)) {
                if (this.emptySubindexListAllowed) {
                    if (this.subindexes == null) {
                        this.subindexes = new ArrayList<Index>();
                    }
                } else {
                    throw new SearchConfigException("Multi index configuration has empty subindexes list");
                }
            }
        }
    }

    @Override
    public LuceneSearcherData createLuceneSearcher() throws SearchException {
        try {
            LuceneSearcherData luceneSearcherData2;
            ArrayList<LuceneSearcherData> arrayList = new ArrayList<LuceneSearcherData>();
            for (Index index : this.subindexes) {
                if (!index.isActive()) continue;
                this.buildListOfSearchers(index, arrayList);
            }
            if (arrayList.isEmpty()) {
                log.warn((Object)("No subindexes exist or all subindexes of multi index '" + this.indexId + "' are inactive."));
                return null;
            }
            long l = 0L;
            int n = 0;
            Searchable[] searchableArray = new Searchable[arrayList.size()];
            IndexReader[] indexReaderArray = new IndexReader[arrayList.size()];
            int n2 = 0;
            for (LuceneSearcherData luceneSearcherData2 : arrayList) {
                searchableArray[n2] = luceneSearcherData2.getSearcher();
                indexReaderArray[n2] = luceneSearcherData2.getIndexReader();
                ++n2;
                l += luceneSearcherData2.getIndexVersion();
                n += luceneSearcherData2.getDocumentsNumber();
            }
            MultiSearcher multiSearcher = new MultiSearcher(searchableArray);
            luceneSearcherData2 = new MultiReader(indexReaderArray, false);
            LuceneSearcherDataMultiImpl luceneSearcherDataMultiImpl = new LuceneSearcherDataMultiImpl((Searcher)multiSearcher, (IndexReader)luceneSearcherData2, this.indexMetadata, l, n);
            luceneSearcherDataMultiImpl.setSubsearchers(arrayList);
            return luceneSearcherDataMultiImpl;
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't create Lucene multi searcher.", (Throwable)exception);
        }
    }

    private void buildListOfSearchers(Index index, Collection<LuceneSearcherData> collection) throws SearchException {
        if (index.isActive()) {
            if (index.isSingle()) {
                collection.add(index.getLuceneSearcherData());
            } else {
                for (Index index2 : ((MultiIndex)index).getSubindexes()) {
                    this.buildListOfSearchers(index2, collection);
                }
            }
        }
    }

    @Override
    public List<Index> getSubindexes() {
        return this.subindexes;
    }

    @Override
    public void setSubindexes(List<Index> list) {
        this.subindexes = list;
    }

    @Override
    public void setEmptySubindexListAllowed(boolean bl) {
        this.emptySubindexListAllowed = bl;
    }
}

