/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationSingle;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;
import pl.edu.icm.yadda.service.search.module.config.PhysicalLuceneIndex;
import pl.edu.icm.yadda.service.search.module.config.impl.IndexConfigurationImpl;
import pl.edu.icm.yadda.service.search.module.config.impl.LuceneSearcherDataImpl;
import pl.edu.icm.yadda.service.search.module.config.impl.PhysicalLuceneIndexImpl;

public class IndexConfigurationSingleImpl
extends IndexConfigurationImpl
implements IndexConfigurationSingle {
    private String indexPath;
    private PhysicalLuceneIndex physicalLuceneIndex;
    private boolean initialized = false;

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String string) {
        this.indexPath = string;
    }

    public void init() throws SearchConfigException {
        if (!this.initialized) {
            this.initialized = true;
            super.init();
            if (Utils.emptyStr((String)this.indexPath)) {
                throw new SearchConfigException("Single index configuration has null index path");
            }
            this.physicalLuceneIndex = new PhysicalLuceneIndexImpl(this.indexPath, this.indexMetadata.getAnalyzerFactory());
        }
    }

    public PhysicalLuceneIndex getPhysicalLuceneIndex() {
        return this.physicalLuceneIndex;
    }

    public LuceneSearcherData createLuceneSearcher() throws SearchException {
        LuceneSearcherDataImpl luceneSearcherDataImpl = (LuceneSearcherDataImpl)this.getPhysicalLuceneIndex().createNativeLuceneSearcher();
        luceneSearcherDataImpl.setIndexMetadata(this.indexMetadata);
        return luceneSearcherDataImpl;
    }
}

