/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.indexing.IndexUtils;
import pl.edu.icm.yadda.service.search.module.config.AnalyzerFactory;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.impl.AnalyzerFactoryMetadataImpl;
import pl.edu.icm.yadda.service.search.module.config.impl.PropertiesMetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMetadataImpl
implements IndexMetadata {
    protected Class<? extends Analyzer> defaultAnalyzerClass;
    protected Map<String, FieldMetadata> fields = new HashMap<String, FieldMetadata>();
    protected Properties properties = new Properties();
    protected AnalyzerFactory analyzerFactory;

    @Override
    public void setConfigurationProperties(Properties properties) throws SearchConfigException {
        PropertiesMetadataFactory.parseMetadataProperties(properties, this);
    }

    public void setConfigurationResource(String string) throws Exception {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            throw new Exception("Index configuration resource [" + string + "] not found");
        }
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new Exception("Properties for index configuration couldn't be loaded from resource [" + string + "]", iOException);
        }
        this.setConfigurationProperties(properties);
    }

    @Override
    public String getSpecialConfigProperty(String string) {
        return Utils.trim((String)this.properties.getProperty(string));
    }

    @Override
    public void setSpecialConfigProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public Properties getSpecialConfigProperties() {
        return this.properties;
    }

    @Override
    public FieldMetadata getFieldMetadata(String string) {
        String string2;
        FieldMetadata fieldMetadata = this.fields.get(string);
        if (fieldMetadata == null && (string2 = IndexUtils.getFieldNameWithoutVariant((String)string)) != null) {
            fieldMetadata = this.fields.get(string2);
        }
        return fieldMetadata;
    }

    @Override
    public void addFieldMetadata(FieldMetadata fieldMetadata) throws SearchConfigException {
        String string = fieldMetadata.getName();
        if (this.fields.containsKey(string)) {
            throw new SearchConfigException("Field metadata for field '" + string + "' already exists");
        }
        this.fields.put(string, fieldMetadata);
    }

    @Override
    public Collection<FieldMetadata> getAllFieldsMetadata() {
        return this.fields.values();
    }

    public void setFieldsMetadata(Map<String, FieldMetadata> map) {
        this.fields = map;
    }

    @Override
    public Class<? extends Analyzer> getDefaultAnalyzerClass() {
        return this.defaultAnalyzerClass;
    }

    @Override
    public void setDefaultAnalyzerClass(Class<? extends Analyzer> clazz) throws SearchConfigException {
        if (this.defaultAnalyzerClass != null) {
            throw new SearchConfigException("Default analyzer class already exists");
        }
        this.defaultAnalyzerClass = clazz;
    }

    @Override
    public void init() throws SearchConfigException {
        if (this.analyzerFactory == null) {
            this.analyzerFactory = new AnalyzerFactoryMetadataImpl(this);
        }
    }

    @Override
    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }
}

